package test;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.management.*;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.*;

public class TestService extends ServiceMBeanSupport implements TestServiceMBean
{
    public void  start () throws Exception  
    {
        super.start();
        startSnmpAgent();
    }

    /**
     * Starts the MIB-II sample agent
     */
    private void startSnmpAgent()
    {
        try
        {
            System.out.println( "starting ireasoning agent .....................................................");
            com.ireasoning.util.Logger.setUseLog4j(true);
            com.ireasoning.util.Logger.setLevel( com.ireasoning.util.Logger.DEBUG );//set level to "ERROR"

            String configFile = "C:/config/SnmpAgent.xml";

            //IMPORTANT: the "server" object must be passed to Agent's constructor!!! Otherwise
            //a new MBeanServer will be created during agent startup and it will cause JBoss to 
            //behave differently.
            agent.mib2.Agent agent = new agent.mib2.Agent(server, 161, configFile);
            agent.start();
            System.out.println( "agent started .............................................." );
        }
        catch(Exception e)
        {
            System.err.println(e);
        }

    }
}// end of class TestService
