/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class DES
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel;
    private static final PrintWriter err;
    private static NativeLink linkStatus;
    private static final int ROUNDS = 16;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 8;
    private static final int INTERNAL_KEY_LENGTH = 32;
    private static final int[] SKB;
    private static final int[] SP_TRANS;
    private static final String[][] tests;
    private long native_cookie;
    private Object native_lock;
    private int[] sKey = new int[32];

    private static void debug(String string) {
        err.println("DES: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(DES.getLibMajorVersion(), DES.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    DES.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                DES.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native int[] native_crypt3(long var1, int var3, int var4);

    private native String native_finalize();

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    DES.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n2, int n3, byte[] byArray, int n4) {
        Object object2;
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 8;
        n3 = n5 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
            n2 = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n2 < 0 || (long)n2 + (long)n3 > (long)((byte[])object).length || n4 < 0 || (long)n4 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n2, byArray, n4, bl) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n2 += 8;
                    n4 += 8;
                    ++n6;
                }
            }
        } else {
            int n7 = 0;
            while (n7 < n5) {
                this.des((byte[])object, n2, byArray, n4, bl);
                n2 += 8;
                n4 += 8;
                ++n7;
            }
        }
        return n3;
    }

    private void makeKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 8) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var4_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        DES.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        int n2 = 0;
        int n3 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n4 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        int n5 = (n4 >>> 4 ^ n3) & 0xF0F0F0F;
        n3 ^= n5;
        n4 ^= n5 << 4;
        n5 = (n3 << 18 ^ n3) & 0xCCCC0000;
        n3 ^= n5 ^ n5 >>> 18;
        n5 = (n4 << 18 ^ n4) & 0xCCCC0000;
        n4 ^= n5 ^ n5 >>> 18;
        n5 = (n4 >>> 1 ^ n3) & 0x55555555;
        n3 ^= n5;
        n4 ^= n5 << 1;
        n5 = (n3 >>> 8 ^ n4) & 0xFF00FF;
        n4 ^= n5;
        n3 ^= n5 << 8;
        n5 = (n4 >>> 1 ^ n3) & 0x55555555;
        n4 ^= n5 << 1;
        n4 = (n4 & 0xFF) << 16 | n4 & 0xFF00 | (n4 & 0xFF0000) >>> 16 | ((n3 ^= n5) & 0xF0000000) >>> 4;
        n3 &= 0xFFFFFFF;
        int n6 = 0;
        n2 = 0;
        while (n2 < 16) {
            if ((32508 >> n2 & 1) == 1) {
                n3 = (n3 >>> 2 | n3 << 26) & 0xFFFFFFF;
                n4 = (n4 >>> 2 | n4 << 26) & 0xFFFFFFF;
            } else {
                n3 = (n3 >>> 1 | n3 << 27) & 0xFFFFFFF;
                n4 = (n4 >>> 1 | n4 << 27) & 0xFFFFFFF;
            }
            int n7 = SKB[n3 & 0x3F] | SKB[0x40 | (n3 >>> 6 & 3 | n3 >>> 7 & 0x3C)] | SKB[0x80 | (n3 >>> 13 & 0xF | n3 >>> 14 & 0x30)] | SKB[0xC0 | (n3 >>> 20 & 1 | n3 >>> 21 & 6 | n3 >>> 22 & 0x38)];
            n5 = SKB[0x100 | n4 & 0x3F] | SKB[0x140 | (n4 >>> 7 & 3 | n4 >>> 8 & 0x3C)] | SKB[0x180 | n4 >>> 15 & 0x3F] | SKB[0x1C0 | (n4 >>> 21 & 0xF | n4 >>> 22 & 0x30)];
            this.sKey[n6++] = n5 << 16 | n7 & 0xFFFF;
            n7 = n7 >>> 16 | n5 & 0xFFFF0000;
            this.sKey[n6++] = n7 << 4 | n7 >>> 28;
            ++n2;
        }
    }

    protected void des(byte[] byArray, int n2, byte[] byArray2, int n3, boolean bl) {
        int[] nArray = new int[]{byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24, byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2] & 0xFF) << 24};
        DES.initialPermutation(nArray);
        if (bl) {
            this.encrypt_base(nArray);
        } else {
            this.decrypt_base(nArray);
        }
        DES.finalPermutation(nArray);
        int n4 = nArray[0];
        int n5 = nArray[1];
        byArray2[n3++] = (byte)n5;
        byArray2[n3++] = (byte)(n5 >> 8);
        byArray2[n3++] = (byte)(n5 >> 16);
        byArray2[n3++] = (byte)(n5 >> 24);
        byArray2[n3++] = (byte)n4;
        byArray2[n3++] = (byte)(n4 >> 8);
        byArray2[n3++] = (byte)(n4 >> 16);
        byArray2[n3] = (byte)(n4 >> 24);
    }

    private void encrypt_base(int[] nArray) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = n3 << 1 | n3 >>> 31;
        n3 = n2 << 1 | n2 >>> 31;
        n2 = n4;
        int n5 = 0;
        while (n5 < 32) {
            n4 = n3 ^ this.sKey[n5++];
            int n6 = n3 ^ this.sKey[n5++];
            n6 = n6 >>> 4 | n6 << 28;
            n2 ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n4 & 0x3F] | SP_TRANS[0x80 | n4 >>> 8 & 0x3F] | SP_TRANS[0x100 | n4 >>> 16 & 0x3F] | SP_TRANS[0x180 | n4 >>> 24 & 0x3F];
            n4 = n2 ^ this.sKey[n5++];
            n6 = n2 ^ this.sKey[n5++];
            n6 = n6 >>> 4 | n6 << 28;
            n3 ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n4 & 0x3F] | SP_TRANS[0x80 | n4 >>> 8 & 0x3F] | SP_TRANS[0x100 | n4 >>> 16 & 0x3F] | SP_TRANS[0x180 | n4 >>> 24 & 0x3F];
        }
        nArray[0] = n3 >>> 1 | n3 << 31;
        nArray[1] = n2 >>> 1 | n2 << 31;
    }

    private void decrypt_base(int[] nArray) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = n3 << 1 | n3 >>> 31;
        n3 = n2 << 1 | n2 >>> 31;
        n2 = n4;
        int n5 = 31;
        while (n5 > 0) {
            int n6 = n3 ^ this.sKey[n5--];
            n4 = n3 ^ this.sKey[n5--];
            n6 = n6 >>> 4 | n6 << 28;
            n2 ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n4 & 0x3F] | SP_TRANS[0x80 | n4 >>> 8 & 0x3F] | SP_TRANS[0x100 | n4 >>> 16 & 0x3F] | SP_TRANS[0x180 | n4 >>> 24 & 0x3F];
            n6 = n2 ^ this.sKey[n5--];
            n4 = n2 ^ this.sKey[n5--];
            n6 = n6 >>> 4 | n6 << 28;
            n3 ^= SP_TRANS[0x40 | n6 & 0x3F] | SP_TRANS[0xC0 | n6 >>> 8 & 0x3F] | SP_TRANS[0x140 | n6 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n6 >>> 24 & 0x3F] | SP_TRANS[n4 & 0x3F] | SP_TRANS[0x80 | n4 >>> 8 & 0x3F] | SP_TRANS[0x100 | n4 >>> 16 & 0x3F] | SP_TRANS[0x180 | n4 >>> 24 & 0x3F];
        }
        nArray[0] = n3 >>> 1 | n3 << 31;
        nArray[1] = n2 >>> 1 | n2 << 31;
    }

    private static void initialPermutation(int[] nArray) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = (n3 >>> 4 ^ n2) & 0xF0F0F0F;
        n2 ^= n4;
        n3 ^= n4 << 4;
        n4 = (n2 >>> 16 ^ n3) & 0xFFFF;
        n3 ^= n4;
        n2 ^= n4 << 16;
        n4 = (n3 >>> 2 ^ n2) & 0x33333333;
        n2 ^= n4;
        n3 ^= n4 << 2;
        n4 = (n2 >>> 8 ^ n3) & 0xFF00FF;
        n3 ^= n4;
        n2 ^= n4 << 8;
        n4 = (n3 >>> 1 ^ n2) & 0x55555555;
        nArray[0] = n2 ^ n4;
        nArray[1] = n3 ^ n4 << 1;
    }

    private static void finalPermutation(int[] nArray) {
        int n2 = nArray[1];
        int n3 = nArray[0];
        int n4 = (n3 >>> 1 ^ n2) & 0x55555555;
        n2 ^= n4;
        n3 ^= n4 << 1;
        n4 = (n2 >>> 8 ^ n3) & 0xFF00FF;
        n3 ^= n4;
        n2 ^= n4 << 8;
        n4 = (n3 >>> 2 ^ n2) & 0x33333333;
        n2 ^= n4;
        n3 ^= n4 << 2;
        n4 = (n2 >>> 16 ^ n3) & 0xFFFF;
        n3 ^= n4;
        n2 ^= n4 << 16;
        n4 = (n3 >>> 4 ^ n2) & 0xF0F0F0F;
        nArray[1] = n2 ^ n4;
        nArray[0] = n3 ^ n4 << 4;
    }

    public int[] crypt3(int n2, int n3) {
        int n4;
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                int[] nArray = this.native_crypt3(this.native_cookie, n2, n3);
                if (nArray == null) {
                    throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                }
                int[] nArray2 = nArray;
                Object var4_9 = null;
                return nArray2;
            }
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < 25) {
            int n8 = 0;
            while (n8 < 32) {
                int n9 = n6 ^ n6 >>> 16;
                int n10 = n9 & n2;
                n10 ^= n10 << 16 ^ n6 ^ this.sKey[n8++];
                n4 = (n9 &= n3) ^ n9 << 16 ^ n6 ^ this.sKey[n8++];
                n4 = n4 >>> 4 | n4 << 28;
                n9 = (n5 ^= SP_TRANS[0x40 | n4 & 0x3F] | SP_TRANS[0xC0 | n4 >>> 8 & 0x3F] | SP_TRANS[0x140 | n4 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n4 >>> 24 & 0x3F] | SP_TRANS[n10 & 0x3F] | SP_TRANS[0x80 | n10 >>> 8 & 0x3F] | SP_TRANS[0x100 | n10 >>> 16 & 0x3F] | SP_TRANS[0x180 | n10 >>> 24 & 0x3F]) ^ n5 >>> 16;
                n10 = n9 & n2;
                n10 ^= n10 << 16 ^ n5 ^ this.sKey[n8++];
                n4 = (n9 &= n3) ^ n9 << 16 ^ n5 ^ this.sKey[n8++];
                n4 = n4 >>> 4 | n4 << 28;
                n6 ^= SP_TRANS[0x40 | n4 & 0x3F] | SP_TRANS[0xC0 | n4 >>> 8 & 0x3F] | SP_TRANS[0x140 | n4 >>> 16 & 0x3F] | SP_TRANS[0x1C0 | n4 >>> 24 & 0x3F] | SP_TRANS[n10 & 0x3F] | SP_TRANS[0x80 | n10 >>> 8 & 0x3F] | SP_TRANS[0x100 | n10 >>> 16 & 0x3F] | SP_TRANS[0x180 | n10 >>> 24 & 0x3F];
            }
            n4 = n5;
            n5 = n6;
            n6 = n4;
            ++n7;
        }
        n4 = n5;
        n5 = n6 >>> 1 | n6 << 31;
        n6 = n4 >>> 1 | n4 << 31;
        n4 = (n6 >>> 1 ^ n5) & 0x55555555;
        n5 ^= n4;
        n6 ^= n4 << 1;
        n4 = (n5 >>> 8 ^ n6) & 0xFF00FF;
        n6 ^= n4;
        n5 ^= n4 << 8;
        n4 = (n6 >>> 2 ^ n5) & 0x33333333;
        n5 ^= n4;
        n6 ^= n4 << 2;
        n4 = (n5 >>> 16 ^ n6) & 0xFFFF;
        n6 ^= n4;
        n5 ^= n4 << 16;
        n4 = (n6 >>> 4 ^ n5) & 0xF0F0F0F;
        int[] nArray = new int[]{n5 ^ n4, n6 ^ n4 << 4};
        return nArray;
    }

    public static void main(String[] stringArray) {
        try {
            DES.self_test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void self_test() throws Exception {
        Cipher cipher = Cipher.getInstance("DES", "Cryptix");
        int n2 = 0;
        while (n2 < tests.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("DES", Hex.fromString(tests[n2][0]));
            byte[] byArray = Hex.fromString(tests[n2][1]);
            byte[] byArray2 = Hex.fromString(tests[n2][2]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray3 = cipher.crypt(byArray);
            if (!ArrayUtil.areEqual(byArray2, byArray3)) {
                throw new CryptixException("encrypt #" + n2 + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray3 = cipher.crypt(byArray2);
            if (!ArrayUtil.areEqual(byArray, byArray3)) {
                throw new CryptixException("decrypt #" + n2 + " failed");
            }
            ++n2;
        }
        if (debuglevel > 0) {
            DES.debug("Self-test OK");
        }
    }

    public DES() {
        super(false, false, "Cryptix");
        this.link();
    }

    static {
        int n2;
        int n3;
        debuglevel = Debug.getLevel("DES");
        err = Debug.getOutput();
        linkStatus = new NativeLink("DES", 2, 3);
        SKB = new int[512];
        SP_TRANS = new int[512];
        String string = "D]PKESYM`UBJ\\@RXA`I[T`HC`LZQ\\PB]TL`[C`JQ@Y`HSXDUIZRAM`EK";
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < string.length()) {
            int n7 = string.charAt(n6) - 64;
            if (n7 != 32) {
                n3 = 1 << n4++;
                n2 = 0;
                while (n2 < 64) {
                    if ((n3 & n2) != 0) {
                        int n8 = n5 + n2;
                        SKB[n8] = SKB[n8] | 1 << n7;
                    }
                    ++n2;
                }
                if (n4 == 6) {
                    n5 += 64;
                    n4 = 0;
                }
            }
            ++n6;
        }
        String string2 = "g3H821:80:H03BA0@N1290BAA88::3112aIH8:8282@0@AH0:1W3A8P810@22;22A18^@9H9@129:<8@822`?:@0@8PH2H81A19:G1@03403A0B1;:0@1g192:@919AA0A109:W21492H@0051919811:215011139883942N8::3112A2:31981jM118::A101@I88:1aN0<@030128:X;811`920:;H0310D1033@W980:8A4@804A3803o1A2021B2:@1AH023GA:8:@81@@12092B:098042P@:0:A0HA9>1;289:@1804:40Ph=1:H0I0HP0408024bC9P8@I808A;@0@0PnH0::8:19J@818:@iF0398:8A9H0<13@001@11<8;@82B01P0a2989B:0AY0912889bD0A1@B1A0A0AB033O91182440A9P8@I80n@1I03@1J828212A`A8:12B1@19A9@9@8^B:0@H00<82AB030bB840821Q:8310A302102::A1::20A1;8";
        n5 = 0;
        int n9 = 0;
        while (n9 < 32) {
            int n10 = -1;
            n3 = 1 << n9;
            n2 = 0;
            while (n2 < 32) {
                int n11 = string2.charAt(n5 >> 1) - 48 >> (n5 & 1) * 3 & 7;
                ++n5;
                if (n11 < 5) {
                    int n12 = n10 += n11 + 1;
                    SP_TRANS[n12] = SP_TRANS[n12] | n3;
                } else {
                    int n13 = string2.charAt(n5 >> 1) - 48 >> (n5 & 1) * 3 & 7;
                    ++n5;
                    if (n11 == 5) {
                        int n14 = n10 += n13 + 6;
                        SP_TRANS[n14] = SP_TRANS[n14] | n3;
                    } else if (n11 == 6) {
                        int n15 = n10 += (n13 << 6) + 1;
                        SP_TRANS[n15] = SP_TRANS[n15] | n3;
                    } else {
                        n10 += n13 << 6;
                        --n2;
                    }
                }
                ++n2;
            }
            ++n9;
        }
        tests = new String[][]{{"0101010101010101", "95f8a5e5dd31d900", "8000000000000000"}, {"0101010101010101", "dd7f121ca5015619", "4000000000000000"}, {"0101010101010101", "2e8653104f3834ea", "2000000000000000"}};
    }
}

