/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.provider.cipher.DES;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public class DES2X
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("DESX");
    private static final PrintWriter err = Debug.getOutput();
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 32;
    private static final int SINGLE_KEY_LENGTH = 8;
    private Cipher des = new DES();
    private byte[] XORkey1 = null;
    private byte[] XORkey2 = null;
    private byte[] XORkey3 = null;

    private static void debug(String string) {
        err.println("DESX: " + string);
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        byte[][] byArray = this.splitKey(key);
        RawSecretKey rawSecretKey = new RawSecretKey("DES", byArray[0]);
        this.des.initEncrypt(rawSecretKey);
        this.XORkey1 = byArray[1];
        this.XORkey2 = byArray[2];
        this.XORkey3 = byArray[3];
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        byte[][] byArray = this.splitKey(key);
        RawSecretKey rawSecretKey = new RawSecretKey("DES", byArray[0]);
        this.des.initDecrypt(rawSecretKey);
        this.XORkey1 = byArray[3];
        this.XORkey2 = byArray[2];
        this.XORkey3 = byArray[1];
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = new byte[n3];
        int n5 = 0;
        while (n5 < n3) {
            byArray3[n5] = (byte)(byArray[n5 + n2] ^ this.XORkey1[n5 % 8]);
            ++n5;
        }
        this.des.update(byArray3, 0, n3, byArray3, 0);
        n5 = 0;
        while (n5 < n3) {
            int n6 = n5;
            byArray3[n6] = (byte)(byArray3[n6] ^ this.XORkey2[n5 % 8]);
            ++n5;
        }
        this.des.update(byArray3, 0, n3, byArray3, 0);
        n5 = 0;
        while (n5 < n3) {
            byArray2[n5 + n4] = (byte)(byArray3[n5] ^ this.XORkey3[n5 % 8]);
            ++n5;
        }
        return n3;
    }

    private byte[][] splitKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        byte[][] byArray2 = new byte[4][8];
        int n2 = 0;
        while (n2 < 4) {
            System.arraycopy(byArray, n2 * 8, byArray2[n2], 0, 8);
            ++n2;
        }
        return byArray2;
    }

    public DES2X() {
        super(false, false, "Cryptix");
    }
}

