/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class IDEA
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("IDEA");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("IDEA", 2, 3);
    private static final int ROUNDS = 8;
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 16;
    private static final int INTERNAL_KEY_LENGTH = 52;
    private static final byte[][][] tests = new byte[][][]{{{0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8}, {0, 0, 0, 1, 0, 2, 0, 3}, {17, -5, -19, 43, 1, -104, 109, -27}}, {{58, -104, 78, 32, 0, 25, 93, -77, 46, -27, 1, -56, -60, 124, -22, 96}, {1, 2, 3, 4, 5, 6, 7, 8}, {-105, -68, -40, 32, 7, -128, -38, -122}}, {{0, 100, 0, -56, 1, 44, 1, -112, 1, -12, 2, 88, 2, -68, 3, 32}, {5, 50, 10, 100, 20, -56, 25, -6}, {101, -66, -121, -25, -94, 83, -118, -19}}};
    private long native_cookie;
    private Object native_lock;
    private short[] ks = new short[52];

    private static void debug(String string) {
        err.println("IDEA: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(IDEA.getLibMajorVersion(), IDEA.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    IDEA.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                IDEA.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    IDEA.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return 8;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException, CryptixException {
        this.makeKey(key);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.makeKey(key);
        this.invertKey();
    }

    protected int engineUpdate(byte[] object, int n2, int n3, byte[] byArray, int n4) {
        Object object2;
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 8;
        n3 = n5 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
            n2 = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n2 < 0 || (long)n2 + (long)n3 > (long)((byte[])object).length || n4 < 0 || (long)n4 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n2, byArray, n4, bl) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n2 += 8;
                    n4 += 8;
                    ++n6;
                }
            }
        } else if (bl) {
            int n7 = 0;
            while (n7 < n5) {
                this.blockEncrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < n5) {
                this.blockDecrypt((byte[])object, n2, byArray, n4);
                n2 += 8;
                n4 += 8;
                ++n8;
            }
        }
        return n3;
    }

    private void makeKey(Key key) throws InvalidKeyException, CryptixException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var4_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        IDEA.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        this.ks[0] = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.ks[1] = (short)((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        this.ks[2] = (short)((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
        this.ks[3] = (short)((byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF);
        this.ks[4] = (short)((byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF);
        this.ks[5] = (short)((byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF);
        this.ks[6] = (short)((byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF);
        this.ks[7] = (short)((byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF);
        int n2 = 0;
        int n3 = 0;
        int n4 = 8;
        while (n4 < 52) {
            this.ks[++n2 + 7 + n3] = (short)(this.ks[(n2 & 7) + n3] << 9 | this.ks[(n2 + 1 & 7) + n3] >>> 7 & 0x1FF);
            n3 += n2 & 8;
            n2 &= 7;
            ++n4;
        }
    }

    private void invertKey() {
        if (this.native_lock == null) {
            int n2 = 4;
            int n3 = 51;
            short[] sArray = new short[52];
            sArray[n3--] = IDEA.inv(this.ks[3]);
            sArray[n3--] = -this.ks[2];
            sArray[n3--] = -this.ks[1];
            sArray[n3--] = IDEA.inv(this.ks[0]);
            int n4 = 1;
            while (n4 < 8) {
                sArray[n3--] = this.ks[n2 + 1];
                sArray[n3--] = this.ks[n2];
                sArray[n3--] = IDEA.inv(this.ks[n2 + 5]);
                sArray[n3--] = -this.ks[n2 + 3];
                sArray[n3--] = -this.ks[n2 + 4];
                sArray[n3--] = IDEA.inv(this.ks[n2 + 2]);
                ++n4;
                n2 += 6;
            }
            sArray[n3--] = this.ks[n2 + 1];
            sArray[n3--] = this.ks[n2];
            sArray[n3--] = IDEA.inv(this.ks[n2 + 5]);
            sArray[n3--] = -this.ks[n2 + 4];
            sArray[n3--] = -this.ks[n2 + 3];
            sArray[n3--] = IDEA.inv(this.ks[n2 + 2]);
            System.arraycopy(sArray, 0, this.ks, 0, 52);
        }
    }

    private void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        short s2;
        short s3 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s4 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s5 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s6 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF);
        int n4 = 0;
        int n5 = 8;
        while (n5-- > 0) {
            s3 = IDEA.mul(s3, this.ks[n4++]);
            s4 = (short)(s4 + this.ks[n4++]);
            s5 = (short)(s5 + this.ks[n4++]);
            s6 = IDEA.mul(s6, this.ks[n4++]);
            short s7 = s5;
            s5 = IDEA.mul(s3 ^ s5, this.ks[n4++]);
            s2 = s4;
            s4 = IDEA.mul(s5 + (s4 ^ s6), this.ks[n4++]);
            s5 = (short)(s5 + s4);
            s3 = (short)(s3 ^ s4);
            s6 = (short)(s6 ^ s5);
            s4 = (short)(s4 ^ s7);
            s5 = (short)(s5 ^ s2);
        }
        s2 = IDEA.mul(s3, this.ks[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s5 + this.ks[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s4 + this.ks[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = IDEA.mul(s6, this.ks[n4]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3] = (byte)s2;
    }

    private void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.blockEncrypt(byArray, n2, byArray2, n3);
    }

    private static short mul(int n2, int n3) {
        n3 &= 0xFFFF;
        if ((n2 &= 0xFFFF) != 0) {
            if (n3 != 0) {
                int n4 = n2 * n3;
                return (short)(n3 - n2 + ((n3 = n4 & 0xFFFF) < (n2 = n4 >>> 16) ? 1 : 0));
            }
            return (short)(1 - n2);
        }
        return (short)(1 - n3);
    }

    private static short inv(short s2) {
        int n2 = s2 & 0xFFFF;
        if (n2 <= 1) {
            return (short)n2;
        }
        int n3 = 65537 / n2;
        int n4 = 65537 % n2;
        if (n4 == 1) {
            return (short)(1 - n3);
        }
        int n5 = 1;
        do {
            int n6 = n2 / n4;
            n5 += n6 * n3;
            if ((n2 %= n4) == 1) {
                return (short)n5;
            }
            n6 = n4 / n2;
            n3 += n6 * n5;
        } while ((n4 %= n2) != 1);
        return (short)(1 - n3);
    }

    public static void main(String[] stringArray) {
        try {
            IDEA.self_test();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void self_test() throws Throwable {
        Cipher cipher = Cipher.getInstance("IDEA", "Cryptix");
        int n2 = 0;
        while (n2 < tests.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", tests[n2][0]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray = cipher.crypt(tests[n2][1]);
            if (!ArrayUtil.areEqual(tests[n2][2], byArray)) {
                throw new CryptixException("encrypt #" + n2 + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray = cipher.crypt(tests[n2][2]);
            if (!ArrayUtil.areEqual(tests[n2][1], byArray)) {
                throw new CryptixException("decrypt #" + n2 + " failed");
            }
            ++n2;
        }
        if (debuglevel > 0) {
            IDEA.debug("Self-test OK");
        }
    }

    public IDEA() {
        super(false, false, "Cryptix");
        this.link();
    }
}

