/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.Security;
import xjava.security.Cipher;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.SymmetricCipher;

public final class SPEED
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("SPEED");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("SPEED", 2, 3);
    private static final int MIN_NOF_ROUNDS = 32;
    private static final int MIN_USER_KEY_LENGTH = 6;
    private static final int MAX_USER_KEY_LENGTH = 32;
    private long native_cookie;
    private Object native_lock;
    private int key_length;
    private int rounds;
    private int block_size;
    private int key_bits;
    private int data_bits;
    private int s0;
    private int s1;
    private int s2;
    private int f_wd_len;
    private int h_wd_len;
    private int f_wd_mask;
    private int h_wd_mask;
    private int v_shift;
    private int kb_bits;
    private int[] round_key;
    private int key_len_dbyte;
    private int[] kb;

    private static void debug(String string) {
        err.println("SPEED: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(SPEED.getLibMajorVersion(), SPEED.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail(unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    SPEED.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                SPEED.debug("Using native library? " + (this.native_lock != null));
            }
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7, int var8, int var9);

    private native String native_finalize();

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    SPEED.debug(string + " in native_finalize");
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return this.block_size;
    }

    public void engineInitEncrypt(Key key) throws InvalidKeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n2, int n3, byte[] byArray, int n4) {
        Object object2;
        boolean bl;
        int n5 = this.block_size;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n6 = n3 / n5;
        n3 = n6 * n5;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            object2 = new byte[n3];
            System.arraycopy(object, n2, object2, 0, n3);
            object = object2;
            n2 = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n2 < 0 || (long)n2 + (long)n3 > (long)((byte[])object).length || n4 < 0 || (long)n4 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(this.getAlgorithm() + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n7 = 0;
                while (n7 < n6) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n2, byArray, n4, bl, this.rounds, n5) == 0) {
                        throw new CryptixException(this.getAlgorithm() + ": Error in native code");
                    }
                    n2 += n5;
                    n4 += n5;
                    ++n7;
                }
            }
        } else if (bl) {
            int n8 = 0;
            while (n8 < n6) {
                this.blockEncrypt((byte[])object, n2, byArray, n4);
                n2 += n5;
                n4 += n5;
                ++n8;
            }
        } else {
            int n9 = 0;
            while (n9 < n6) {
                this.blockDecrypt((byte[])object, n2, byArray, n4);
                n2 += n5;
                n4 += n5;
                ++n9;
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String string, Object object) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (string.equalsIgnoreCase("rounds")) {
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("rounds.SPEED");
            this.setRounds((Integer)object);
            return;
        } else {
            if (!string.equalsIgnoreCase("blockSize")) throw new NoSuchParameterException(string + ".SPEED");
            if (!(object instanceof Integer)) throw new InvalidParameterTypeException("blockSize.SPEED");
            this.setBlockSize((Integer)object);
        }
    }

    protected Object engineGetParameter(String string) throws NoSuchParameterException, InvalidParameterException {
        if (string.equalsIgnoreCase("rounds")) {
            return new Integer(this.rounds);
        }
        if (string.equalsIgnoreCase("blockSize")) {
            return new Integer(this.block_size);
        }
        throw new NoSuchParameterException(string + ".SPEED");
    }

    public void setRounds(int n2) {
        if (this.getState() != 0) {
            throw new IllegalStateException(this.getAlgorithm() + ": Cipher not in UNINITIALIZED state");
        }
        if (n2 < 32 || n2 % 4 != 0) {
            throw new IllegalArgumentException(this.getAlgorithm() + ": Invalid number of rounds");
        }
        this.rounds = n2;
    }

    public int getRounds() {
        return this.rounds;
    }

    public void setBlockSize(int n2) {
        if (this.getState() != 0) {
            throw new IllegalStateException(this.getAlgorithm() + ": Cipher not in UNINITIALIZED state");
        }
        if (n2 != 8 && n2 != 16 && n2 != 32) {
            throw new IllegalArgumentException(this.getAlgorithm() + ": Invalid block size");
        }
        this.block_size = n2;
    }

    private void makeKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        int n2 = byArray.length;
        if (n2 < 6 || n2 > 32) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var5_6 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        SPEED.debug(error + ". Will use 100% Java.");
                    }
                }
            }
        }
        this.set_constants(byArray.length);
        this.kb = new int[this.kb_bits];
        this.round_key = new int[this.rounds];
        int n3 = 0;
        while (n3 < this.key_len_dbyte) {
            this.kb[n3] = byArray[2 * n3] | byArray[2 * n3 + 1] << 8;
            ++n3;
        }
        n3 = this.key_len_dbyte;
        while (n3 < this.kb_bits) {
            int n4 = this.s2 & this.s1 ^ this.s1 & this.s0 ^ this.s0 & this.s2;
            n4 = n4 << 5 | n4 >>> 11;
            n4 += this.s2 + this.kb[n3 % this.key_len_dbyte];
            this.s2 = this.s1;
            this.s1 = this.s0;
            this.s0 = this.kb[n3] = (n4 &= 0xFFFF);
            ++n3;
        }
        if (debuglevel >= 5) {
            SPEED.debug("kb_bits=" + this.kb_bits + ", kb.length=" + this.kb.length + ", round_key.length=" + this.round_key.length);
        }
        switch (this.data_bits) {
            case 256: {
                n3 = 0;
                while (n3 < this.kb_bits / 2) {
                    this.round_key[n3] = this.kb[2 * n3] | this.kb[2 * n3 + 1] << 16;
                    ++n3;
                }
                break;
            }
            case 128: {
                n3 = 0;
                while (n3 < this.kb_bits) {
                    this.round_key[n3] = this.kb[n3];
                    ++n3;
                }
                break;
            }
            case 64: {
                n3 = 0;
                while (n3 < this.kb_bits) {
                    this.round_key[2 * n3] = this.kb[n3] & 0xFF;
                    this.round_key[2 * n3 + 1] = this.kb[n3] >>> 8 & 0xFF;
                    ++n3;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.data_bits + " illegal in key_schedule?");
            }
        }
    }

    private void set_constants(int n2) {
        this.key_length = n2;
        this.key_bits = n2 * 8;
        this.key_len_dbyte = n2 / 2;
        this.set_sqrt_15(this.key_bits);
        this.data_bits = this.block_size * 8;
        this.f_wd_len = this.data_bits / 8;
        this.h_wd_len = this.f_wd_len / 2;
        switch (this.data_bits) {
            case 256: {
                this.f_wd_mask = -1;
                this.h_wd_mask = 65535;
                this.v_shift = 11;
                this.kb_bits = 2 * this.rounds;
                break;
            }
            case 128: {
                this.f_wd_mask = 65535;
                this.h_wd_mask = 255;
                this.v_shift = 4;
                this.kb_bits = this.rounds;
                break;
            }
            case 64: {
                this.f_wd_mask = 255;
                this.h_wd_mask = 15;
                this.v_shift = 1;
                this.kb_bits = this.rounds / 2;
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.data_bits + " is bad data size (not 64/128/256)");
            }
        }
    }

    private void set_sqrt_15(int n2) {
        switch (n2) {
            case 48: {
                this.s0 = 57211;
                this.s1 = 54825;
                this.s2 = 59867;
                return;
            }
            case 64: {
                this.s0 = 13871;
                this.s1 = 23808;
                this.s2 = 61967;
                return;
            }
            case 80: {
                this.s0 = 50129;
                this.s1 = 8146;
                this.s2 = 22683;
                return;
            }
            case 96: {
                this.s0 = 17170;
                this.s1 = 37355;
                this.s2 = 29070;
                return;
            }
            case 112: {
                this.s0 = 48938;
                this.s1 = 7805;
                this.s2 = 45655;
                return;
            }
            case 128: {
                this.s0 = 30630;
                this.s1 = 5716;
                this.s2 = 27434;
                return;
            }
            case 144: {
                this.s0 = 3483;
                this.s1 = 43475;
                this.s2 = 26255;
                return;
            }
            case 160: {
                this.s0 = 6590;
                this.s1 = 63573;
                this.s2 = 28056;
                return;
            }
            case 176: {
                this.s0 = 557;
                this.s1 = 58594;
                this.s2 = 53271;
                return;
            }
            case 192: {
                this.s0 = 59951;
                this.s1 = 30066;
                this.s2 = 50101;
                return;
            }
            case 208: {
                this.s0 = 4230;
                this.s1 = 18444;
                this.s2 = 15014;
                return;
            }
            case 224: {
                this.s0 = 40096;
                this.s1 = 39159;
                this.s2 = 53476;
                return;
            }
            case 240: {
                this.s0 = 9532;
                this.s1 = 51457;
                this.s2 = 22003;
                return;
            }
            case 256: {
                this.s0 = 39924;
                this.s1 = 63065;
                this.s2 = 55148;
                return;
            }
        }
        throw new CryptixException("SPEED: " + n2 + " is bad key length (not 48 .. 256 % 16)");
    }

    void dump() {
        if (this.data_bits == 0) {
            err.println("no data set yet");
            return;
        }
        err.println("KEY SCHEDULE");
        err.println(" data_bits " + this.data_bits);
        err.println(" kb_bits " + this.kb_bits);
        err.println(" kb.length " + this.kb.length);
        err.println(" f_wd_mask " + Hex.intToString(this.f_wd_mask));
        err.println(" h_wd_mask " + Hex.intToString(this.h_wd_mask));
        err.println(" v_shift " + this.v_shift);
        err.println(" double byte buffer");
        int n2 = 0;
        while (n2 < this.key_len_dbyte) {
            err.print(" " + Hex.intToString(this.kb[n2]));
            ++n2;
        }
        err.println();
        switch (this.data_bits) {
            case 256: {
                n2 = 0;
                while (n2 < this.kb_bits / 2) {
                    err.print(" " + Hex.intToString(this.round_key[n2]));
                    ++n2;
                }
                break;
            }
            case 128: {
                n2 = 0;
                while (n2 < this.kb_bits) {
                    err.print(" " + Hex.shortToString(this.round_key[n2]));
                    ++n2;
                }
                break;
            }
            case 64: {
                n2 = 0;
                while (n2 < this.kb_bits * 2) {
                    err.print(" " + Hex.byteToString(this.round_key[n2]));
                    ++n2;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: data_bits=" + this.data_bits + " illegal in key_schedule?");
            }
        }
        err.println();
    }

    private void to_internal(byte[] byArray, int n2, int[] nArray) {
        switch (this.data_bits) {
            case 256: {
                int n3 = 0;
                while (n3 < 8) {
                    nArray[n3] = byArray[n2 + 4 * n3] & 0xFF | byArray[n2 + 4 * n3 + 1] << 8 & 0xFF00 | byArray[n2 + 4 * n3 + 2] << 16 & 0xFF0000 | byArray[n2 + 4 * n3 + 3] << 24 & 0xFF000000;
                    ++n3;
                }
                break;
            }
            case 128: {
                int n4 = 0;
                while (n4 < 8) {
                    nArray[n4] = byArray[n2 + 2 * n4] & 0xFF | byArray[n2 + 2 * n4 + 1] << 8 & 0xFF00;
                    ++n4;
                }
                break;
            }
            case 64: {
                int n5 = 0;
                while (n5 < 8) {
                    nArray[n5] = byArray[n2 + n5] & 0xFF;
                    ++n5;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: " + this.data_bits + " illegal in key_schedule?");
            }
        }
    }

    protected void blockEncrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        this.to_internal(byArray, n2, nArray);
        this.encrypt(nArray, nArray2);
        this.from_internal(nArray2, byArray2, n3);
    }

    private void from_internal(int[] nArray, byte[] byArray, int n2) {
        switch (this.data_bits) {
            case 256: {
                int n3 = 0;
                while (n3 < 8) {
                    byArray[4 * n3 + n2] = (byte)(nArray[n3] & 0xFF);
                    byArray[4 * n3 + 1 + n2] = (byte)(nArray[n3] >>> 8 & 0xFF);
                    byArray[4 * n3 + 2 + n2] = (byte)(nArray[n3] >>> 16 & 0xFF);
                    byArray[4 * n3 + 3 + n2] = (byte)(nArray[n3] >>> 24 & 0xFF);
                    ++n3;
                }
                break;
            }
            case 128: {
                int n4 = 0;
                while (n4 < 8) {
                    byArray[2 * n4 + n2] = (byte)(nArray[n4] & 0xFF);
                    byArray[2 * n4 + 1 + n2] = (byte)(nArray[n4] >>> 8 & 0xFF);
                    ++n4;
                }
                break;
            }
            case 64: {
                int n5 = 0;
                while (n5 < 8) {
                    byArray[n5 + n2] = (byte)(nArray[n5] & 0xFF);
                    ++n5;
                }
                break;
            }
            default: {
                throw new CryptixException("SPEED: data_bits=" + this.data_bits + " illegal in key_schedule?");
            }
        }
    }

    protected void blockDecrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        this.to_internal(byArray, n2, nArray);
        this.decrypt(nArray, nArray2);
        this.from_internal(nArray2, byArray2, n3);
    }

    private void encrypt(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = nArray[2];
        int n9 = nArray[3];
        int n10 = nArray[4];
        int n11 = nArray[5];
        int n12 = nArray[6];
        int n13 = nArray[7];
        int n14 = 0;
        int n15 = this.rounds / 4;
        int n16 = 0;
        while (n16 < n15) {
            n5 = n12 & n9 ^ n11 & n7 ^ n10 & n8 ^ n7 & n6 ^ n6;
            n4 = ((n5 >>> this.h_wd_len) + n5 & this.h_wd_mask) >>> this.v_shift;
            n3 = (n13 &= this.f_wd_mask) >>> this.h_wd_len - 1 | n13 << this.f_wd_len - (this.h_wd_len - 1);
            n2 = (n5 &= this.f_wd_mask) >>> n4 | n5 << this.f_wd_len - n4;
            n5 = n3 + n2 + this.round_key[n14++];
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n5 & this.f_wd_mask;
            ++n16;
        }
        n16 = 0;
        while (n16 < n15) {
            n5 = n12 & n10 & n6 ^ n10 & n9 & n6 ^ n11 & n8 ^ n10 & n9 ^ n10 & n7 ^ n9 & n6 ^ n7;
            n4 = ((n5 >>> this.h_wd_len) + n5 & this.h_wd_mask) >>> this.v_shift;
            n3 = (n13 &= this.f_wd_mask) >>> this.h_wd_len - 1 | n13 << this.f_wd_len - (this.h_wd_len - 1);
            n2 = (n5 &= this.f_wd_mask) >>> n4 | n5 << this.f_wd_len - n4;
            n5 = n3 + n2 + this.round_key[n14++];
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n5 & this.f_wd_mask;
            ++n16;
        }
        n16 = 0;
        while (n16 < n15) {
            n5 = n11 & n10 & n6 ^ n12 & n10 ^ n11 & n8 ^ n9 & n6 ^ n7 & n6 ^ n9;
            n4 = ((n5 >>> this.h_wd_len) + n5 & this.h_wd_mask) >>> this.v_shift;
            n3 = (n13 &= this.f_wd_mask) >>> this.h_wd_len - 1 | n13 << this.f_wd_len - (this.h_wd_len - 1);
            n2 = (n5 &= this.f_wd_mask) >>> n4 | n5 << this.f_wd_len - n4;
            n5 = n3 + n2 + this.round_key[n14++];
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n5 & this.f_wd_mask;
            ++n16;
        }
        n16 = 0;
        while (n16 < n15) {
            n5 = n12 & n10 & n8 & n6 ^ n12 & n11 ^ n10 & n9 ^ n9 & n8 ^ n7 & n6 ^ n8;
            n4 = ((n5 >>> this.h_wd_len) + n5 & this.h_wd_mask) >>> this.v_shift;
            n3 = (n13 &= this.f_wd_mask) >>> this.h_wd_len - 1 | n13 << this.f_wd_len - (this.h_wd_len - 1);
            n2 = (n5 &= this.f_wd_mask) >>> n4 | n5 << this.f_wd_len - n4;
            n5 = n3 + n2 + this.round_key[n14++];
            n13 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n9;
            n9 = n8;
            n8 = n7;
            n7 = n6;
            n6 = n5 & this.f_wd_mask;
            ++n16;
        }
        nArray2[0] = n6;
        nArray2[1] = n7;
        nArray2[2] = n8;
        nArray2[3] = n9;
        nArray2[4] = n10;
        nArray2[5] = n11;
        nArray2[6] = n12;
        nArray2[7] = n13;
    }

    private void decrypt(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray[0] & 0xFFFFFFFF;
        int n7 = nArray[1] & 0xFFFFFFFF;
        int n8 = nArray[2] & 0xFFFFFFFF;
        int n9 = nArray[3] & 0xFFFFFFFF;
        int n10 = nArray[4] & 0xFFFFFFFF;
        int n11 = nArray[5] & 0xFFFFFFFF;
        int n12 = nArray[6] & 0xFFFFFFFF;
        int n13 = nArray[7] & 0xFFFFFFFF;
        int n14 = this.rounds - 1;
        int n15 = this.rounds / 4;
        int n16 = 0;
        while (n16 < n15) {
            n5 = n6;
            n6 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n4 = n12 & n10 & n8 & n6 ^ n12 & n11 ^ n10 & n9 ^ n9 & n8 ^ n7 & n6 ^ n8;
            n3 = ((n4 >>> this.h_wd_len) + n4 & this.h_wd_mask) >>> this.v_shift;
            n2 = (n4 &= this.f_wd_mask) >>> n3 | n4 << this.f_wd_len - n3;
            n5 -= n2 + this.round_key[n14--];
            n13 = (n5 &= this.f_wd_mask) << this.h_wd_len - 1 | n5 >>> this.f_wd_len - (this.h_wd_len - 1);
            ++n16;
        }
        n16 = 0;
        while (n16 < n15) {
            n5 = n6;
            n6 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n4 = n11 & n10 & n6 ^ n12 & n10 ^ n11 & n8 ^ n9 & n6 ^ n7 & n6 ^ n9;
            n3 = ((n4 >>> this.h_wd_len) + n4 & this.h_wd_mask) >>> this.v_shift;
            n2 = (n4 &= this.f_wd_mask) >>> n3 | n4 << this.f_wd_len - n3;
            n5 -= n2 + this.round_key[n14--];
            n13 = (n5 &= this.f_wd_mask) << this.h_wd_len - 1 | n5 >>> this.f_wd_len - (this.h_wd_len - 1);
            ++n16;
        }
        n16 = 0;
        while (n16 < n15) {
            n5 = n6;
            n6 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n4 = n12 & n10 & n6 ^ n10 & n9 & n6 ^ n11 & n8 ^ n10 & n9 ^ n10 & n7 ^ n9 & n6 ^ n7;
            n3 = ((n4 >>> this.h_wd_len) + n4 & this.h_wd_mask) >>> this.v_shift;
            n2 = (n4 &= this.f_wd_mask) >>> n3 | n4 << this.f_wd_len - n3;
            n5 -= n2 + this.round_key[n14--];
            n13 = (n5 &= this.f_wd_mask) << this.h_wd_len - 1 | n5 >>> this.f_wd_len - (this.h_wd_len - 1);
            ++n16;
        }
        n16 = 0;
        while (n16 < n15) {
            n5 = n6;
            n6 = n7;
            n7 = n8;
            n8 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n12;
            n12 = n13;
            n4 = n12 & n9 ^ n11 & n7 ^ n10 & n8 ^ n7 & n6 ^ n6;
            n3 = ((n4 >>> this.h_wd_len) + n4 & this.h_wd_mask) >>> this.v_shift;
            n2 = (n4 &= this.f_wd_mask) >>> n3 | n4 << this.f_wd_len - n3;
            n5 -= n2 + this.round_key[n14--];
            n13 = (n5 &= this.f_wd_mask) << this.h_wd_len - 1 | n5 >>> this.f_wd_len - (this.h_wd_len - 1);
            ++n16;
        }
        nArray2[0] = n6;
        nArray2[1] = n7;
        nArray2[2] = n8;
        nArray2[3] = n9;
        nArray2[4] = n10;
        nArray2[5] = n11;
        nArray2[6] = n12;
        nArray2[7] = n13;
    }

    public static final void main(String[] stringArray) {
        try {
            SPEED.self_test(new PrintWriter(System.err), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void self_test(PrintWriter printWriter, String[] stringArray) throws Exception {
        printWriter.println("Note: hex strings are printed in conventional order, not the order");
        printWriter.println("      in the SPEED paper.");
        printWriter.println();
        SPEED.test(printWriter, 64, "0000000000000000", "0000000000000000", "2E008019BC26856D");
        SPEED.test(printWriter, 128, "00000000000000000000000000000000", "00000000000000000000000000000000", "A44FBF29EDF6CBF8D7A2DFD57163B909");
        SPEED.test(printWriter, 128, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "6C13E4B9C3171571AB54D816915BC4E8");
        SPEED.test(printWriter, 48, "504F4E4D4C4B4A494847464544434241", "1F1E1D1C1B1A191817161514131211100F0E0D0C0B0A09080706050403020100", "90C5981EF6A3D21BC178CACDAD6BF39B2E51CDB70A6EE875A73BF5ED883E3692");
        SPEED.test(printWriter, 256, "0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000", "6CD44D2B49BC6AA7E95FD1C4AF713A2C0AFA1701308D56298CDF27A02EB09BF5");
        SPEED.test(printWriter, 256, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "C8F3E864263FAF24222E38227BEBC022CF4A9A0ECE89FB81CA1B9BA3BA93D0C5");
        SPEED.test(printWriter, 256, "605F5E5D5C5B5A595857565554535251504F4E4D4C4B4A494847464544434241", "1F1E1D1C1B1A191817161514131211100F0E0D0C0B0A09080706050403020100", "3DE16CFA9A626847434E1574693FEC1B3FAA558A296B61D708B131CCBA311068");
    }

    private static void test(PrintWriter printWriter, int n2, String string, String string2, String string3) throws Exception {
        byte[] byArray = Hex.fromReversedString(string);
        byte[] byArray2 = Hex.fromReversedString(string2);
        byte[] byArray3 = Hex.fromReversedString(string3);
        SPEED sPEED = new SPEED();
        sPEED.setBlockSize(byArray2.length);
        sPEED.setRounds(n2);
        RawSecretKey rawSecretKey = new RawSecretKey("SPEED", byArray);
        sPEED.initEncrypt(rawSecretKey);
        byte[] byArray4 = sPEED.crypt(byArray2);
        printWriter.println("    key:" + Hex.toString(byArray));
        printWriter.println("  plain:" + Hex.toString(byArray2));
        String string4 = Hex.toString(byArray4);
        printWriter.println("    enc:" + string4);
        String string5 = Hex.toString(byArray3);
        if (string4.equals(string5)) {
            printWriter.print("encryption good; ");
        } else {
            printWriter.println("   calc:" + string5);
            printWriter.println(" ********* SPEED ENCRYPTION FAILED ********* ");
            sPEED.dump();
        }
        sPEED.initDecrypt(rawSecretKey);
        byte[] byArray5 = sPEED.crypt(byArray4);
        string4 = Hex.toString(byArray5);
        string5 = Hex.toString(byArray2);
        if (string4.equals(string5)) {
            printWriter.println("decryption good");
        } else {
            printWriter.println();
            printWriter.println("    enc:" + Hex.toString(byArray4));
            printWriter.println("    dec:" + string4);
            printWriter.println("   calc:" + string5);
            printWriter.println(" ********* SPEED DECRYPTION FAILED ********* ");
            sPEED.dump();
        }
    }

    public SPEED() {
        block7: {
            String string;
            block6: {
                super(false, false, "Cryptix");
                this.key_length = 16;
                this.rounds = 64;
                this.block_size = 8;
                this.link();
                try {
                    string = Security.getAlgorithmProperty("SPEED", "rounds");
                    if (string != null) {
                        this.setRounds(Integer.parseInt(string));
                    }
                }
                catch (Exception exception) {
                    if (debuglevel <= 0) break block6;
                    SPEED.debug("Could not set number of rounds");
                }
            }
            try {
                string = Security.getAlgorithmProperty("SPEED", "blockSize");
                if (string != null) {
                    this.setBlockSize(Integer.parseInt(string));
                }
            }
            catch (Exception exception) {
                if (debuglevel <= 0) break block7;
                SPEED.debug("Could not set block size");
            }
        }
    }
}

