/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.elgamal;

import cryptix.provider.elgamal.BaseElGamalParams;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import xjava.security.interfaces.ElGamalParams;

public class GenericElGamalParameterSet {
    private int[] primeLengths;
    private String[][] precomputed;

    public ElGamalParams getParameters(int n2) {
        int n3 = 0;
        while (n3 < this.primeLengths.length) {
            if (n2 == this.primeLengths[n3]) {
                return new BaseElGamalParams(new BigInteger(this.precomputed[n3][0], 16), this.precomputed[n3][1] != null ? new BigInteger(this.precomputed[n3][1], 16) : null);
            }
            ++n3;
        }
        return null;
    }

    public void checkSane() throws InvalidParameterException {
        int n2 = 0;
        while (n2 < this.primeLengths.length) {
            BigInteger bigInteger = new BigInteger(this.precomputed[n2][0]);
            if (bigInteger.bitLength() < this.primeLengths[n2]) {
                throw new InvalidParameterException(bigInteger + " has incorrect bit length");
            }
            BigInteger bigInteger2 = new BigInteger(this.precomputed[n2][1]);
            if (!bigInteger.isProbablePrime(80)) {
                throw new InvalidParameterException(bigInteger + " is not prime");
            }
            if (bigInteger2.compareTo(bigInteger) >= 0) {
                throw new InvalidParameterException("g >= p");
            }
            ++n2;
        }
    }

    protected GenericElGamalParameterSet(int[] nArray, String[][] stringArray) {
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        this.primeLengths = nArray;
        this.precomputed = stringArray;
    }
}

