/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.key;

import cryptix.util.core.ArrayUtil;
import java.security.Key;

public class RawKey
implements Key {
    private static final String FORMAT = "RAW";
    private String algorithm;
    private byte[] data;

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.data.length) {
            n2 ^= this.data[n3];
            n3 += 4;
        }
        n2 <<= 8;
        n3 = 1;
        while (n3 < this.data.length) {
            n2 ^= this.data[n3];
            n3 += 4;
        }
        n2 <<= 8;
        n3 = 2;
        while (n3 < this.data.length) {
            n2 ^= this.data[n3];
            n3 += 4;
        }
        n2 <<= 8;
        n3 = 3;
        while (n3 < this.data.length) {
            n2 ^= this.data[n3];
            n3 += 4;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof RawKey) {
            return ArrayUtil.areEqual(this.data, ((RawKey)object).data);
        }
        return false;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return FORMAT;
    }

    public byte[] getEncoded() {
        return (byte[])this.data.clone();
    }

    public RawKey(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = (byte[])byArray.clone();
    }

    public RawKey(String string, byte[] byArray, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = new byte[n3];
        System.arraycopy(byArray, n2, this.data, 0, n3);
    }
}

