/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.key;

import cryptix.provider.key.RawSecretKey;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.SecureRandom;
import xjava.security.ExtendedKeyGenerator;
import xjava.security.KeyGenerator;
import xjava.security.SecretKey;
import xjava.security.WeakKeyException;

public class RawKeyGenerator
extends KeyGenerator
implements ExtendedKeyGenerator,
Cloneable {
    private SecureRandom source;
    private int minLength;
    private int seedLength;
    private int maxLength;
    private boolean weakAllowed;

    public SecretKey generateKey() {
        if (this.source == null) {
            this.source = new SecureRandom();
        }
        byte[] byArray = new byte[this.seedLength];
        while (true) {
            this.source.nextBytes(byArray);
            try {
                byte[] byArray2 = this.engineGenerateKey(byArray);
                return new RawSecretKey(this.getAlgorithm(), byArray2);
            }
            catch (KeyException keyException) {
                continue;
            }
            break;
        }
    }

    public void initialize(SecureRandom secureRandom) {
        this.source = secureRandom;
    }

    public void initialize(SecureRandom secureRandom, int n2) {
        if (!this.isValidKeyLength(n2)) {
            throw new IllegalArgumentException("invalid key length for " + this.getAlgorithm() + ": " + n2 + " bytes");
        }
        this.source = secureRandom;
        this.seedLength = n2;
    }

    public boolean isWeakAllowed() {
        return this.weakAllowed;
    }

    public void setWeakAllowed(boolean bl) {
        this.weakAllowed = bl;
    }

    public int getMinimumKeyLength() {
        return this.minLength;
    }

    public int getDefaultKeyLength() {
        return this.seedLength;
    }

    public int getMaximumKeyLength() {
        return this.maxLength;
    }

    public boolean isValidKeyLength(int n2) {
        return n2 >= this.minLength && n2 <= this.maxLength;
    }

    public SecretKey generateKey(byte[] byArray) throws WeakKeyException, InvalidKeyException {
        if (!this.isValidKeyLength(byArray.length)) {
            throw new InvalidKeyException("invalid key length for " + this.getAlgorithm() + ": " + byArray.length + " bytes");
        }
        byte[] byArray2 = this.engineGenerateKey((byte[])byArray.clone());
        return new RawSecretKey(this.getAlgorithm(), byArray2);
    }

    protected byte[] engineGenerateKey(byte[] byArray) throws WeakKeyException, InvalidKeyException {
        if (!this.isWeakAllowed() && this.isWeak(byArray)) {
            throw new WeakKeyException(this.getAlgorithm());
        }
        return byArray;
    }

    protected boolean isWeak(byte[] byArray) {
        return false;
    }

    protected RawKeyGenerator(String string, int n2) throws IllegalArgumentException {
        super(string);
        if (n2 <= 0) {
            throw new IllegalArgumentException("seedlength <= 0");
        }
        this.minLength = n2;
        this.seedLength = n2;
        this.maxLength = n2;
    }

    protected RawKeyGenerator(String string, int n2, int n3, int n4) throws IllegalArgumentException {
        super(string);
        if (n2 <= 0 || n2 > n3 || n3 > n4) {
            throw new IllegalArgumentException("!(0 < minlength && minlength <= defaultlength && defaultlength <= maxlength)");
        }
        this.minLength = n2;
        this.seedLength = n3;
        this.maxLength = n4;
    }
}

