/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import cryptix.CryptixException;
import cryptix.provider.mode.FeedbackMode;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class CBC
extends FeedbackMode {
    protected byte[] xorBlock;

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.xorBlock = new byte[this.length];
    }

    protected int engineBlockSize() {
        return this.length;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initDecrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("CBC: IV is not set");
        }
        switch (this.getState()) {
            case 1: {
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = n5++;
                    this.ivBlock[n6] = (byte)(this.ivBlock[n6] ^ byArray[n2++]);
                }
                this.cipher.update(this.ivBlock, 0, n3, this.ivBlock, 0);
                System.arraycopy(this.ivBlock, 0, byArray2, n4, n3);
                break;
            }
            case 2: {
                byte[] byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
                this.cipher.update(byArray, n2, n3, this.xorBlock, 0);
                int n7 = 0;
                while (n7 < n3) {
                    byArray2[n7 + n4] = (byte)(this.xorBlock[n7] ^ this.ivBlock[n7]);
                    ++n7;
                }
                System.arraycopy(byArray3, 0, this.ivBlock, 0, n3);
                byArray3 = null;
                break;
            }
            default: {
                throw new CryptixException("CBC: Cipher not initialized");
            }
        }
        return n3;
    }

    public CBC() {
        super(false, false, "Cryptix");
    }

    public CBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public CBC(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }
}

