/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.MessageDigest;

class TestMD2
extends BaseTest {
    public static void main(String[] stringArray) {
        TestMD2.super.commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(7);
        String[][] stringArray = new String[][]{{"", "8350E5A3E24C153DF2275C9F80692773"}, {"a", "32EC01EC4A6DAC72C0AB96FB34C0B5D1"}, {"abc", "DA853B0D3F88D99B30283A69E6DED6BB"}, {"message digest", "AB4F496BFB2A530B219FF33031FE06B0"}, {"abcdefghijklmnopqrstuvwxyz", "4E8DDFF3650292AB5A4108C3AA47940B"}, {"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "DA33DEF2A42DF13975352846C30338CD"}, {"12345678901234567890123456789012345678901234567890123456789012345678901234567890", "D5976F79D83D3A0DC9806C3C66F3EFD8"}};
        MessageDigest messageDigest = MessageDigest.getInstance("MD2", "Cryptix");
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = Hex.toString(messageDigest.digest(stringArray[n2][0].getBytes()));
            this.out.println("  test vector: " + stringArray[n2][0]);
            this.out.println("  computed md: " + string);
            this.out.println(" certified md: " + stringArray[n2][1]);
            this.passIf(string.equals(stringArray[n2][1]), "MD2 #" + (n2 + 1));
            ++n2;
        }
    }

    TestMD2() {
    }
}

