/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.checksum;

import java.util.zip.Checksum;

public class PRZ24
implements Checksum {
    private static final int[] table = new int[256];
    private static final int CRC_BITS = 24;
    private static final int CRC_HIGH_BIT = 0x1000000;
    private static final int CRC_MASK = 0xFFFFFF;
    private static final int PRZ_CRC = 8801531;
    private static final int START_VALUE = 11994318;
    private int prz24;

    public void reset() {
        this.prz24 = 11994318;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 + n2 > byArray.length) {
            n3 = byArray.length - n2;
        }
        while (n3-- > 0) {
            this.update(byArray[n2++]);
        }
    }

    public void update(int n2) {
        this.prz24 = (this.prz24 << 8 ^ table[this.prz24 >>> 16 ^ n2 & 0xFF]) & 0xFFFFFF;
    }

    public long getValue() {
        return (long)this.prz24 & 0xFFFFFFFFL;
    }

    public PRZ24() {
        this.reset();
    }

    static {
        PRZ24.table[0] = 0;
        PRZ24.table[1] = 8801531;
        int n2 = 1;
        int n3 = 2;
        while (n2 < 128) {
            int n4 = table[n2] << 1;
            if ((n4 & 0x1000000) != 0) {
                PRZ24.table[n3++] = n4 ^ 0x864CFB;
                PRZ24.table[n3++] = n4;
            } else {
                PRZ24.table[n3++] = n4;
                PRZ24.table[n3++] = n4 ^ 0x864CFB;
            }
            ++n2;
        }
    }
}

