/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.core;

public class ArrayUtil {
    private static final int ZEROES_LEN = 500;
    private static byte[] zeroes = new byte[500];

    public static void clear(byte[] byArray) {
        ArrayUtil.clear(byArray, 0, byArray.length);
    }

    public static void clear(byte[] byArray, int n2, int n3) {
        if (n3 <= 500) {
            System.arraycopy(zeroes, 0, byArray, n2, n3);
        } else {
            System.arraycopy(zeroes, 0, byArray, n2, 500);
            int n4 = n3 / 2;
            int n5 = 500;
            while (n5 < n3) {
                System.arraycopy(byArray, n2, byArray, n2 + n5, n5 <= n4 ? n5 : n3 - n5);
                n5 += n5;
            }
        }
    }

    public static int toInt(short s2, short s3) {
        return s2 & 0xFFFF | s3 << 16;
    }

    public static short toShort(byte by, byte by2) {
        return (short)(by & 0xFF | by2 << 8);
    }

    public static byte[] toBytes(int n2) {
        byte[] byArray = new byte[4];
        int n3 = 3;
        while (n3 >= 0) {
            byArray[n3] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
            --n3;
        }
        return byArray;
    }

    public static byte[] toBytes(short[] sArray, int n2, int n3) {
        byte[] byArray = new byte[2 * n3];
        int n4 = 0;
        int n5 = n2;
        while (n5 < n2 + n3) {
            byArray[n4++] = (byte)(sArray[n5] >>> 8 & 0xFF);
            byArray[n4++] = (byte)(sArray[n5] & 0xFF);
            ++n5;
        }
        return byArray;
    }

    public static byte[] toBytes(short[] sArray) {
        return ArrayUtil.toBytes(sArray, 0, sArray.length);
    }

    public static short[] toShorts(byte[] byArray, int n2, int n3) {
        short[] sArray = new short[n3 / 2];
        int n4 = 0;
        int n5 = n2;
        while (n5 < n2 + n3 - 1) {
            sArray[n4++] = (short)((byArray[n5] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF);
            n5 += 2;
        }
        return sArray;
    }

    public static short[] toShorts(byte[] byArray) {
        return ArrayUtil.toShorts(byArray, 0, byArray.length);
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        if (n2 != byArray2.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        if (n2 != nArray2.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] != nArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static int compared(byte[] byArray, byte[] byArray2, boolean bl) {
        int n2 = byArray.length;
        if (n2 < byArray2.length) {
            return -1;
        }
        if (n2 > byArray2.length) {
            return 1;
        }
        if (bl) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                int n4 = byArray[n3] & 0xFF;
                int n5 = byArray2[n3] & 0xFF;
                if (n4 < n5) {
                    return -1;
                }
                if (n4 > n5) {
                    return 1;
                }
                --n3;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = byArray[n6] & 0xFF;
                int n8 = byArray2[n6] & 0xFF;
                if (n7 < n8) {
                    return -1;
                }
                if (n7 > n8) {
                    return 1;
                }
                ++n6;
            }
        }
        return 0;
    }

    public static boolean isText(byte[] byArray) {
        int n2 = byArray.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n3] & 0xFF;
            if (n4 < 32 || n4 > 127) {
                switch (n4) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 26: 
                    case 27: 
                    case 155: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++n3;
        }
        return true;
    }

    private ArrayUtil() {
    }
}

