/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.mime;

import cryptix.util.checksum.ChecksumException;
import cryptix.util.checksum.PRZ24;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class Base64InputStream
extends FilterInputStream {
    static final int CONV_WHITE = -1;
    static final int CONV_PAD = -2;
    static final int CONV_OTHER = -3;
    private boolean finished;
    private Checksum crc;
    private int crcLength;
    private byte[] inBuf = new byte[4];
    private byte[] outBuf = new byte[3];
    private int inOff;
    private int outOff;
    private int outBufMax;

    public synchronized void close() throws IOException {
        this.finished = true;
        this.outOff = 0;
        super.close();
    }

    public synchronized int read() throws IOException {
        int n2;
        if (this.outOff == 0) {
            if (this.finished) {
                return -1;
            }
            n2 = 0;
            int n3 = -1;
            while (n3 == -1) {
                n2 = this.in.read();
                if (n2 < 0) {
                    return -1;
                }
                n3 = this.toNumber(n2);
            }
            if (n3 < 0) {
                if (this.crc == null || n3 == -3) {
                    throw new CharConversionException();
                }
                long l2 = this.crc.getValue();
                long l3 = 0L;
                this.crc = null;
                int n4 = 0;
                while (n4 < this.crcLength) {
                    n2 = this.read();
                    if (n2 < 0) {
                        throw new EOFException();
                    }
                    l3 = l3 << 8 | (long)n2;
                    ++n4;
                }
                this.finished = true;
                this.outOff = 0;
                if (l3 != l2) {
                    throw new ChecksumException();
                }
                return -1;
            }
            int n5 = 0;
            while (n5 < 4) {
                if (n3 == -2) {
                    if (n5 < 2) {
                        throw new CharConversionException();
                    }
                } else {
                    if (n3 < 0) {
                        throw new CharConversionException();
                    }
                    this.inBuf[this.inOff++] = (byte)n3;
                }
                if (n5 != 3) {
                    n2 = this.in.read();
                    if (n2 < 0) {
                        throw new EOFException();
                    }
                    n3 = this.toNumber(n2);
                }
                ++n5;
            }
            this.writeTriplet();
        }
        n2 = this.outBuf[this.outOff++] & 0xFF;
        if (this.outOff == this.outBufMax) {
            this.outOff = 0;
        }
        if (this.crc != null) {
            this.crc.update(n2);
        }
        return n2;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.read();
            if (n5 < 0) {
                return n4 == 0 ? -1 : n4;
            }
            byArray[n2++] = (byte)n5;
            ++n4;
        }
        return n3;
    }

    public synchronized long skip(long l2) throws IOException {
        long l3 = 0L;
        while (l3 < l2) {
            if (this.read() < 0) {
                return l3;
            }
            ++l3;
        }
        return l2;
    }

    public synchronized int available() throws IOException {
        return this.outOff == 0 ? 0 : this.outBufMax - this.outOff;
    }

    public void mark(int n2) {
    }

    public void reset() throws IOException {
        throw new IOException("Base64InputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }

    private void init(Checksum checksum, int n2) {
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("length < 0 || length > 8");
        }
        this.outBufMax = 3;
        this.outOff = 0;
        this.inOff = 0;
        this.finished = false;
        this.crc = checksum;
        this.crcLength = n2;
    }

    private void writeTriplet() {
        this.outBufMax = 0;
        this.outBuf[this.outBufMax++] = (byte)(this.inBuf[0] << 2 | this.inBuf[1] >>> 4);
        if (this.inOff > 2) {
            this.outBuf[this.outBufMax++] = (byte)(this.inBuf[1] << 4 | this.inBuf[2] >>> 2);
        }
        if (this.inOff > 3) {
            this.outBuf[this.outBufMax++] = (byte)(this.inBuf[2] << 6 | this.inBuf[3]);
        }
        this.inOff = 0;
    }

    private int toNumber(int n2) {
        if (n2 >= 97 & n2 <= 122) {
            return n2 - 97 + 26;
        }
        if (n2 >= 65 & n2 <= 90) {
            return n2 - 65;
        }
        if (n2 >= 48 & n2 <= 57) {
            return n2 - 48 + 52;
        }
        if (n2 == 43) {
            return 62;
        }
        if (n2 == 47) {
            return 63;
        }
        if (n2 == 61) {
            return -2;
        }
        if (n2 == 10 || n2 == 13 || n2 == 32 || n2 == 9) {
            return -1;
        }
        return -3;
    }

    public Base64InputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.init(bl ? new PRZ24() : null, 3);
    }

    public Base64InputStream(InputStream inputStream) {
        super(inputStream);
        this.init(null, 0);
    }

    public Base64InputStream(InputStream inputStream, Checksum checksum, int n2) {
        super(inputStream);
        checksum.reset();
        this.init(checksum, n2);
    }
}

