/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.Support;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int PRIVATE_KEY = 3;
    public static final int PUBLIC_KEY = 4;
    public static final int SECRET_KEY = 5;
    public static final int UNWRAP_MODE = 6;
    public static final int WRAP_MODE = 7;
    private final CipherSpi spi;
    private final Provider provider;
    private final String transformation;
    private final ExemptionMechanism mechanism = null;
    private boolean isInitialized = false;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.spi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(null, 0, 0);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(byArray, 0, byArray.length);
    }

    public final int doFinal(byte[] byArray, int n2) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.spi.engineDoFinal(null, 0, 0, byArray, n2);
    }

    public final byte[] doFinal(byte[] byArray, int n2, int n3) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(byArray, n2, n3);
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(byArray, n2, n3, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(byArray, n2, n3, byArray2, n4);
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        return this.spi.engineGetBlockSize();
    }

    private static Object[] getCipherImplementation(String string, Provider provider) throws NoSuchPaddingException {
        String string2;
        String string3 = "//";
        String string4 = "//";
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(47, n2 + 1);
        if (n2 == -1) {
            string2 = string;
        } else {
            if (n3 == -1) {
                return null;
            }
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1, n3);
            string4 = string.substring(n3 + 1);
        }
        try {
            Object[] objectArray = new Object[2];
            objectArray[1] = provider;
            String string5 = Support.getClassName("Cipher", string, provider);
            if (string5 != null) {
                objectArray[0] = Class.forName(string5).newInstance();
                return objectArray;
            }
            string5 = Support.getClassName("Cipher", String.valueOf(string2) + "/" + string3, provider);
            if (string5 != null) {
                CipherSpi cipherSpi = (CipherSpi)Class.forName(string5).newInstance();
                cipherSpi.engineSetPadding(string4);
                objectArray[0] = cipherSpi;
                return objectArray;
            }
            string5 = Support.getClassName("Cipher", String.valueOf(string2) + "//" + string2, provider);
            if (string5 != null) {
                CipherSpi cipherSpi = (CipherSpi)Class.forName(string5).newInstance();
                cipherSpi.engineSetMode(string3);
                objectArray[0] = cipherSpi;
                return objectArray;
            }
            string5 = Support.getClassName("Cipher", string2, provider);
            if (string5 != null) {
                CipherSpi cipherSpi = (CipherSpi)Class.forName(string5).newInstance();
                cipherSpi.engineSetMode(string3);
                cipherSpi.engineSetPadding(string4);
                objectArray[0] = cipherSpi;
                return objectArray;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final byte[] getIV() {
        return this.spi.engineGetIV();
    }

    public static Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] providerArray = Security.getProviders();
        if (providerArray == null || providerArray.length == 0) {
            throw new NoSuchAlgorithmException("No providers installed");
        }
        int n2 = 0;
        while (n2 < providerArray.length) {
            Object[] objectArray = Cipher.getCipherImplementation(string, providerArray[n2]);
            if (objectArray != null) {
                return new Cipher((CipherSpi)objectArray[0], (Provider)objectArray[1], string);
            }
            ++n2;
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [Cipher." + string + "]");
    }

    public static Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("Provider not found. [" + string2 + "]");
        }
        Object[] objectArray = Cipher.getCipherImplementation(string, provider);
        if (objectArray != null) {
            return new Cipher((CipherSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [Cipher." + string + "]");
    }

    public final int getOutputSize(int n2) throws IllegalStateException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Input size must be >= 0");
        }
        return this.spi.engineGetOutputSize(n2);
    }

    public final AlgorithmParameters getParameters() {
        return this.spi.engineGetParameters();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int n2, Key key) throws InvalidKeyException {
        this.spi.engineInit(n2, key, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(n2, key, algorithmParameters, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(n2, key, algorithmParameters, secureRandom);
        this.isInitialized = true;
    }

    public final void init(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.spi.engineInit(n2, key, secureRandom);
        this.isInitialized = true;
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(n2, key, algorithmParameterSpec, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.isInitialized = true;
    }

    public final void init(int n2, Certificate certificate) throws InvalidKeyException {
        this.init(n2, certificate, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int n2, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        Object object;
        if (certificate instanceof X509Certificate) {
            object = ((X509Certificate)certificate).getCriticalExtensionOIDs().iterator();
            boolean[] blArray = ((X509Certificate)certificate).getKeyUsage();
        }
        object = certificate.getPublicKey();
        this.spi.engineInit(n2, (Key)object, secureRandom);
        this.isInitialized = true;
    }

    public String toString() {
        return "Cipher object: " + this.transformation;
    }

    public final Key unwrap(byte[] byArray, String string, int n2) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (!this.isInitialized) {
            throw new IllegalStateException("Cipher not initialized!");
        }
        return this.spi.engineUnwrap(byArray, string, n2);
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        return this.spi.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        return this.spi.engineUpdate(byArray, n2, n3);
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        return this.spi.engineUpdate(byArray, n2, n3, byArray2, 0);
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException {
        return this.spi.engineUpdate(byArray, n2, n3, byArray2, n4);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (!this.isInitialized) {
            throw new IllegalStateException("Cipher not initialized!");
        }
        return this.spi.engineWrap(key);
    }
}

