/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    private int bufBegin = 0;
    private int bufEnd = 0;
    private boolean isClosed = false;
    private Cipher c;
    private byte[] encBuf;
    private byte[] rawBuf = null;
    private InputStream is;

    protected CipherInputStream(InputStream inputStream) {
        this(inputStream, new NullCipher());
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.c = cipher;
        this.is = inputStream;
        this.encBuf = new byte[1024];
    }

    public int available() throws IOException {
        return this.bufEnd - this.bufBegin;
    }

    public void close() throws IOException {
        this.is.close();
        this.doClose();
    }

    private int doBuffering() throws IOException {
        if (this.isClosed) {
            return -1;
        }
        int n2 = this.is.read(this.encBuf);
        if (n2 < 0) {
            this.doClose();
        } else {
            try {
                this.rawBuf = this.c.update(this.encBuf, 0, n2);
            }
            catch (IllegalStateException illegalStateException) {
                throw new RuntimeException("PANIC: Internal error!");
            }
        }
        n2 = this.rawBuf.length;
        this.bufBegin = 0;
        this.bufEnd = n2;
        return n2;
    }

    private void doClose() {
        this.isClosed = true;
        try {
            this.rawBuf = this.c.doFinal();
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.bufBegin >= this.bufEnd && this.doBuffering() == -1) {
            return -1;
        }
        return this.rawBuf[this.bufBegin++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.bufBegin >= this.bufEnd && this.doBuffering() == -1) {
            return -1;
        }
        if (n3 <= 0) {
            return 0;
        }
        int n4 = this.bufEnd - this.bufBegin;
        if (n4 > n3) {
            n4 = n3;
        }
        if (byArray != null) {
            int n5 = 0;
            while (n5 < n4) {
                byArray[n2 + n5] = this.rawBuf[this.bufBegin + n5];
                ++n5;
            }
        }
        this.bufBegin += n4;
        return n4;
    }

    public long skip(long l2) throws IOException {
        long l3 = this.bufEnd - this.bufBegin;
        if (l3 <= 0L || l2 <= 0L) {
            return 0L;
        }
        if (l3 < l2) {
            l3 = l2;
        }
        this.bufBegin += (int)l3;
        return l3;
    }
}

