/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    private byte[] encBuf;
    private byte[] encParams = null;
    private String sealAlgorithm;
    private String paramsAlgorithm;

    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            throw new IOException(invalidClassException.getMessage());
        }
        catch (NotSerializableException notSerializableException) {
            throw new IOException(notSerializableException.getMessage());
        }
        try {
            this.encBuf = cipher.doFinal(byteArrayOutputStream.toByteArray());
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: Internal error!");
        }
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        if (algorithmParameters != null) {
            this.encParams = algorithmParameters.getEncoded();
            this.paramsAlgorithm = algorithmParameters.getAlgorithm();
        }
        this.sealAlgorithm = cipher.getAlgorithm();
        objectOutputStream.close();
        byteArrayOutputStream.close();
    }

    private Object deCrypt(Cipher cipher) throws ClassNotFoundException, IOException {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(cipher.doFinal(this.encBuf));
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.getMessage());
        }
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new IOException(streamCorruptedException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            throw new IOException(optionalDataException.getMessage());
        }
        catch (InvalidClassException invalidClassException) {
            throw new IOException(invalidClassException.getMessage());
        }
        objectInputStream.close();
        byteArrayInputStream.close();
        return object;
    }

    public final String getAlgorithm() {
        return this.sealAlgorithm;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = null;
        AlgorithmParameters algorithmParameters = null;
        if (this.encParams != null) {
            AlgorithmParameters.getInstance(this.paramsAlgorithm);
            algorithmParameters.init(this.encParams);
        }
        try {
            cipher = Cipher.getInstance(this.sealAlgorithm);
            if (algorithmParameters != null) {
                cipher.init(2, key, algorithmParameters);
            } else {
                cipher.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage());
        }
        return this.deCrypt(cipher);
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Cipher cipher = null;
        AlgorithmParameters algorithmParameters = null;
        if (this.encParams != null) {
            AlgorithmParameters.getInstance(this.paramsAlgorithm, string);
            algorithmParameters.init(this.encParams);
        }
        try {
            cipher = Cipher.getInstance(this.sealAlgorithm);
            if (algorithmParameters != null) {
                cipher.init(2, key, algorithmParameters);
            } else {
                cipher.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage());
        }
        return this.deCrypt(cipher);
    }

    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        byteArrayInputStream = new ByteArrayInputStream(cipher.doFinal(this.encBuf));
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new IOException(streamCorruptedException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            throw new IOException(optionalDataException.getMessage());
        }
        catch (InvalidClassException invalidClassException) {
            throw new IOException(invalidClassException.getMessage());
        }
        objectInputStream.close();
        byteArrayInputStream.close();
        return object;
    }
}

