/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = new Integer(0);
    private Number lowThreshold = new Integer(0);
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanGauge = new Number[16];
    private transient int[] status = new int[16];
    private transient int[] type = new int[16];
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "GaugeMonitor";
    }

    public GaugeMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the gauge monitor");
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("start", "the gauge monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.status[i2] = 2;
                this.previousScanGauge[i2] = null;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.trace("stop", "stop the gauge monitor");
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (!this.isActive) {
                if (this.isTraceOn()) {
                    this.trace("stop", "the counter monitor is already started");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGranularityPeriod(long l2) throws IllegalArgumentException {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            super.setGranularityPeriod(l2);
            if (this.isActive()) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getDerivedGauge(ObjectName objectName) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            int n2 = this.indexOf(objectName);
            if (n2 != -1) {
                return this.derivedGauge[n2];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            int n2 = this.indexOf(objectName);
            if (n2 != -1) {
                return this.derivedGaugeTimestamp[n2];
            }
            return 0L;
        }
    }

    public Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThresholds(Number number, Number number2) throws IllegalArgumentException {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The threshold values cannot be null.");
        }
        if (number.getClass() != number2.getClass()) {
            throw new IllegalArgumentException("The high and the low thresholds must be of the same type.");
        }
        if (this.isFirstStrictlyGreaterThanLast(number2, number, number.getClass().getName())) {
            throw new IllegalArgumentException("The threshold high value must be greater than or equal to threshold low value.");
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.highThreshold = number;
            this.lowThreshold = number2;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.resetAlreadyNotified(i2, 16);
                this.status[i2] = 2;
            }
        }
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyHigh(boolean bl) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyHigh = bl;
        }
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyLow(boolean bl) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.notifyLow = bl;
        }
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDifferenceMode(boolean bl) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.differenceMode = bl;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.status[i2] = 2;
                this.previousScanGauge[i2] = null;
            }
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDerivedGauge(Object object, int n2) {
        boolean bl;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.derivedGaugeTimestamp[n2] = System.currentTimeMillis();
            if (this.differenceMode) {
                if (this.previousScanGauge[n2] != null) {
                    this.setDerivedGaugeWithDifference((Number)object, n2);
                    bl = true;
                } else {
                    bl = false;
                }
                this.previousScanGauge[n2] = (Number)object;
            } else {
                this.derivedGauge[n2] = (Number)object;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n2) {
        boolean bl = false;
        String string = null;
        long l2 = 0L;
        String string2 = null;
        Number number = null;
        Number number2 = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.status[n2] == 2) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[n2], this.highThreshold, this.type[n2])) {
                    if (this.notifyHigh) {
                        bl = true;
                        string = MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED;
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        number = this.derivedGauge[n2];
                        number2 = this.highThreshold;
                    }
                    this.status[n2] = 1;
                } else if (this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n2], this.type[n2])) {
                    if (this.notifyLow) {
                        bl = true;
                        string = MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED;
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        number = this.derivedGauge[n2];
                        number2 = this.lowThreshold;
                    }
                    this.status[n2] = 0;
                }
            } else if (this.status[n2] == 0) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[n2], this.highThreshold, this.type[n2])) {
                    if (this.notifyHigh) {
                        bl = true;
                        string = MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED;
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        number = this.derivedGauge[n2];
                        number2 = this.highThreshold;
                    }
                    this.status[n2] = 1;
                }
            } else if (this.status[n2] == 1 && this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n2], this.type[n2])) {
                if (this.notifyLow) {
                    bl = true;
                    string = MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED;
                    l2 = this.derivedGaugeTimestamp[n2];
                    string2 = "";
                    number = this.derivedGauge[n2];
                    number2 = this.lowThreshold;
                }
                this.status[n2] = 0;
            }
        }
        if (bl) {
            this.sendNotification(string, l2, string2, number, number2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThresholdTypeValid(int n2) {
        boolean bl = false;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            switch (this.type[n2]) {
                case 0: {
                    if (!(this.highThreshold instanceof Integer) || !(this.lowThreshold instanceof Integer)) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (!(this.highThreshold instanceof Byte) || !(this.lowThreshold instanceof Byte)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!(this.highThreshold instanceof Short) || !(this.lowThreshold instanceof Short)) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (!(this.highThreshold instanceof Long) || !(this.lowThreshold instanceof Long)) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (!(this.highThreshold instanceof Float) || !(this.lowThreshold instanceof Float)) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (!(this.highThreshold instanceof Double) || !(this.lowThreshold instanceof Double)) break;
                    bl = true;
                    break;
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("isThresholdTypeValid", "the threshold type is invalid");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDerivedGaugeWithDifference(Number number, int n2) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            switch (this.type[n2]) {
                case 0: {
                    this.derivedGauge[n2] = new Integer((Integer)number - (Integer)this.previousScanGauge[n2]);
                    break;
                }
                case 1: {
                    this.derivedGauge[n2] = new Byte((byte)((Byte)number - (Byte)this.previousScanGauge[n2]));
                    break;
                }
                case 2: {
                    this.derivedGauge[n2] = new Short((short)((Short)number - (Short)this.previousScanGauge[n2]));
                    break;
                }
                case 3: {
                    this.derivedGauge[n2] = new Long((Long)number - (Long)this.previousScanGauge[n2]);
                    break;
                }
                case 4: {
                    this.derivedGauge[n2] = new Float(((Float)number).floatValue() - ((Float)this.previousScanGauge[n2]).floatValue());
                    break;
                }
                case 5: {
                    this.derivedGauge[n2] = new Double((Double)number - (Double)this.previousScanGauge[n2]);
                }
                default: {
                    if (!this.isDebugOn()) break;
                    this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
                }
            }
        }
    }

    private boolean isFirstGreaterThanLast(Number number, Number number2, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (number.longValue() < number2.longValue()) break;
                bl = true;
                break;
            }
            case 4: 
            case 5: {
                if (!(number.doubleValue() >= number2.doubleValue())) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isFirstGreaterThanLast", "the threshold type is invalid");
            }
        }
        return bl;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number number, Number number2, String string) {
        boolean bl = false;
        if (string.equals("java.lang.Integer") || string.equals("java.lang.Byte") || string.equals("java.lang.Short") || string.equals("java.lang.Long")) {
            if (number.longValue() > number2.longValue()) {
                bl = true;
            }
        } else if (string.equals("java.lang.Float") || string.equals("java.lang.Double")) {
            if (number.doubleValue() > number2.doubleValue()) {
                bl = true;
            }
        } else if (this.isDebugOn()) {
            this.debug("isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n2) {
        boolean bl = false;
        String string = null;
        long l2 = 0L;
        String string2 = null;
        Number number = null;
        Object var8_7 = null;
        Object object = null;
        String string3 = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            block35: {
                try {
                    if (!this.isActive()) break block35;
                    if (this.getObservedObject(n2) == null || this.getObservedAttribute() == null) {
                        return;
                    }
                    try {
                        object = this.server.getAttribute(this.getObservedObject(n2), this.getObservedAttribute());
                        if (object == null) {
                            return;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        if ((this.alreadyNotifieds[n2] & 8) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(n2, 8);
                        throw new MonitorSettingException("The gauge monitor must be registered in the MBean server.");
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        if ((this.alreadyNotifieds[n2] & 1) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_OBJECT_ERROR;
                        this.setAlreadyNotified(n2, 1);
                        throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {
                        if ((this.alreadyNotifieds[n2] & 2) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(n2, 2);
                        throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                    }
                    catch (MBeanException mBeanException) {
                        if ((this.alreadyNotifieds[n2] & 8) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.RUNTIME_ERROR;
                        this.setAlreadyNotified(n2, 8);
                        throw new MonitorSettingException(mBeanException.getMessage());
                    }
                    catch (ReflectionException reflectionException) {
                        if ((this.alreadyNotifieds[n2] & 2) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                        this.setAlreadyNotified(n2, 2);
                        throw new MonitorSettingException(reflectionException.getMessage());
                    }
                    if (object instanceof Integer) {
                        this.type[n2] = 0;
                    } else if (object instanceof Byte) {
                        this.type[n2] = 1;
                    } else if (object instanceof Short) {
                        this.type[n2] = 2;
                    } else if (object instanceof Long) {
                        this.type[n2] = 3;
                    } else if (object instanceof Float) {
                        this.type[n2] = 4;
                    } else if (object instanceof Double) {
                        this.type[n2] = 5;
                    } else {
                        if ((this.alreadyNotifieds[n2] & 4) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                        this.setAlreadyNotified(n2, 4);
                        throw new MonitorSettingException("The observed attribute type must be an integer type or a floating-point type.");
                    }
                    if (!this.isThresholdTypeValid(n2)) {
                        if ((this.alreadyNotifieds[n2] & 0x10) != 0) {
                            return;
                        }
                        string3 = MonitorNotification.THRESHOLD_ERROR;
                        this.setAlreadyNotified(n2, 16);
                        throw new MonitorSettingException("The threshold high and threshold low must be of the same type as the gauge.");
                    }
                    this.resetAllAlreadyNotified(n2);
                    boolean bl2 = this.updateDerivedGauge(object, n2);
                    if (bl2) {
                        this.updateNotifications(n2);
                    }
                }
                catch (MonitorSettingException monitorSettingException) {
                    bl = true;
                    string = string3;
                    l2 = this.derivedGaugeTimestamp[n2];
                    string2 = monitorSettingException.getMessage();
                    number = this.derivedGauge[n2];
                    var8_7 = null;
                    this.status[n2] = 2;
                    this.previousScanGauge[n2] = null;
                }
            }
        }
        if (bl) {
            this.sendNotification(string, l2, string2, number, var8_7, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertSpecificElementAt(int n2) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            Integer n3 = new Integer(0);
            this.insertNumberElementAt(this.derivedGauge, n3, n2);
            this.insertNumberElementAt(this.previousScanGauge, null, n2);
            this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), n2);
            this.insertintElementAt(this.status, 2, n2);
            this.insertintElementAt(this.type, 0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpecificElementAt(int n2) {
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            this.removeNumberElementAt(this.derivedGauge, n2);
            this.removeNumberElementAt(this.previousScanGauge, n2);
            this.removelongElementAt(this.derivedGaugeTimestamp, n2);
            this.removeintElementAt(this.status, n2);
            this.removeintElementAt(this.type, n2);
        }
    }

    private static class GaugeAlarmClock
    extends TimerTask {
        GaugeMonitor listener = null;

        public GaugeAlarmClock(GaugeMonitor gaugeMonitor) {
            this.listener = gaugeMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i2 = 0; i2 < this.listener.elementCount; ++i2) {
                    this.listener.notifyAlarmClock(i2);
                }
            }
        }
    }
}

