/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.management.JMException;
import javax.management.loading.DefaultLoaderRepository;
import mx4j.adaptor.http.CommandProcessorUtil;
import mx4j.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConstructorsCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        String classname = in.getVariable("classname");
        if (classname == null || classname.trim().length() == 0) {
            return this.createException(document, "", "classname parameter required");
        }
        Class<?> targetClass = null;
        try {
            targetClass = DefaultLoaderRepository.loadClass(classname);
        }
        catch (ClassNotFoundException e2) {
            // empty catch block
        }
        try {
            if (targetClass == null) {
                targetClass = ClassLoader.getSystemClassLoader().loadClass(classname);
            }
        }
        catch (ClassNotFoundException e3) {
            // empty catch block
        }
        try {
            if (targetClass == null) {
                targetClass = this.getClass().getClassLoader().loadClass(classname);
            }
        }
        catch (ClassNotFoundException e4) {
            // empty catch block
        }
        if (targetClass == null) {
            return this.createException(document, classname, "class " + classname + " not found");
        }
        Element root = document.createElement("Class");
        root.setAttribute("classname", classname);
        document.appendChild(root);
        Constructor<?>[] constructors = targetClass.getConstructors();
        int i2 = 0;
        while (i2 < constructors.length) {
            Element constructor = document.createElement("Constructor");
            constructor.setAttribute("name", constructors[i2].getName());
            this.addParameters(constructor, document, constructors[i2].getParameterTypes());
            root.appendChild(constructor);
            ++i2;
        }
        return document;
    }

    protected void addParameters(Element node, Document document, Class[] parameters) {
        int j2 = 0;
        while (j2 < parameters.length) {
            Element parameter = document.createElement("Parameter");
            parameter.setAttribute("type", parameters[j2].getName());
            parameter.setAttribute("strinit", String.valueOf(CommandProcessorUtil.canCreateParameterValue(parameters[j2].getName())));
            parameter.setAttribute("id", "" + j2);
            node.appendChild(parameter);
            ++j2;
        }
    }

    private Document createException(Document document, String classname, String message) {
        Element exceptionElement = document.createElement("Exception");
        document.appendChild(exceptionElement);
        exceptionElement.setAttribute("classname", classname);
        exceptionElement.setAttribute("errorMsg", message);
        return document;
    }
}

