/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import mx4j.adaptor.http.CommandProcessorUtil;
import mx4j.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MBeanCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        String name = in.getVariable("objectname");
        ObjectName objectName = null;
        boolean validMBean = false;
        if (name != null && this.server.isRegistered(objectName = new ObjectName(name))) {
            validMBean = true;
        }
        if (validMBean) {
            MBeanNotificationInfo[] notifications;
            MBeanOperationInfo[] operations;
            MBeanConstructorInfo[] constructors;
            int i2;
            MBeanAttributeInfo[] attributes;
            Element root = document.createElement("MBean");
            document.appendChild(root);
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            root.setAttribute("description", info.getDescription());
            root.setAttribute("classname", info.getClassName());
            root.setAttribute("objectname", objectName.toString());
            if (info instanceof ModelMBeanInfo) {
                root.setAttribute("model", "true");
            }
            if (HttpUtil.booleanVariableValue(in, "attributes", true) && (attributes = info.getAttributes()) != null) {
                i2 = 0;
                while (i2 < attributes.length) {
                    Element attribute = document.createElement("Attribute");
                    attribute.setAttribute("name", attributes[i2].getName());
                    attribute.setAttribute("type", attributes[i2].getType());
                    attribute.setAttribute("description", attributes[i2].getDescription());
                    attribute.setAttribute("strinit", String.valueOf(CommandProcessorUtil.canCreateParameterValue(attributes[i2].getType())));
                    if (attributes[i2].isReadable() && attributes[i2].isWritable()) {
                        attribute.setAttribute("availability", "RW");
                    }
                    if (attributes[i2].isReadable() && !attributes[i2].isWritable()) {
                        attribute.setAttribute("availability", "RO");
                    }
                    if (!attributes[i2].isReadable() && attributes[i2].isWritable()) {
                        attribute.setAttribute("availability", "WO");
                    }
                    try {
                        Object attributeValue = this.server.getAttribute(objectName, attributes[i2].getName());
                        attribute.setAttribute("isnull", attributeValue == null ? "true" : "false");
                        if (attributeValue != null) {
                            attribute.setAttribute("value", attributeValue.toString());
                            if (attributeValue.getClass().isArray()) {
                                attribute.setAttribute("aggregation", "array");
                            }
                            if (attributeValue instanceof Collection) {
                                attribute.setAttribute("aggregation", "collection");
                            }
                            if (attributeValue instanceof Map) {
                                attribute.setAttribute("aggregation", "map");
                            }
                        } else {
                            attribute.setAttribute("value", "null");
                        }
                    }
                    catch (JMException e2) {
                        attribute.setAttribute("value", e2.getMessage());
                    }
                    root.appendChild(attribute);
                    ++i2;
                }
            }
            if (HttpUtil.booleanVariableValue(in, "constructors", true) && (constructors = info.getConstructors()) != null) {
                i2 = 0;
                while (i2 < constructors.length) {
                    Element constructor = document.createElement("Constructor");
                    constructor.setAttribute("name", constructors[i2].getName());
                    constructor.setAttribute("description", constructors[i2].getDescription());
                    this.addParameters(constructor, document, constructors[i2].getSignature());
                    root.appendChild(constructor);
                    ++i2;
                }
            }
            if (HttpUtil.booleanVariableValue(in, "operations", true) && (operations = info.getOperations()) != null) {
                i2 = 0;
                while (i2 < operations.length) {
                    Element operation = document.createElement("Operation");
                    operation.setAttribute("name", operations[i2].getName());
                    operation.setAttribute("description", operations[i2].getDescription());
                    operation.setAttribute("return", operations[i2].getReturnType());
                    switch (operations[i2].getImpact()) {
                        case 3: {
                            operation.setAttribute("impact", "unknown");
                            break;
                        }
                        case 1: {
                            operation.setAttribute("impact", "action");
                            break;
                        }
                        case 0: {
                            operation.setAttribute("impact", "info");
                            break;
                        }
                        case 2: {
                            operation.setAttribute("impact", "action_info");
                        }
                    }
                    this.addParameters(operation, document, operations[i2].getSignature());
                    root.appendChild(operation);
                    ++i2;
                }
            }
            if (HttpUtil.booleanVariableValue(in, "notifications", true) && (notifications = info.getNotifications()) != null) {
                i2 = 0;
                while (i2 < notifications.length) {
                    Element notification = document.createElement("Notification");
                    notification.setAttribute("name", notifications[i2].getName());
                    notification.setAttribute("description", notifications[i2].getDescription());
                    String[] types = notifications[i2].getNotifTypes();
                    int j2 = 0;
                    while (j2 < types.length) {
                        Element type = document.createElement("Type");
                        type.setAttribute("name", types[j2]);
                        notification.appendChild(type);
                        ++j2;
                    }
                    root.appendChild(notification);
                    ++i2;
                }
            }
        }
        return document;
    }

    protected void addParameters(Element node, Document document, MBeanParameterInfo[] parameters) {
        int j2 = 0;
        while (j2 < parameters.length) {
            Element parameter = document.createElement("Parameter");
            parameter.setAttribute("name", parameters[j2].getName());
            parameter.setAttribute("description", parameters[j2].getDescription());
            parameter.setAttribute("type", parameters[j2].getType());
            parameter.setAttribute("strinit", String.valueOf(CommandProcessorUtil.canCreateParameterValue(parameters[j2].getType())));
            parameter.setAttribute("id", "" + j2);
            node.appendChild(parameter);
            ++j2;
        }
    }
}

