/*
 * Decompiled with CFR 0.152.
 */
package mx4j.connector.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import mx4j.adaptor.interceptor.Invocation;
import mx4j.adaptor.interceptor.InvocationContext;
import mx4j.adaptor.interceptor.InvocationResult;
import mx4j.adaptor.rmi.RemoteAdaptor;
import mx4j.connector.JMXAddress;
import mx4j.connector.JMXConnector;
import mx4j.connector.RemoteMBeanServer;
import mx4j.connector.rmi.RemoteNotificationFilterSupport;
import mx4j.connector.rmi.RemoteNotificationListenerSupport;

public abstract class RMIConnector
implements JMXConnector,
Serializable {
    private RemoteAdaptor remoteAdaptor;
    private transient RemoteMBeanServer m_server;
    private transient ThreadLocal m_context = new ThreadLocal();
    private transient ThreadLocal m_classloaderKey = new ThreadLocal();
    private transient ThreadLocal m_objectName = new ThreadLocal();
    static /* synthetic */ Class class$mx4j$connector$RemoteMBeanServer;

    private void connect(JMXAddress address) throws NamingException {
        String proto = address.getProtocol();
        if (!(proto.equalsIgnoreCase("rmi") || proto.equalsIgnoreCase("jrmp") || proto.equalsIgnoreCase("iiop"))) {
            throw new IllegalArgumentException("Bad protocol in address: " + proto);
        }
        String provider = proto + "://" + address.getHost();
        int port = address.getPort();
        if (port > 0) {
            provider = provider + ":" + port;
        }
        Map map = address.getProperties();
        map.put("java.naming.provider.url", provider);
        this.connect(address.getPath(), new Hashtable(map));
    }

    public void connect(String jndiName, Hashtable properties) throws NamingException {
        if (jndiName == null) {
            throw new NamingException("Null JNDI name");
        }
        InitialContext ctx = new InitialContext(properties);
        Object object = ctx.lookup(jndiName);
        this.remoteAdaptor = this.narrow(object);
    }

    public RemoteMBeanServer getRemoteMBeanServer() {
        if (this.remoteAdaptor == null) {
            throw new IllegalStateException("connect() has not been called");
        }
        if (this.m_server == null) {
            this.m_server = new RemoteMBeanServerImpl();
        }
        return this.m_server;
    }

    protected abstract RemoteAdaptor narrow(Object var1);

    public void setInvocationContext(InvocationContext context) {
        this.m_context.set(context);
    }

    private InvocationContext getInvocationContext() {
        return (InvocationContext)this.m_context.get();
    }

    private void setClassLoaderKey(String key) {
        this.m_classloaderKey.set(key);
    }

    private String getClassLoaderKey() {
        return (String)this.m_classloaderKey.get();
    }

    private void setObjectNameForClassLoader(ObjectName name) {
        this.m_objectName.set(name);
    }

    private ObjectName getObjectNameForClassLoader() {
        return (ObjectName)this.m_objectName.get();
    }

    public String getRemoteHostName() throws RemoteException {
        return this.remoteAdaptor.getHostName();
    }

    public String getRemoteHostAddress() throws RemoteException {
        return this.remoteAdaptor.getHostAddress();
    }

    public void close() {
        this.remoteAdaptor = null;
    }

    protected abstract NotificationListener createRemoteNotificationListener(NotificationListener var1) throws RemoteException;

    protected abstract NotificationFilter createRemoteNotificationFilter(NotificationFilter var1) throws RemoteException;

    protected Object invoke(String key, ObjectName objectName, String methodName, String[] signature, Object[] arguments) throws Exception {
        if (this.remoteAdaptor == null) {
            throw new IllegalStateException("The connector has been closed");
        }
        Invocation invocation = new Invocation();
        invocation.setClassLoaderKey(key);
        invocation.setObjectNameForClassLoader(objectName);
        invocation.setMethodName(methodName);
        invocation.setSignature(signature);
        invocation.setArguments(arguments);
        invocation.setInvocationContext(this.getInvocationContext());
        InvocationResult result = this.remoteAdaptor.invoke(invocation);
        return result.getResult();
    }

    private Object[] marshalObjects(Object[] args) throws IOException {
        if (args == null) {
            return null;
        }
        Object[] marshalled = new Object[args.length];
        int i2 = 0;
        while (i2 < marshalled.length) {
            Object arg = args[i2];
            marshalled[i2] = this.marshalObject(arg);
            ++i2;
        }
        return marshalled;
    }

    private Object marshalObject(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().getClassLoader() == null && !(obj instanceof MarshalledObject)) {
            return obj;
        }
        return new MarshalledObject<Object>(obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RemoteMBeanServerImpl
    implements RemoteMBeanServer {
        private RemoteMBeanServer m_proxy;
        private HashMap m_listeners = new HashMap();
        private HashMap m_filters = new HashMap();
        private HashMap m_handbacks = new HashMap();

        private RemoteMBeanServerImpl() {
            this.m_proxy = (RemoteMBeanServer)Proxy.newProxyInstance((class$mx4j$connector$RemoteMBeanServer == null ? (class$mx4j$connector$RemoteMBeanServer = RMIConnector.class$("mx4j.connector.RemoteMBeanServer")) : class$mx4j$connector$RemoteMBeanServer).getClassLoader(), new Class[]{class$mx4j$connector$RemoteMBeanServer == null ? (class$mx4j$connector$RemoteMBeanServer = RMIConnector.class$("mx4j.connector.RemoteMBeanServer")) : class$mx4j$connector$RemoteMBeanServer}, (InvocationHandler)new Handler());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, RemoteException {
            if (listener == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
            }
            NotificationListener l2 = null;
            NotificationFilter f2 = null;
            Object h2 = null;
            RemoteMBeanServerImpl remoteMBeanServerImpl = this;
            synchronized (remoteMBeanServerImpl) {
                l2 = this.findListener(listener);
                f2 = this.findFilter(filter);
                h2 = this.findHandback(handback);
            }
            this.m_proxy.addNotificationListener(observed, l2, f2, h2);
            RemoteMBeanServerImpl remoteMBeanServerImpl2 = this;
            synchronized (remoteMBeanServerImpl2) {
                this.m_listeners.put(listener, l2);
                if (filter != null) {
                    this.m_filters.put(filter, f2);
                }
                if (handback != null) {
                    this.m_handbacks.put(handback, h2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
            if (listener == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("NotificationListener cannot be null"));
            }
            NotificationListener l2 = null;
            NotificationFilter f2 = null;
            Object h2 = null;
            RemoteMBeanServerImpl remoteMBeanServerImpl = this;
            synchronized (remoteMBeanServerImpl) {
                l2 = (NotificationListener)this.m_listeners.get(listener);
                f2 = (NotificationFilter)this.m_filters.get(filter);
                h2 = this.m_handbacks.get(handback);
            }
            this.m_proxy.removeNotificationListener(observed, l2, f2, h2);
            RemoteMBeanServerImpl remoteMBeanServerImpl2 = this;
            synchronized (remoteMBeanServerImpl2) {
                this.m_listeners.remove(listener);
                if (filter != null) {
                    this.m_filters.remove(filter);
                }
                if (handback != null) {
                    this.m_handbacks.remove(handback);
                }
            }
        }

        public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
            return this.createMBean(className, objectName, null, null);
        }

        public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
            return this.createMBean(className, objectName, loaderName, null, null);
        }

        public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
            try {
                RMIConnector.this.setClassLoaderKey("ClassLoaderRepository");
                Object[] marshalled = RMIConnector.this.marshalObjects(args);
                return this.m_proxy.createMBean(className, objectName, marshalled, parameters);
            }
            catch (RemoteException x2) {
                throw x2;
            }
            catch (IOException x3) {
                throw new ReflectionException(x3);
            }
        }

        public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
            try {
                RMIConnector.this.setClassLoaderKey(loaderName == null ? "MBeanServer" : "Loader");
                RMIConnector.this.setObjectNameForClassLoader(loaderName);
                Object[] marshalled = RMIConnector.this.marshalObjects(args);
                return this.m_proxy.createMBean(className, objectName, loaderName, marshalled, parameters);
            }
            catch (RemoteException x2) {
                throw x2;
            }
            catch (IOException x3) {
                throw new ReflectionException(x3);
            }
        }

        public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, RemoteException {
            this.m_proxy.unregisterMBean(objectName);
        }

        public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
            return this.m_proxy.getAttribute(objectName, attribute);
        }

        public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, RemoteException {
            try {
                RMIConnector.this.setClassLoaderKey("MBean");
                RMIConnector.this.setObjectNameForClassLoader(objectName);
                attribute = this.marshalAttribute(attribute);
                this.m_proxy.setAttribute(objectName, attribute);
            }
            catch (RemoteException x2) {
                throw x2;
            }
            catch (IOException x3) {
                throw new ReflectionException(x3);
            }
        }

        public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
            return this.m_proxy.getAttributes(objectName, attributes);
        }

        public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
            try {
                RMIConnector.this.setClassLoaderKey("MBean");
                RMIConnector.this.setObjectNameForClassLoader(objectName);
                AttributeList list = new AttributeList();
                int i2 = 0;
                while (i2 < attributes.size()) {
                    Attribute attribute = (Attribute)attributes.get(i2);
                    attribute = this.marshalAttribute(attribute);
                    list.add(attribute);
                    ++i2;
                }
                return this.m_proxy.setAttributes(objectName, list);
            }
            catch (IOException x2) {
                throw new ReflectionException(x2);
            }
        }

        public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
            try {
                RMIConnector.this.setClassLoaderKey("MBean");
                RMIConnector.this.setObjectNameForClassLoader(objectName);
                Object[] marshalled = RMIConnector.this.marshalObjects(args);
                return this.m_proxy.invoke(objectName, methodName, marshalled, parameters);
            }
            catch (RemoteException x2) {
                throw x2;
            }
            catch (IOException x3) {
                throw new ReflectionException(x3);
            }
        }

        public String getDefaultDomain() throws RemoteException {
            return this.m_proxy.getDefaultDomain();
        }

        public Integer getMBeanCount() throws RemoteException {
            return this.m_proxy.getMBeanCount();
        }

        public boolean isRegistered(ObjectName objectname) throws RemoteException {
            return this.m_proxy.isRegistered(objectname);
        }

        public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, RemoteException {
            return this.m_proxy.getMBeanInfo(objectName);
        }

        public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, RemoteException {
            return this.m_proxy.getObjectInstance(objectName);
        }

        public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException, RemoteException {
            return this.m_proxy.isInstanceOf(objectName, className);
        }

        public Set queryMBeans(ObjectName patternName, QueryExp filter) throws RemoteException {
            return this.m_proxy.queryMBeans(patternName, filter);
        }

        public Set queryNames(ObjectName patternName, QueryExp filter) throws RemoteException {
            return this.m_proxy.queryNames(patternName, filter);
        }

        private NotificationListener findListener(NotificationListener listener) throws RemoteException {
            NotificationListener l2 = (NotificationListener)this.m_listeners.get(listener);
            if (l2 != null) {
                return l2;
            }
            if (listener instanceof RemoteNotificationListenerSupport) {
                return listener;
            }
            return RMIConnector.this.createRemoteNotificationListener(listener);
        }

        private NotificationFilter findFilter(NotificationFilter filter) throws RemoteException {
            if (filter == null) {
                return null;
            }
            NotificationFilter f2 = (NotificationFilter)this.m_filters.get(filter);
            if (f2 != null) {
                return f2;
            }
            if (filter instanceof RemoteNotificationFilterSupport) {
                return filter;
            }
            return RMIConnector.this.createRemoteNotificationFilter(filter);
        }

        private Object findHandback(Object handback) {
            if (handback == null) {
                return null;
            }
            Object h2 = this.m_handbacks.get(handback);
            if (h2 != null) {
                return h2;
            }
            try {
                return RMIConnector.this.marshalObject(handback);
            }
            catch (IOException x2) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Handback is not serializable"));
            }
        }

        private Attribute marshalAttribute(Attribute attribute) throws IOException {
            Object marshalledValue;
            Object value = attribute.getValue();
            if (value != (marshalledValue = RMIConnector.this.marshalObject(value))) {
                attribute = new Attribute(attribute.getName(), marshalledValue);
            }
            return attribute;
        }

        private class Handler
        implements InvocationHandler {
            private Handler() {
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args == null) {
                    args = new Object[]{};
                }
                int length = method.getParameterTypes().length;
                String[] signature = new String[length];
                int i2 = 0;
                while (i2 < length) {
                    signature[i2] = method.getParameterTypes()[i2].getName();
                    ++i2;
                }
                String key = RMIConnector.this.getClassLoaderKey();
                RMIConnector.this.setClassLoaderKey(null);
                ObjectName name = RMIConnector.this.getObjectNameForClassLoader();
                RMIConnector.this.setObjectNameForClassLoader(null);
                Object retValue = RMIConnector.this.invoke(key, name, method.getName(), signature, args);
                return retValue;
            }
        }
    }
}

