/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.heartbeat;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.connector.RemoteMBeanServer;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.heartbeat.HeartBeatListenerControl;
import mx4j.tools.heartbeat.HeartBeatListenerMBean;

public class HeartBeatListener
implements HeartBeatListenerMBean,
HeartBeatListenerControl {
    private ObjectName m_name = null;
    private HashMap m_sources = new HashMap();
    private Thread m_bareListenerThread = null;
    private ListenerThread m_listenerThread = new ListenerThread();
    private boolean[] m_started = new boolean[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HeartBeatListener(String name) {
        try {
            this.m_name = new ObjectName(name);
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.m_started[0] = false;
        this.m_bareListenerThread = new Thread((Runnable)this.m_listenerThread, name);
        this.m_bareListenerThread.start();
        boolean[] blArray = this.m_started;
        synchronized (this.m_started) {
            while (!this.m_started[0]) {
                try {
                    this.m_started.wait();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void processHeartBeat(String heartBeatSource) {
        ObserverSession os = (ObserverSession)this.m_sources.get(heartBeatSource);
        if (os != null) {
            os.reset();
        }
    }

    public ObjectName getObjectName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserver(RemoteMBeanServer connector, Object connectorType, Object address, String heartBeatCanonName, NotificationListener observer) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
        ObjectName obName = new ObjectName(heartBeatCanonName);
        Object[] params = new Object[3];
        String[] signature = new String[3];
        params[0] = this.m_name.getCanonicalName();
        params[1] = connectorType;
        params[2] = address;
        signature[0] = "java.lang.String";
        signature[1] = "java.lang.Object";
        signature[2] = "java.lang.Object";
        connector.invoke(obName, "addHeartBeatListener", params, signature);
        ObserverSession os = new ObserverSession(heartBeatCanonName, observer);
        HashMap hashMap = this.m_sources;
        synchronized (hashMap) {
            this.m_sources.put(heartBeatCanonName, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObserver(String sourceCanonName, NotificationListener observer) {
        HashMap hashMap = this.m_sources;
        synchronized (hashMap) {
            this.m_sources.remove(sourceCanonName);
        }
    }

    public synchronized void stop() {
        this.m_listenerThread.stop();
        this.m_bareListenerThread.interrupt();
        Thread.currentThread();
        Thread.yield();
    }

    private class ListenerThread
    implements Runnable {
        private int m_period = 10;
        private boolean m_stop = false;

        public ListenerThread() {
            Properties env = System.getProperties();
            String p2 = env.getProperty("mx4j.heartbeat.period");
            if (p2 != null) {
                this.m_period = new Integer(p2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean[] blArray = HeartBeatListener.this.m_started;
            synchronized (blArray) {
                ((HeartBeatListener)HeartBeatListener.this).m_started[0] = true;
                HeartBeatListener.this.m_started.notifyAll();
            }
            do {
                try {
                    HashMap sources;
                    HashMap hashMap = HeartBeatListener.this.m_sources;
                    synchronized (hashMap) {
                        sources = (HashMap)HeartBeatListener.this.m_sources.clone();
                    }
                    Set keys = sources.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        String sourceName = (String)it.next();
                        ObserverSession sess = (ObserverSession)sources.get(sourceName);
                        sess.incrementCounter();
                        if (sess.shouldContinue()) continue;
                        NotificationListener observer = sess.getObserver();
                        Notification not = new Notification("lostHeartbeat", sourceName, 0L);
                        if (observer != null) {
                            observer.handleNotification(not, null);
                        }
                        Logger logger = HeartBeatListener.this.getLogger();
                        HashMap hashMap2 = HeartBeatListener.this.m_sources;
                        synchronized (hashMap2) {
                            HeartBeatListener.this.m_sources.remove(sourceName);
                            if (logger.isEnabledFor(10)) {
                                logger.debug("ListenerThread.run: removed source=" + sourceName);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    Thread.sleep(1000 * this.m_period);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            } while (!this.m_stop);
        }

        public synchronized void stop() {
            this.m_stop = true;
        }
    }

    private class ObserverSession {
        private String m_heartBeatName;
        private NotificationListener m_observer;
        private long m_heartBeatTime;
        private int FAIL_COUNTER_LIMIT = 3;
        private int m_failCount = 0;

        ObserverSession(String name, NotificationListener observer) {
            this.m_heartBeatName = name;
            this.m_observer = observer;
            this.m_heartBeatTime = System.currentTimeMillis();
            Properties env = System.getProperties();
            String p2 = env.getProperty("mx4j.heartbeat.tries");
            if (p2 != null) {
                this.FAIL_COUNTER_LIMIT = new Integer(p2);
            }
        }

        public void reset() {
            this.m_failCount = 0;
        }

        public void incrementCounter() {
            ++this.m_failCount;
            Logger logger = HeartBeatListener.this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.debug("ListenerThread.incrementCounter: " + this.m_heartBeatName + " count " + this.m_failCount);
            }
        }

        public NotificationListener getObserver() {
            return this.m_observer;
        }

        public String getHeartBeatName() {
            return this.m_heartBeatName;
        }

        public boolean shouldContinue() {
            return this.m_failCount <= this.FAIL_COUNTER_LIMIT;
        }
    }
}

