/*
 * Decompiled with CFR 0.152.
 */
package xjava.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import xjava.security.Cipher;
import xjava.security.IJCE;

public class CipherInputStream
extends FilterInputStream {
    private static final boolean DEBUG = true;
    private static int debuglevel = IJCE.getDebugLevel("CipherInputStream");
    private static PrintWriter err = IJCE.getDebugOutput();
    private Cipher cipher;
    private final byte[] preallocated1 = new byte[256];
    private final byte[] preallocated2 = new byte[256];
    private final byte[] tempByte = new byte[1];
    private byte[] outBuf;
    private int outPtr;
    private int buffered;
    private boolean isDPBC;

    private static void debug(String string) {
        err.println("CipherInputStream: " + string);
    }

    private static String dump(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return byArray.toString();
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray2;
        int n5;
        byte[] byArray3;
        if (debuglevel >= 5) {
            CipherInputStream.debug("read(<" + byArray + ">, " + n2 + ", " + n3 + ") ...");
        }
        if (this.cipher == null) {
            if (debuglevel >= 7) {
                CipherInputStream.debug("... stream closed");
            }
            return -1;
        }
        if (n3 <= 0) {
            return 0;
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("offset < 0");
        }
        int n6 = 0;
        if (this.buffered > 0) {
            n6 = this.buffered < n3 ? this.buffered : n3;
            System.arraycopy(this.outBuf, this.outPtr, byArray, n2, n6);
            this.outPtr += n6;
            this.buffered -= n6;
            n2 += n6;
            n3 -= n6;
            if (debuglevel >= 7) {
                CipherInputStream.debug("  outBuf = <" + CipherInputStream.dump(this.outBuf) + ">, outPtr = " + this.outPtr + ", buffered = " + this.buffered + ", offset = " + n2 + ", length = " + n3);
            }
            if (this.buffered == 0) {
                this.outPtr = 0;
            }
            if (n3 == 0) {
                if (debuglevel >= 5) {
                    CipherInputStream.debug("... = " + n6);
                }
                return n6;
            }
        }
        int n7 = this.cipher.inBufferSize(n3);
        if (this.isDPBC) {
            ++n7;
        }
        byte[] byArray4 = byArray3 = n7 <= this.preallocated1.length ? this.preallocated1 : new byte[n7];
        if (debuglevel >= 7) {
            CipherInputStream.debug("  inLen = " + n7);
        }
        if ((n5 = this.readFully(byArray3, 0, n7)) < n7) {
            Cipher cipher = this.cipher;
            this.cipher = null;
            int n8 = cipher.outBufferSizeFinal(n5);
            byArray2 = n8 <= this.preallocated2.length ? this.preallocated2 : new byte[n8];
            n4 = cipher.crypt(byArray3, 0, n5, byArray2, 0);
        } else {
            int n9 = this.cipher.outBufferSize(n5);
            byArray2 = n9 <= this.preallocated2.length ? this.preallocated2 : new byte[n9];
            n4 = this.cipher.update(byArray3, 0, n5, byArray2, 0);
        }
        if (debuglevel >= 7) {
            CipherInputStream.debug("  temp = <" + CipherInputStream.dump(byArray2) + ">, n = " + n4);
        }
        if (n4 > n3) {
            this.buffered = n4 - n3;
            if (this.buffered > this.outBuf.length) {
                this.outBuf = new byte[this.buffered];
            }
            System.arraycopy(byArray2, n3, this.outBuf, 0, this.buffered);
            n4 = n3;
            if (debuglevel >= 7) {
                CipherInputStream.debug("  buffered = " + this.buffered + ", length = " + n3 + ", n = " + n4);
            }
        }
        System.arraycopy(byArray2, 0, byArray, n2, n4);
        if ((n4 += n6) == 0 && this.cipher == null) {
            n4 = -1;
        }
        if (debuglevel >= 5) {
            CipherInputStream.debug("... = " + n4);
        }
        return n4;
    }

    private int readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        do {
            n5 = super.read(byArray, n4 += n5, n3 - n4);
            if (debuglevel < 7) continue;
            CipherInputStream.debug("  n = " + n4 + ", k = " + n5);
        } while (n5 >= 0 && n4 < n3);
        return n4;
    }

    public synchronized int read() throws IOException {
        if (this.read(this.tempByte, 0, 1) < 1) {
            return -1;
        }
        return this.tempByte[0] & 0xFF;
    }

    public synchronized long skip(long l2) throws IOException {
        int n2 = 100000;
        int n3 = l2 < 100000L ? (int)l2 : 100000;
        byte[] byArray = new byte[n3];
        long l3 = l2;
        while (l3 > 0L) {
            if ((n3 = this.read(byArray, 0, n3)) < 0) {
                return l2 - l3;
            }
            int n4 = n3 = (l3 -= (long)n3) < 100000L ? (int)l3 : 100000;
        }
        return l2;
    }

    public synchronized int available() throws IOException {
        if (this.cipher == null) {
            return 0;
        }
        return this.buffered + this.cipher.outBufferSize(super.available());
    }

    public synchronized void close() throws IOException {
        this.cipher = null;
        super.close();
    }

    public void mark(int n2) {
    }

    public void reset() throws IOException {
        throw new IOException("CipherInputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        if (cipher == null) {
            throw new NullPointerException("cipher");
        }
        int n2 = cipher.getState();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalStateException("cipher is uninitialized");
        }
        this.outBuf = new byte[cipher.getOutputBlockSize()];
        this.buffered = 0;
        this.outPtr = 0;
        this.isDPBC = cipher.isPaddingBlockCipher() && n2 == 2;
        this.cipher = cipher;
    }
}

