/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.app.mibbrowser;

import com.ireasoning.app.mibbrowser.MainFrame;
import com.ireasoning.app.mibbrowser.cc;
import com.ireasoning.app.mibbrowser.cq;
import com.ireasoning.app.mibbrowser.lc;
import com.ireasoning.app.mibbrowser.oc;
import com.ireasoning.app.mibbrowser.tb;
import com.ireasoning.app.mibbrowser.yc;
import com.ireasoning.util.AgentProperties;
import com.ireasoning.util.te;
import com.ireasoning.util.vd;
import java.util.ArrayList;

public class GraphCmd {
    private static int _port = 161;
    private static int _interval = 5000;
    private static String _outputFile = null;
    private static String _ipAddress;
    private static ArrayList _oids;
    private static short _snmpAction;
    private static String _community;
    private static boolean _roll;

    private static boolean parseArguments(String[] stringArray) {
        boolean bl2;
        block6: {
            int n2;
            int n3 = yc.z;
            vd vd2 = new vd(stringArray, "?hr", "ipoca");
            _port = Integer.parseInt(vd2.getOptionValue('p', "161"));
            _interval = Integer.parseInt(vd2.getOptionValue('i', "5")) * 1000;
            _outputFile = vd2.getOptionValue('o');
            _community = vd2.getOptionValue('c');
            _snmpAction = Short.parseShort(vd2.getOptionValue('a', "-1"));
            _roll = vd2.isSwitchPresent('r');
            String[] stringArray2 = vd2.getArguments();
            int n4 = stringArray2.length;
            if (n3 == 0) {
                if (n4 < 2) {
                    System.err.println("Parameters are not complete.");
                    return false;
                }
                _ipAddress = stringArray2[0];
                n4 = n2 = 1;
            }
            while (n2 < stringArray2.length) {
                bl2 = GraphCmd.isNumericalOID(stringArray2[n2]);
                if (n3 == 0) {
                    if (n3 == 0) {
                        if (!bl2) {
                            System.out.println("This OID is not numerical: " + stringArray2[n2]);
                            return false;
                        }
                        _oids.add(stringArray2[n2]);
                    }
                    ++n2;
                    if (n3 == 0) continue;
                }
                break block6;
            }
            System.out.println("port:" + _port + "; file:" + _outputFile + "; ip:" + _ipAddress + "; roll:" + _roll + "; interval:" + _interval / 1000);
            bl2 = true;
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        int n2 = yc.z;
        int n3 = stringArray.length;
        if (n2 == 0) {
            if (n3 == 0) {
                System.out.println("Usage: graph.bat [-options] IpAddress OID1 OID2 ...");
                System.out.println("Agent's properties (such as community name, SNMPv3 params are specified in the MIB browser's config file)");
                System.out.println();
                System.out.println("options:");
                System.out.println("\t-p port\t\tAgent's port number, default is 161.");
                System.out.println("\t-o fileName\tSave results to this file. If not present, results will be sent to stdout.");
                System.out.println("\t-i interval\tPolling interval, in seconds. Default value is 5.");
                System.out.println("\t-a \t\tSNMP action, 0 for Get, 1 for Get-Next, 2 for Get-Subtree.");
                System.out.println("\t-c community\tIf specified, it overwrites the value in the config file.");
                System.out.println("\t-r \t\tIf present, roll output file daily.");
                System.out.println();
                System.out.println("Examples:");
                System.out.println("graph.bat 192.168.1.1 .1.3.6.1.2.1.1.3.0");
                System.out.println("graph.bat -o d:\\data\\data1.txt -c password1 -i 30 -a 0 192.168.1.1 .1.3.6.1.2.1.1.3.0 .1.3.6.1.2.1.1.7.0");
                return;
            }
            n3 = GraphCmd.parseArguments(stringArray) ? 1 : 0;
        }
        if (n3 == 0) {
            return;
        }
        MainFrame.loadConfig();
        cc cc2 = MainFrame.getConfig();
        AgentProperties[] agentPropertiesArray = tb.getInstance().getAgents();
        AgentProperties agentProperties = null;
        int n4 = 0;
        while (n4 < agentPropertiesArray.length) {
            block12: {
                AgentProperties agentProperties2;
                block13: {
                    AgentProperties agentProperties3 = agentPropertiesArray[n4];
                    if (n2 != 0) continue;
                    if (!agentProperties3.getIpAddress().equals(_ipAddress)) break block12;
                    agentProperties2 = agentProperties3;
                    if (n2 != 0) break block13;
                    if (agentProperties2.getPort() != _port) break block12;
                    agentProperties2 = agentProperties3;
                }
                agentProperties = agentProperties2;
                break;
            }
            ++n4;
        }
        AgentProperties agentProperties4 = agentProperties;
        if (n2 == 0 && agentProperties4 == null) {
            agentProperties4 = agentProperties = new AgentProperties(_ipAddress, _port);
        }
        if (_community != null) {
            agentProperties.setCommunity(_community);
        }
        try {
            lc lc2 = new lc(_snmpAction);
            boolean bl2 = lc2.initConnector(agentProperties, _oids);
            if (n2 == 0) {
                bl2 = _outputFile == null;
            }
            boolean bl3 = bl2;
            oc oc2 = new oc(lc2, _outputFile, bl3);
            cq cq2 = new cq(null, null, lc2, oc2, _roll);
            cq2.setInterval(_interval);
            cq2.start();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public static boolean isNumericalOID(String string) {
        int n2;
        block6: {
            int n3;
            int n4 = yc.z;
            String[] stringArray = te.parse(string, '.', true, true);
            int n5 = stringArray.length;
            if (n4 == 0) {
                if (n5 < 2) {
                    return false;
                }
                n5 = n3 = 0;
            }
            while (n3 < stringArray.length) {
                n2 = stringArray[n3].length();
                if (n4 != 0) break block6;
                if (n4 == 0 && n2 != 0) {
                    try {
                        Integer.parseInt(stringArray[n3]);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                ++n3;
                if (n4 == 0) continue;
            }
            n2 = 1;
        }
        return n2 != 0;
    }

    static {
        _oids = new ArrayList();
        _snmpAction = (short)-1;
        _community = null;
        _roll = false;
    }
}

