/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;

public class UserDefinedTypeIdImpl
extends BaseTypeIdImpl {
    protected String className;

    public UserDefinedTypeIdImpl() {
    }

    public UserDefinedTypeIdImpl(String string) throws StandardException {
        if (string.charAt(0) == '\"') {
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string);
            this.schemaName = stringArray[0];
            this.unqualifiedName = stringArray[1];
            string = null;
        } else {
            this.schemaName = null;
            this.unqualifiedName = string;
            this.className = string;
        }
        this.JDBCTypeId = 2000;
    }

    public UserDefinedTypeIdImpl(String string, String string2, String string3) {
        super(string, string2);
        this.className = string3;
        this.JDBCTypeId = 2000;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean userType() {
        return true;
    }

    public boolean isBound() {
        return this.className != null;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.className = objectInput.readUTF();
        this.JDBCTypeId = 2000;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.className == null) {
            throw new IOException("Internal error: class name for user defined type has not been determined yet.");
        }
        objectOutput.writeUTF(this.className);
    }

    @Override
    public int getTypeFormatId() {
        return 264;
    }
}

