/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidators;
import org.apache.logging.log4j.core.config.plugins.visitors.PluginVisitor;
import org.apache.logging.log4j.core.config.plugins.visitors.PluginVisitors;
import org.apache.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import org.apache.logging.log4j.core.util.Assert;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.apache.logging.log4j.core.util.TypeUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StringBuilders;

public class PluginBuilder
implements Builder<Object> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final PluginType<?> pluginType;
    private final Class<?> clazz;
    private Configuration configuration;
    private Node node;
    private LogEvent event;

    public PluginBuilder(PluginType<?> pluginType) {
        this.pluginType = pluginType;
        this.clazz = pluginType.getPluginClass();
    }

    public PluginBuilder withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public PluginBuilder withConfigurationNode(Node node) {
        this.node = node;
        return this;
    }

    public PluginBuilder forLogEvent(LogEvent event) {
        this.event = event;
        return this;
    }

    @Override
    public Object build() {
        this.verify();
        try {
            LOGGER.debug("Building Plugin[name={}, class={}]. Searching for builder factory method...", this.pluginType.getElementName(), this.pluginType.getPluginClass().getName());
            Builder<?> builder = PluginBuilder.createBuilder(this.clazz);
            if (builder != null) {
                this.injectFields(builder);
                Object result = builder.build();
                LOGGER.debug("Built Plugin[name={}] OK from builder factory method.", this.pluginType.getElementName());
                return result;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to inject fields into builder class for plugin type {}, element {}.", this.clazz, this.node.getName(), e);
        }
        try {
            LOGGER.debug("Still building Plugin[name={}, class={}]. Searching for factory method...", this.pluginType.getElementName(), this.pluginType.getPluginClass().getName());
            Method factory = PluginBuilder.findFactoryMethod(this.clazz);
            Object[] params = this.generateParameters(factory);
            Object plugin = factory.invoke(null, params);
            LOGGER.debug("Built Plugin[name={}] OK from factory method.", this.pluginType.getElementName());
            return plugin;
        }
        catch (Exception e) {
            LOGGER.error("Unable to invoke factory method in class {} for element {}.", this.clazz, this.node.getName(), e);
            return null;
        }
    }

    private void verify() {
        Assert.requireNonNull(this.configuration, "No Configuration object was set.");
        Assert.requireNonNull(this.node, "No Node object was set.");
    }

    private static Builder<?> createBuilder(Class<?> clazz) throws InvocationTargetException, IllegalAccessException {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PluginBuilderFactory.class) || !Modifier.isStatic(method.getModifiers()) || !TypeUtil.isAssignable(Builder.class, method.getGenericReturnType())) continue;
            ReflectionUtil.makeAccessible(method);
            Builder builder = (Builder)method.invoke(null, new Object[0]);
            LOGGER.debug("Found builder factory method [{}]: {}.", method.getName(), method);
            return builder;
        }
        LOGGER.debug("No builder factory method found in class {}. Going to try finding a factory method instead.", clazz.getName());
        return null;
    }

    private void injectFields(Builder<?> builder) throws IllegalAccessException {
        AccessibleObject[] fields = builder.getClass().getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        StringBuilder log = new StringBuilder();
        boolean invalid = false;
        for (AccessibleObject field : fields) {
            log.append(log.length() == 0 ? "with params(" : ", ");
            Annotation[] annotations = ((Field)field).getDeclaredAnnotations();
            String[] aliases = PluginBuilder.extractPluginAliases(annotations);
            for (Annotation a : annotations) {
                Object value;
                PluginVisitor<? extends Annotation> visitor;
                if (a instanceof PluginAliases || (visitor = PluginVisitors.findVisitor(a.annotationType())) == null || (value = visitor.setAliases(aliases).setAnnotation(a).setConversionType(((Field)field).getType()).setStrSubstitutor(this.event == null ? new ConfigurationStrSubstitutor(this.configuration.getStrSubstitutor()) : this.configuration.getStrSubstitutor()).setMember((Member)((Object)field)).visit(this.configuration, this.node, this.event, log)) == null) continue;
                ((Field)field).set(builder, value);
            }
            Collection<ConstraintValidator<?>> validators = ConstraintValidators.findValidators(annotations);
            Object value = ((Field)field).get(builder);
            for (ConstraintValidator<?> validator : validators) {
                if (validator.isValid(value)) continue;
                invalid = true;
            }
        }
        if (log.length() > 0) {
            log.append(')');
        }
        LOGGER.debug("Calling build() on class {} for element {} {}", builder.getClass(), this.node.getName(), log.toString());
        if (invalid) {
            throw new ConfigurationException("Arguments given for element " + this.node.getName() + " are invalid");
        }
        this.checkForRemainingAttributes();
        this.verifyNodeChildrenUsed();
    }

    private static Method findFactoryMethod(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PluginFactory.class) || !Modifier.isStatic(method.getModifiers())) continue;
            LOGGER.debug("Found factory method [{}]: {}.", method.getName(), method);
            ReflectionUtil.makeAccessible(method);
            return method;
        }
        throw new IllegalStateException("No factory method found for class " + clazz.getName());
    }

    private Object[] generateParameters(Method factory) {
        StringBuilder log = new StringBuilder();
        Class<?>[] types = factory.getParameterTypes();
        Annotation[][] annotations = factory.getParameterAnnotations();
        Object[] args = new Object[annotations.length];
        boolean invalid = false;
        for (int i = 0; i < annotations.length; ++i) {
            log.append(log.length() == 0 ? "with params(" : ", ");
            String[] aliases = PluginBuilder.extractPluginAliases(annotations[i]);
            for (Annotation a : annotations[i]) {
                Object value;
                PluginVisitor<? extends Annotation> visitor;
                if (a instanceof PluginAliases || (visitor = PluginVisitors.findVisitor(a.annotationType())) == null || (value = visitor.setAliases(aliases).setAnnotation(a).setConversionType(types[i]).setStrSubstitutor(this.event == null ? new ConfigurationStrSubstitutor(this.configuration.getStrSubstitutor()) : this.configuration.getStrSubstitutor()).setMember(factory).visit(this.configuration, this.node, this.event, log)) == null) continue;
                args[i] = value;
            }
            Collection<ConstraintValidator<?>> validators = ConstraintValidators.findValidators(annotations[i]);
            Object value = args[i];
            for (ConstraintValidator<?> validator : validators) {
                if (validator.isValid(value)) continue;
                invalid = true;
            }
        }
        if (log.length() > 0) {
            log.append(')');
        }
        this.checkForRemainingAttributes();
        this.verifyNodeChildrenUsed();
        LOGGER.debug("Calling {} on class {} for element {} {}", factory.getName(), this.clazz.getName(), this.node.getName(), log.toString());
        if (invalid) {
            throw new ConfigurationException("Arguments given for element " + this.node.getName() + " are invalid");
        }
        return args;
    }

    private static String[] extractPluginAliases(Annotation ... parmTypes) {
        String[] aliases = null;
        for (Annotation a : parmTypes) {
            if (!(a instanceof PluginAliases)) continue;
            aliases = ((PluginAliases)a).value();
        }
        return aliases;
    }

    private void checkForRemainingAttributes() {
        Map<String, String> attrs = this.node.getAttributes();
        if (!attrs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : attrs.keySet()) {
                if (sb.length() == 0) {
                    sb.append(this.node.getName());
                    sb.append(" contains ");
                    if (attrs.size() == 1) {
                        sb.append("an invalid element or attribute ");
                    } else {
                        sb.append("invalid attributes ");
                    }
                } else {
                    sb.append(", ");
                }
                StringBuilders.appendDqValue(sb, key);
            }
            LOGGER.error(sb.toString());
        }
    }

    private void verifyNodeChildrenUsed() {
        List<Node> children = this.node.getChildren();
        if (!this.pluginType.isDeferChildren() && !children.isEmpty()) {
            for (Node child : children) {
                String nodeType = this.node.getType().getElementName();
                String start = nodeType.equals(this.node.getName()) ? this.node.getName() : nodeType + ' ' + this.node.getName();
                LOGGER.error("{} has no parameter that matches element {}", start, child.getName());
            }
        }
    }
}

