/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.message.LoggerNameAwareMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.TimestampMessage;

public class Log4jLogEvent
implements LogEvent {
    private static final long serialVersionUID = -1351367343806656055L;
    private static final Clock clock = ClockFactory.getClock();
    private final String loggerFqcn;
    private final Marker marker;
    private final Level level;
    private final String loggerName;
    private final Message message;
    private final long timeMillis;
    private final transient Throwable thrown;
    private ThrowableProxy thrownProxy;
    private final Map<String, String> contextMap;
    private final ThreadContext.ContextStack contextStack;
    private String threadName = null;
    private StackTraceElement source;
    private boolean includeLocation;
    private boolean endOfBatch = false;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Log4jLogEvent() {
        this(clock.currentTimeMillis());
    }

    public Log4jLogEvent(long timestamp) {
        this("", null, "", null, null, null, null, null, null, null, timestamp);
    }

    public Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable t) {
        this(loggerName, marker, loggerFQCN, level, message, null, t);
    }

    public Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, List<Property> properties, Throwable t) {
        this(loggerName, marker, loggerFQCN, level, message, t, Log4jLogEvent.createMap(properties), ThreadContext.getDepth() == 0 ? null : ThreadContext.cloneStack(), null, null, message instanceof TimestampMessage ? ((TimestampMessage)((Object)message)).getTimestamp() : clock.currentTimeMillis());
    }

    public Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable t, Map<String, String> mdc, ThreadContext.ContextStack ndc, String threadName, StackTraceElement location, long timestamp) {
        this(loggerName, marker, loggerFQCN, level, message, t, null, mdc, ndc, threadName, location, timestamp);
    }

    public static Log4jLogEvent createEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable thrown, ThrowableProxy thrownProxy, Map<String, String> mdc, ThreadContext.ContextStack ndc, String threadName, StackTraceElement location, long timestamp) {
        Log4jLogEvent result = new Log4jLogEvent(loggerName, marker, loggerFQCN, level, message, thrown, thrownProxy, mdc, ndc, threadName, location, timestamp);
        return result;
    }

    private Log4jLogEvent(String loggerName, Marker marker, String loggerFQCN, Level level, Message message, Throwable thrown, ThrowableProxy thrownProxy, Map<String, String> contextMap, ThreadContext.ContextStack contextStack, String threadName, StackTraceElement source, long timestamp) {
        this.loggerName = loggerName;
        this.marker = marker;
        this.loggerFqcn = loggerFQCN;
        this.level = level == null ? Level.OFF : level;
        this.message = message;
        this.thrown = thrown;
        this.thrownProxy = thrownProxy;
        this.contextMap = contextMap == null ? ThreadContext.EMPTY_MAP : contextMap;
        this.contextStack = contextStack == null ? ThreadContext.EMPTY_STACK : contextStack;
        this.timeMillis = message instanceof TimestampMessage ? ((TimestampMessage)((Object)message)).getTimestamp() : timestamp;
        this.threadName = threadName;
        this.source = source;
        if (message != null && message instanceof LoggerNameAwareMessage) {
            ((LoggerNameAwareMessage)((Object)message)).setLoggerName(loggerName);
        }
    }

    private static Map<String, String> createMap(List<Property> properties) {
        Map<String, String> contextMap = ThreadContext.getImmutableContext();
        if (contextMap == null && (properties == null || properties.isEmpty())) {
            return null;
        }
        if (properties == null || properties.isEmpty()) {
            return contextMap;
        }
        HashMap<String, String> map = new HashMap<String, String>(contextMap);
        for (Property prop : properties) {
            if (map.containsKey(prop.getName())) continue;
            map.put(prop.getName(), prop.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    @Override
    public long getTimeMillis() {
        return this.timeMillis;
    }

    @Override
    public Throwable getThrown() {
        return this.thrown;
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        if (this.thrownProxy == null && this.thrown != null) {
            this.thrownProxy = new ThrowableProxy(this.thrown);
        }
        return this.thrownProxy;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public String getLoggerFqcn() {
        return this.loggerFqcn;
    }

    @Override
    public Map<String, String> getContextMap() {
        return this.contextMap;
    }

    @Override
    public ThreadContext.ContextStack getContextStack() {
        return this.contextStack;
    }

    @Override
    public StackTraceElement getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.loggerFqcn == null || !this.includeLocation) {
            return null;
        }
        this.source = Log4jLogEvent.calcLocation(this.loggerFqcn);
        return this.source;
    }

    public static StackTraceElement calcLocation(String fqcnOfLogger) {
        if (fqcnOfLogger == null) {
            return null;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement last = null;
        for (int i = stackTrace.length - 1; i > 0; --i) {
            String className = stackTrace[i].getClassName();
            if (fqcnOfLogger.equals(className)) {
                return last;
            }
            last = stackTrace[i];
        }
        return null;
    }

    @Override
    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    @Override
    public void setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
    }

    @Override
    public boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    @Override
    public void setEndOfBatch(boolean endOfBatch) {
        this.endOfBatch = endOfBatch;
    }

    protected Object writeReplace() {
        this.getThrownProxy();
        return new LogEventProxy(this, this.includeLocation);
    }

    public static Serializable serialize(Log4jLogEvent event, boolean includeLocation) {
        event.getThrownProxy();
        return new LogEventProxy(event, includeLocation);
    }

    public static boolean canDeserialize(Serializable event) {
        return event instanceof LogEventProxy;
    }

    public static Log4jLogEvent deserialize(Serializable event) {
        if (event == null) {
            throw new NullPointerException("Event cannot be null");
        }
        if (event instanceof LogEventProxy) {
            LogEventProxy proxy = (LogEventProxy)event;
            Log4jLogEvent result = new Log4jLogEvent(proxy.loggerName, proxy.marker, proxy.loggerFQCN, proxy.level, proxy.message, proxy.thrown, proxy.thrownProxy, proxy.contextMap, proxy.contextStack, proxy.threadName, proxy.source, proxy.timeMillis);
            result.setEndOfBatch(proxy.isEndOfBatch);
            result.setIncludeLocation(proxy.isLocationRequired);
            return result;
        }
        throw new IllegalArgumentException("Event is not a serialized LogEvent: " + event.toString());
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = this.loggerName.isEmpty() ? "root" : this.loggerName;
        sb.append("Logger=").append(n);
        sb.append(" Level=").append(this.level.name());
        sb.append(" Message=").append(this.message.getFormattedMessage());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log4jLogEvent that = (Log4jLogEvent)o;
        if (this.endOfBatch != that.endOfBatch) {
            return false;
        }
        if (this.includeLocation != that.includeLocation) {
            return false;
        }
        if (this.timeMillis != that.timeMillis) {
            return false;
        }
        if (this.loggerFqcn != null ? !this.loggerFqcn.equals(that.loggerFqcn) : that.loggerFqcn != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals(that.level) : that.level != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.marker != null ? !this.marker.equals(that.marker) : that.marker != null) {
            return false;
        }
        if (this.contextMap != null ? !this.contextMap.equals(that.contextMap) : that.contextMap != null) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        if (!this.loggerName.equals(that.loggerName)) {
            return false;
        }
        if (this.contextStack != null ? !this.contextStack.equals(that.contextStack) : that.contextStack != null) {
            return false;
        }
        if (this.threadName != null ? !this.threadName.equals(that.threadName) : that.threadName != null) {
            return false;
        }
        if (this.thrown != null ? !this.thrown.equals(that.thrown) : that.thrown != null) {
            return false;
        }
        return !(this.thrownProxy != null ? !this.thrownProxy.equals(that.thrownProxy) : that.thrownProxy != null);
    }

    public int hashCode() {
        int result = this.loggerFqcn != null ? this.loggerFqcn.hashCode() : 0;
        result = 31 * result + (this.marker != null ? this.marker.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + this.loggerName.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + (int)(this.timeMillis ^ this.timeMillis >>> 32);
        result = 31 * result + (this.thrown != null ? this.thrown.hashCode() : 0);
        result = 31 * result + (this.thrownProxy != null ? this.thrownProxy.hashCode() : 0);
        result = 31 * result + (this.contextMap != null ? this.contextMap.hashCode() : 0);
        result = 31 * result + (this.contextStack != null ? this.contextStack.hashCode() : 0);
        result = 31 * result + (this.threadName != null ? this.threadName.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.includeLocation ? 1 : 0);
        result = 31 * result + (this.endOfBatch ? 1 : 0);
        return result;
    }

    private static class LogEventProxy
    implements Serializable {
        private static final long serialVersionUID = -7139032940312647146L;
        private final String loggerFQCN;
        private final Marker marker;
        private final Level level;
        private final String loggerName;
        private final Message message;
        private final long timeMillis;
        private final transient Throwable thrown;
        private final ThrowableProxy thrownProxy;
        private final Map<String, String> contextMap;
        private final ThreadContext.ContextStack contextStack;
        private final String threadName;
        private final StackTraceElement source;
        private final boolean isLocationRequired;
        private final boolean isEndOfBatch;

        public LogEventProxy(Log4jLogEvent event, boolean includeLocation) {
            this.loggerFQCN = event.loggerFqcn;
            this.marker = event.marker;
            this.level = event.level;
            this.loggerName = event.loggerName;
            this.message = event.message;
            this.timeMillis = event.timeMillis;
            this.thrown = event.thrown;
            this.thrownProxy = event.thrownProxy;
            this.contextMap = event.contextMap;
            this.contextStack = event.contextStack;
            this.source = includeLocation ? event.getSource() : null;
            this.threadName = event.getThreadName();
            this.isLocationRequired = includeLocation;
            this.isEndOfBatch = event.endOfBatch;
        }

        protected Object readResolve() {
            Log4jLogEvent result = new Log4jLogEvent(this.loggerName, this.marker, this.loggerFQCN, this.level, this.message, this.thrown, this.thrownProxy, this.contextMap, this.contextStack, this.threadName, this.source, this.timeMillis);
            result.setEndOfBatch(this.isEndOfBatch);
            result.setIncludeLocation(this.isLocationRequired);
            return result;
        }
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LogEvent> {
        private String loggerFqcn;
        private Marker marker;
        private Level level;
        private String loggerName;
        private Message message;
        private Throwable thrown;

        public Builder setLoggerFqcn(String loggerFqcn) {
            this.loggerFqcn = loggerFqcn;
            return this;
        }

        public Builder setMarker(Marker marker) {
            this.marker = marker;
            return this;
        }

        public Builder setLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder setLoggerName(String loggerName) {
            this.loggerName = loggerName;
            return this;
        }

        public Builder setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Builder setThrown(Throwable thrown) {
            this.thrown = thrown;
            return this;
        }

        @Override
        public Log4jLogEvent build() {
            return new Log4jLogEvent(this.loggerName, this.marker, this.loggerFqcn, this.level, this.message, this.thrown);
        }
    }
}

