/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.status.StatusLogger;

public final class FileUtils {
    private static final String PROTOCOL_FILE = "file";
    private static final String JBOSS_FILE = "vfsfile";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Pattern WINDOWS_DIRECTORY_SEPARATOR = Pattern.compile("\\\\+");

    private FileUtils() {
    }

    public static File fileFromUri(URI uri) {
        if (uri == null || uri.getScheme() != null && !PROTOCOL_FILE.equals(uri.getScheme()) && !JBOSS_FILE.equals(uri.getScheme())) {
            return null;
        }
        if (uri.getScheme() == null) {
            File file = new File(uri.toString());
            if (file.exists()) {
                return file;
            }
            try {
                String path = uri.getPath();
                file = new File(path);
                if (file.exists()) {
                    return file;
                }
                uri = new File(path).toURI();
            }
            catch (Exception ex) {
                LOGGER.warn("Invalid URI {}", uri);
                return null;
            }
        }
        String charsetName = Constants.UTF_8.name();
        try {
            String fileName = uri.toURL().getFile();
            if (new File(fileName).exists()) {
                return new File(fileName);
            }
            fileName = URLDecoder.decode(fileName, charsetName);
            return new File(fileName);
        }
        catch (MalformedURLException ex) {
            LOGGER.warn("Invalid URL {}", uri, ex);
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.warn("Invalid encoding: {}", charsetName, uee);
        }
        return null;
    }

    public static boolean isFile(URL url) {
        return url != null && (url.getProtocol().equals(PROTOCOL_FILE) || url.getProtocol().equals(JBOSS_FILE));
    }

    public static void mkdir(File dir2, boolean createDirectoryIfNotExisting) throws IOException {
        if (!dir2.exists()) {
            if (!createDirectoryIfNotExisting) {
                throw new IOException("The directory " + dir2.getAbsolutePath() + " does not exist.");
            }
            if (!dir2.mkdirs()) {
                throw new IOException("Could not create directory " + dir2.getAbsolutePath());
            }
        }
        if (!dir2.isDirectory()) {
            throw new IOException("File " + dir2 + " exists and is not a directory. Unable to create directory.");
        }
    }

    public static URI getCorrectedFilePathUri(String uri) throws URISyntaxException {
        return new URI(WINDOWS_DIRECTORY_SEPARATOR.matcher(uri).replaceAll("/"));
    }
}

