/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.status.StatusLogger;

public final class Throwables {
    private static final Method ADD_SUPPRESSED;
    private static final Method GET_SUPPRESSED;

    @Deprecated
    public static void addSuppressed(Throwable throwable, Throwable suppressedThrowable) {
        if (ADD_SUPPRESSED != null) {
            try {
                ADD_SUPPRESSED.invoke((Object)throwable, suppressedThrowable);
            }
            catch (IllegalAccessException e) {
                StatusLogger.getLogger().error(e);
            }
            catch (IllegalArgumentException e) {
                StatusLogger.getLogger().error(e);
            }
            catch (InvocationTargetException e) {
                StatusLogger.getLogger().error(e);
            }
        }
    }

    @Deprecated
    public static Throwable[] getSuppressed(Throwable throwable) {
        if (GET_SUPPRESSED != null) {
            try {
                return (Throwable[])GET_SUPPRESSED.invoke((Object)throwable, new Object[0]);
            }
            catch (Exception e) {
                StatusLogger.getLogger().error(e);
                return null;
            }
        }
        return null;
    }

    public static boolean isGetSuppressedAvailable() {
        return GET_SUPPRESSED != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> toStringList(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            throwable.printStackTrace(pw);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        pw.flush();
        ArrayList<String> lines = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            if (ex instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            lines.add(ex.toString());
        }
        finally {
            Closer.closeSilently(reader);
        }
        return lines;
    }

    public static void rethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    private Throwables() {
    }

    static {
        Method[] methods;
        Method getSuppressed = null;
        Method addSuppressed = null;
        for (Method method : methods = Throwable.class.getMethods()) {
            if (method.getName().equals("getSuppressed")) {
                getSuppressed = method;
                continue;
            }
            if (!method.getName().equals("addSuppressed")) continue;
            addSuppressed = method;
        }
        GET_SUPPRESSED = getSuppressed;
        ADD_SUPPRESSED = addSuppressed;
    }
}

