/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bounce.plaf.BounceButtonUI;

public class QButton
extends JButton {
    public static final int FOCUS_NONE = 0;
    public static final int FOCUS_AROUND_TEXT = 1;
    public static final int FOCUS_AROUND_ICON = 2;
    public static final int FOCUS_AROUND_TEXT_AND_ICON = 3;
    private Color pressedBackground = null;
    private Color pressedForeground = null;
    private Border pressedBorder = null;
    private Font pressedFont = null;
    private Color selectedBackground = null;
    private Color selectedForeground = null;
    private Border selectedBorder = null;
    private Font selectedFont = null;
    private Color disabledBackground = null;
    private Color disabledForeground = null;
    private Border disabledBorder = null;
    private Font disabledFont = null;
    private Color disabledSelectedBackground = null;
    private Color disabledSelectedForeground = null;
    private Border disabledSelectedBorder = null;
    private Font disabledSelectedFont = null;
    private Color rolloverBackground = null;
    private Color rolloverForeground = null;
    private Border rolloverBorder = null;
    private Font rolloverFont = null;
    private Color rolloverSelectedBackground = null;
    private Color rolloverSelectedForeground = null;
    private Border rolloverSelectedBorder = null;
    private Font rolloverSelectedFont = null;
    private Color focusedBackground = null;
    private Color focusedForeground = null;
    private Border focusedBorder = null;
    private Font focusedFont = null;
    private Icon focusedIcon = null;
    private Color focusedSelectedBackground = null;
    private Color focusedSelectedForeground = null;
    private Border focusedSelectedBorder = null;
    private Font focusedSelectedFont = null;
    private Icon focusedSelectedIcon = null;
    private Color focusedRectangleColor = null;
    private int focusedRectangleMode = 3;
    private boolean doubleClickEnabled = false;
    private int maxLines = 1;
    private int minLines = 1;

    public QButton() {
        this.init();
    }

    public QButton(Action a) {
        super(a);
        this.init();
    }

    public QButton(Icon icon) {
        super(icon);
        this.init();
    }

    public QButton(String text) {
        super(text);
        this.init();
    }

    public QButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        this.focusedRectangleColor = UIManager.getColor("Button.focus");
        this.pressedBackground = UIManager.getColor("Button.select");
        this.disabledForeground = UIManager.getColor("Button.disabledText");
    }

    public void updateUI() {
        this.setUI(BounceButtonUI.createUI(this));
    }

    protected void paintBorder(Graphics g) {
        ButtonModel model = this.getModel();
        Border border = this.getBorder();
        Border tmpBorder = null;
        if (!model.isEnabled()) {
            tmpBorder = model.isSelected() ? this.getDisabledSelectedBorder() : this.getDisabledBorder();
        } else if (model.isPressed() && model.isArmed()) {
            tmpBorder = this.getPressedBorder();
        } else if (this.hasFocus()) {
            tmpBorder = model.isSelected() ? this.getFocusedSelectedBorder() : this.getFocusedBorder();
        } else if (this.isRolloverEnabled() && model.isRollover()) {
            tmpBorder = model.isSelected() ? this.getRolloverSelectedBorder() : this.getRolloverBorder();
        } else if (model.isSelected()) {
            tmpBorder = this.getSelectedBorder();
        }
        if (tmpBorder != null) {
            border = tmpBorder;
        }
        if (border != null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setPressedBackground(Color color) {
        this.pressedBackground = color;
    }

    public Color getPressedBackground() {
        return this.pressedBackground;
    }

    public void setPressedForeground(Color color) {
        this.pressedForeground = color;
    }

    public Color getPressedForeground() {
        return this.pressedForeground;
    }

    public void setPressedBorder(Border border) {
        this.pressedBorder = border;
    }

    public Border getPressedBorder() {
        return this.pressedBorder;
    }

    public void setPressedFont(Font font) {
        this.pressedFont = font;
    }

    public Font getPressedFont() {
        return this.pressedFont;
    }

    public void setSelectedBackground(Color color) {
        this.selectedBackground = color;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedForeground(Color color) {
        this.selectedForeground = color;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedBorder(Border border) {
        this.selectedBorder = border;
    }

    public Border getSelectedBorder() {
        return this.selectedBorder;
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledForeground(Color color) {
        this.disabledForeground = color;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledBorder(Border border) {
        this.disabledBorder = border;
    }

    public Border getDisabledBorder() {
        return this.disabledBorder;
    }

    public void setDisabledFont(Font font) {
        this.disabledFont = font;
    }

    public Font getDisabledFont() {
        return this.disabledFont;
    }

    public void setDisabledSelectedBackground(Color color) {
        this.disabledSelectedBackground = color;
    }

    public Color getDisabledSelectedBackground() {
        return this.disabledSelectedBackground;
    }

    public void setDisabledSelectedForeground(Color color) {
        this.disabledSelectedForeground = color;
    }

    public Color getDisabledSelectedForeground() {
        return this.disabledSelectedForeground;
    }

    public void setDisabledSelectedBorder(Border border) {
        this.disabledSelectedBorder = border;
    }

    public Border getDisabledSelectedBorder() {
        return this.disabledSelectedBorder;
    }

    public void setDisabledSelectedFont(Font font) {
        this.disabledSelectedFont = font;
    }

    public Font getDisabledSelectedFont() {
        return this.disabledSelectedFont;
    }

    public void setRolloverBackground(Color color) {
        this.rolloverBackground = color;
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public void setRolloverForeground(Color color) {
        this.rolloverForeground = color;
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public void setRolloverBorder(Border border) {
        this.rolloverBorder = border;
    }

    public Border getRolloverBorder() {
        return this.rolloverBorder;
    }

    public void setRolloverFont(Font font) {
        this.rolloverFont = font;
    }

    public Font getRolloverFont() {
        return this.rolloverFont;
    }

    public void setRolloverSelectedBackground(Color color) {
        this.rolloverSelectedBackground = color;
    }

    public Color getRolloverSelectedBackground() {
        return this.rolloverSelectedBackground;
    }

    public void setRolloverSelectedForeground(Color color) {
        this.rolloverSelectedForeground = color;
    }

    public Color getRolloverSelectedForeground() {
        return this.rolloverSelectedForeground;
    }

    public void setRolloverSelectedBorder(Border border) {
        this.rolloverSelectedBorder = border;
    }

    public Border getRolloverSelectedBorder() {
        return this.rolloverSelectedBorder;
    }

    public void setRolloverSelectedFont(Font font) {
        this.rolloverSelectedFont = font;
    }

    public Font getRolloverSelectedFont() {
        return this.rolloverSelectedFont;
    }

    public void setFocusedBackground(Color color) {
        this.focusedBackground = color;
    }

    public Color getFocusedBackground() {
        return this.focusedBackground;
    }

    public void setFocusedForeground(Color color) {
        this.focusedForeground = color;
    }

    public Color getFocusedForeground() {
        return this.focusedForeground;
    }

    public void setFocusedBorder(Border border) {
        this.focusedBorder = border;
    }

    public Border getFocusedBorder() {
        return this.focusedBorder;
    }

    public void setFocusedFont(Font font) {
        this.focusedFont = font;
    }

    public Font getFocusedFont() {
        return this.focusedFont;
    }

    public Icon getFocusedIcon() {
        return this.focusedIcon;
    }

    public void setFocusedIcon(Icon icon) {
        this.focusedIcon = icon;
    }

    public void setFocusedSelectedBackground(Color color) {
        this.focusedSelectedBackground = color;
    }

    public Color getFocusedSelectedBackground() {
        return this.focusedSelectedBackground;
    }

    public void setFocusedSelectedForeground(Color color) {
        this.focusedSelectedForeground = color;
    }

    public Color getFocusedSelectedForeground() {
        return this.focusedSelectedForeground;
    }

    public void setFocusedSelectedBorder(Border border) {
        this.focusedSelectedBorder = border;
    }

    public Border getFocusedSelectedBorder() {
        return this.focusedSelectedBorder;
    }

    public void setFocusedSelectedFont(Font font) {
        this.focusedSelectedFont = font;
    }

    public Font getFocusedSelectedFont() {
        return this.focusedSelectedFont;
    }

    public Icon getFocusedSelectedIcon() {
        return this.focusedSelectedIcon;
    }

    public void setFocusedSelectedIcon(Icon icon) {
        this.focusedSelectedIcon = icon;
    }

    public void setFocusedRectangleColor(Color color) {
        this.focusedRectangleColor = color;
    }

    public Color getFocusedRectangleColor() {
        return this.focusedRectangleColor;
    }

    public void setFocusedRectangleMode(int mode) {
        this.focusedRectangleMode = mode;
    }

    public int getFocusedRectangleMode() {
        return this.focusedRectangleMode;
    }

    public void setDoubleClick(boolean enable) {
        this.doubleClickEnabled = enable;
    }

    public boolean isDoubleClick() {
        return this.doubleClickEnabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMaximumLines(int lines) {
        if (lines <= 0) {
            this.maxLines = 1;
            return;
        }
        if (lines >= this.minLines) {
            this.maxLines = lines;
            return;
        }
        this.maxLines = this.minLines;
        throw new IllegalArgumentException("Maximum number of lines < Minimum : " + lines + " < " + this.minLines);
    }

    public int getMaximumLines() {
        return this.maxLines;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMinimumLines(int lines) {
        if (lines <= 0) {
            this.minLines = 1;
            return;
        }
        if (lines <= this.maxLines) {
            this.minLines = lines;
            return;
        }
        this.minLines = this.maxLines;
        throw new IllegalArgumentException("Minimum number of lines > Maximum : " + lines + " > " + this.maxLines);
    }

    public int getMinimumLines() {
        return this.minLines;
    }

    public void setLines(int lines) {
        if (lines > 0) {
            this.minLines = lines;
            this.maxLines = lines;
        } else {
            this.minLines = 1;
            this.maxLines = 1;
        }
    }

    static {
        FOCUS_NONE = 0;
        FOCUS_AROUND_TEXT = 1;
        FOCUS_AROUND_ICON = 2;
        FOCUS_AROUND_TEXT_AND_ICON = 3;
    }
}

