CREATE TABLE sim_data_files(
    file_id_c SERIAL PRIMARY KEY,
    path_c character varying(300),
    prop_c text,
    file_time_c bigint NOT NULL
);

CREATE TABLE sim_data(
    file_id_c integer NOT NULL,
    id_c integer NOT NULL,
    oid_c character varying(500) NOT NULL,
    object_c    text 
);


ALTER TABLE sim_data ADD CONSTRAINT sim_data_pkey PRIMARY KEY (id_c, file_id_c);
ALTER TABLE sim_data ADD CONSTRAINT fm_varbind_probe_id_c_fkey1 FOREIGN KEY ( file_id_c ) REFERENCES sim_data_files(file_id_c) ON UPDATE NO ACTION ON DELETE CASCADE;
CREATE INDEX ix_oid ON sim_data (oid_c);
CREATE INDEX ix_path ON sim_data_files (path_c);

CREATE TABLE properties_t (
    name_c character varying(300) NOT NULL,
    value_c text
);
ALTER TABLE properties_t ADD CONSTRAINT properties_t_pkey PRIMARY KEY (name_c);




