Option Explicit
Const strComputer = "."

Dim objWMIService, colNetAdapters, strIPAddress, strSubnetMask
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")
Set colNetAdapters = objWMIService.ExecQuery ("Select * from Win32_NetworkAdapterConfiguration where IPEnabled=TRUE")

Dim vReturnArr : vReturnArr = Array( _ 
	"Successful completion, no reboot required.", _
	"Successful completion, reboot required.", _
	"Method not supported on this platform.", _
	"Unknown failure.", _
	"Invalid subnet mask.", _
	"An error occurred while processing an instance that was returned.", _
	"Invalid input parameter.", _
	"More than five gateways specified.", _
	"Invalid IP address.", _
	"Invalid gateway IP address.", _
	"An error occurred while accessing the registry for the requested information.", _
	"Invalid domain name.", _
	"Invalid host name.", _
	"No primary or secondary WINS server defined.", _
	"Invalid file.", _
	"Invalid system path.", _
	"File copy failed.", _
	"Invalid security parameter.", _
	"Unable to configure TCP/IP service.", _
	"Unable to configure DHCP service.", _
	"Unable to renew DHCP lease.", _
	"Unable to release DHCP lease.", _
	"IP not enabled on adapter.", _
	"IPX not enabled on adapter.", _
	"Frame or network number bounds error.", _
	"Invalid frame type.", _
	"Invalid network number.", _
	"Duplicate network number.", _
	"Parameter out of bounds.", _
	"Access denied.", _
	"Out of memory.", _
	"Already exists.", _
	"Path, file, or object not found.", _
	"Unable to notify service.", _
	"Unable to notify DNS service.", _
	"Interface not configurable.", _
	"Not all DHCP leases could be released or renewed.", _
	"DHCP not enabled on adapter." _
	)

Dim i : i = 0
Dim colAdapter, vProp
Dim arguCount : arguCount = WScript.Arguments.Count

If arguCount < 1 Then
	WScript.Echo GetIPArr
ElseIf arguCount = 5 Then
	Dim ipArr,maskArr,settingID, gateway, dnsArr
	ipArr = Split(WScript.Arguments(0),"!")
	maskArr = Split(WScript.Arguments(1),"!")
	settingID = WScript.Arguments(2)
    gateway = WScript.Arguments(3)
	dnsArr = Split(WScript.Arguments(4),"!")
	Dim vReturn : vReturn = SetIPArr(ipArr,maskArr,settingID, gateway, dnsArr)
	Select Case vReturn
		Case 0,1
			WScript.Echo vReturnArr(vReturn)
		Case 64,65,66,67,67,69,70,71,72,73,74,75,76,77,78,79,60,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100
			WScript.Echo vReturnArr(vReturn-62)
        Case -2147180508
            WScript.Echo "No write access. Please close Windows TCP/IP configuration window first."
        Case -2147217405
            WScript.Echo "Access denied. If you are on Vista/Win7, you have to run simulator as Administrator."
		Case Else
			WScript.Echo "Unknown Error"
	End Select
Else
	WScript.Echo "Wrong Arguments Count"
	WScript.Quit(-1)
End If

Function GetIPArr()
	Dim ipArr : ipArr = ""
	Dim settingID : settingID = ""
    Dim gateway : gateway = ""
    Dim dns : dns = ""
	For Each colAdapter In colNetAdapters
		For Each vProp In colAdapter.Properties_
			On Error Resume Next
            'WScript.Echo "prop.name:"& vProp.Name & "; value:" & vProp.Value
            If vProp.Name="DefaultIPGateway" Then
                gateway = "" & colAdapter.DefaultIPGateway(0)
            End If
            If vProp.Name="DNSServerSearchOrder" Then
                dns = Join(colAdapter.DNSServerSearchOrder, "!")
            End If
			If vProp.Name="IPAddress" Or vProp.Name="IPSubnet" Then
                    Dim vLen : vLen = UBound(vProp.Value)
                    For i=0 To vLen
                        If InStr(vProp.Value(i),".") <> 0 Then ' If this is an IPv4 (#.#.#.#) address, not IPv6 (xx:xx:xx:xx...)
                            If i<>0  Then 
                                ipArr = ipArr & "!" & vProp.Value(i)
                            Else
                                ipArr = ipArr & vProp.Value(i)
                            End if
                        End If
                    Next
                    ipArr = ipArr & vbCrlf
			End If
			If vProp.Name="SettingID" Then
				settingID = vProp.Value
			End If
		Next
		ipArr = ipArr & settingID & vbCrlf & gateway & vbCrlf & dns & vbCrlf & "@" & vbCrlf
	Next
	GetIPArr = ipArr
End Function

Function SetIPArr(ByRef ipArr, ByRef maskArr, ByVal settingID, ByRef gateway, ByRef dns)
	Dim vReturn : vReturn = -1
    Dim arrGateway
    arrGateway = Array(gateway)
	For Each colAdapter In colNetAdapters
		For Each vProp In colAdapter.Properties_
			If vProp.Name = "SettingID" Then
				If vProp.Value = settingID Then
					vReturn = colAdapter.EnableStatic(ipArr, maskArr)
                    colAdapter.SetGateways(arrGateway)
                    colAdapter.SetDNSServerSearchOrder(dns)
				End If
			End If
		Next
	Next
	SetIPArr = vReturn
End Function

IF Err.Number <> vbEmpty Then
	WScript.Echo "Error Number:" & Err.Number & " Error Description: " & Err.Description
	WScript.Quit(Err.Number)
End If
