/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeTable;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TreeTableView
extends BeanTreeView {
    protected JTable treeTable;
    private NodeTableModel tableModel;
    private JScrollBar hScrollBar;
    private JScrollPane scrollPane;
    private ScrollListener listener;
    private boolean allowHideColumns = false;
    private boolean allowSortingByColumn = false;
    private boolean hideHScrollBar = false;
    private JButton colsButton = null;
    private SortedNodeTreeModel sortedNodeTreeModel;
    private ActionListener defaultTreeActionListener;
    private TableCellRenderer defaultHeaderRenderer = null;
    private MouseUtils.PopupMouseAdapter tableMouseListener;
    private AccessibleContext accessContext;
    private static final String COLUMNS_ICON = "/org/openide/resources/columns.gif";
    private static final String SORT_ASC_ICON = "org/openide/resources/columnsSortedAsc.gif";
    private static final String SORT_DESC_ICON = "org/openide/resources/columnsSortedDesc.gif";
    private TreeColumnProperty treeColumnProperty = new TreeColumnProperty();
    private int treeColumnWidth;
    private Component treeTableParent = null;

    public TreeTableView() {
        this(new NodeTableModel());
    }

    public TreeTableView(NodeTableModel ntm) {
        this.tableModel = ntm;
        this.initializeTreeTable();
        this.setPopupAllowed(true);
        this.setDefaultActionAllowed(true);
        this.initializeTreeScrollSupport();
        CompoundScrollPane p = new CompoundScrollPane();
        p.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.treeTable);
        p.add("Center", this.scrollPane);
        ImageIcon ic = new ImageIcon(TreeTable.class.getResource(COLUMNS_ICON));
        this.colsButton = new JButton(ic);
        this.colsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeTableView.this.selectVisibleColumns();
            }
        });
        JPanel sbp = new JPanel();
        sbp.setLayout(new FlowLayout(0, 0, 0));
        sbp.add(this.hScrollBar);
        p.add("South", sbp);
        super.setHorizontalScrollBarPolicy(31);
        super.setVerticalScrollBarPolicy(21);
        this.setViewportView(p);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
    }

    public void setRowHeader(JViewport rowHeader) {
        rowHeader.setBorder(BorderFactory.createEmptyBorder());
        super.setRowHeader(rowHeader);
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        boolean bl = this.hideHScrollBar = policy == 31;
        if (this.hideHScrollBar) {
            this.hScrollBar.setVisible(false);
            ((TreeTable)this.treeTable).setTreeHScrollingEnabled(false);
        }
    }

    public void setVerticalScrollBarPolicy(int policy) {
        if (this.scrollPane == null) {
            return;
        }
        boolean bl = this.allowHideColumns = policy == 22;
        if (this.allowHideColumns) {
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.colsButton);
        }
        this.treeTable.getTableHeader().setReorderingAllowed(this.allowHideColumns);
        this.scrollPane.setVerticalScrollBarPolicy(policy);
    }

    protected NodeTreeModel createModel() {
        return this.getSortedNodeTreeModel();
    }

    public void requestFocus() {
        if (this.treeTable != null) {
            this.treeTable.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        boolean res = super.requestFocusInWindow();
        if (null != this.treeTable) {
            this.treeTable.requestFocus();
        }
        return res;
    }

    private void setAllowSortingByColumn(boolean allow) {
        if (allow && allow != this.allowSortingByColumn) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    JTableHeader h;
                    int index;
                    Component c = evt.getComponent();
                    if (c instanceof JTableHeader && (index = (h = (JTableHeader)c).columnAtPoint(evt.getPoint())) >= 0) {
                        TreeTableView.this.clickOnColumnAction(index - 1);
                    }
                }
            });
        }
        this.allowSortingByColumn = allow;
    }

    private void clickOnColumnAction(int index) {
        if (index == -1) {
            if (this.treeColumnProperty.isComparable()) {
                if (this.treeColumnProperty.isSortingColumn()) {
                    if (!this.treeColumnProperty.isSortOrderDescending()) {
                        this.setSortingOrder(false);
                    } else {
                        this.noSorting();
                    }
                } else {
                    int realIndex = this.tableModel.translateVisibleColumnIndex(index);
                    this.setSortingColumn(index);
                    this.setSortingOrder(true);
                }
            }
        } else if (this.tableModel.isComparableColumn(index)) {
            if (this.tableModel.isSortingColumnEx(this.tableModel.translateVisibleColumnIndex(index))) {
                if (!this.tableModel.isSortOrderDescending()) {
                    this.setSortingOrder(false);
                } else {
                    this.noSorting();
                }
            } else {
                int realIndex = this.tableModel.translateVisibleColumnIndex(index);
                this.setSortingColumn(realIndex);
                this.setSortingOrder(true);
            }
        }
    }

    private void selectVisibleColumns() {
        this.setCurrentWidths();
        String viewName = null;
        if (this.getParent() != null) {
            viewName = this.getParent().getName();
        }
        if (this.tableModel.selectVisibleColumns(viewName, this.treeTable.getColumnName(0), this.getSortedNodeTreeModel().getRootDescription())) {
            if (this.tableModel.getSortingColumn() == -1) {
                this.getSortedNodeTreeModel().setSortedByProperty(null);
            }
            this.setTreePreferredWidth(this.treeColumnWidth);
            for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
                this.setTableColumnPreferredWidth(this.tableModel.getArrayIndex(i), this.tableModel.getVisibleColumnWidth(i));
            }
        }
    }

    private void setCurrentWidths() {
        this.treeColumnWidth = this.treeTable.getColumnModel().getColumn(0).getWidth();
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            int w = this.treeTable.getColumnModel().getColumn(i + 1).getWidth();
            this.tableModel.setVisibleColumnWidth(i, w);
        }
    }

    void initializeTree() {
    }

    private void initializeTreeTable() {
        this.treeModel = this.createModel();
        this.treeTable = new TreeTable(this.treeModel, this.tableModel);
        this.tree = ((TreeTable)this.treeTable).getTree();
        this.defaultHeaderRenderer = this.treeTable.getTableHeader().getDefaultRenderer();
        this.treeTable.getTableHeader().setDefaultRenderer(new SortingHeaderRenderer());
        this.managerListener = new TreeView.TreePropertyListener(this);
        this.tree.addTreeExpansionListener(this.managerListener);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                if (path != null) {
                    Enumeration<TreePath> en = TreeTableView.this.tree.getExpandedDescendants(path);
                    TreeTableView.this.getSortedNodeTreeModel().sortChildren((VisualizerNode)path.getLastPathComponent(), true);
                    while (en.hasMoreElements()) {
                        TreeTableView.this.tree.expandPath(en.nextElement());
                    }
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.defaultActionListener = new TreeView.PopupSupport(this);
        this.treeTable.getActionMap().put("org.openide.actions.PopupAction", this.defaultActionListener.popup);
        this.tree.addMouseListener(this.defaultActionListener);
        this.tableMouseListener = new MouseUtils.PopupMouseAdapter(){

            public void showPopup(MouseEvent mevt) {
                if (TreeTableView.this.isPopupAllowed()) {
                    if (mevt.getY() > TreeTableView.this.treeTable.getHeight()) {
                        TreeTableView.this.treeTable.clearSelection();
                    }
                    TreeTableView.this.createPopup(mevt);
                }
            }
        };
        this.treeTable.addMouseListener(this.tableMouseListener);
        if (UIManager.getColor("control") != null) {
            this.treeTable.setGridColor(UIManager.getColor("control"));
        }
    }

    public void setSelectionMode(int mode) {
        super.setSelectionMode(mode);
        if (mode == 1) {
            this.treeTable.getSelectionModel().setSelectionMode(0);
        } else if (mode == 2) {
            this.treeTable.getSelectionModel().setSelectionMode(1);
        } else if (mode == 4) {
            this.treeTable.getSelectionModel().setSelectionMode(2);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessContext == null) {
            this.accessContext = new AccessibleTreeTableView();
        }
        return this.accessContext;
    }

    private void initializeTreeScrollSupport() {
        this.scrollPane = new JScrollPane();
        this.scrollPane.setName("TreeTableView.scrollpane");
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        if (UIManager.getColor("Table.background") != null) {
            this.scrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        }
        this.hScrollBar = new JScrollBar(0);
        this.hScrollBar.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.hScrollBar.setVisible(false);
        this.listener = new ScrollListener();
        this.treeTable.addPropertyChangeListener(this.listener);
        this.scrollPane.getViewport().addComponentListener(this.listener);
        this.tree.addPropertyChangeListener(this.listener);
        this.hScrollBar.getModel().addChangeListener(this.listener);
    }

    public void setPopupAllowed(boolean value) {
        if (this.tree == null) {
            return;
        }
        if (this.popupListener == null && value) {
            this.popupListener = new TreeView.PopupAdapter(){

                protected void showPopup(MouseEvent e) {
                    int selRow = TreeTableView.this.tree.getRowForLocation(e.getX(), e.getY());
                    if (!TreeTableView.this.tree.isRowSelected(selRow)) {
                        TreeTableView.this.tree.setSelectionRow(selRow);
                    }
                }
            };
            this.tree.addMouseListener(this.popupListener);
            return;
        }
        if (this.popupListener != null && !value) {
            this.tree.removeMouseListener(this.popupListener);
            this.popupListener = null;
            return;
        }
    }

    public void setDefaultActionAllowed(boolean value) {
        if (this.tree == null) {
            return;
        }
        this.defaultActionEnabled = value;
        if (value) {
            this.defaultTreeActionListener = new DefaultTreeAction();
            this.treeTable.registerKeyboardAction(this.defaultTreeActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.defaultTreeActionListener = null;
            this.treeTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public void setProperties(Node.Property[] props) {
        this.tableModel.setProperties(props);
        this.treeColumnProperty.setProperty(this.tableModel.propertyForColumn(-1));
        if (this.treeColumnProperty.isComparable() || this.tableModel.existsComparableColumn()) {
            this.setAllowSortingByColumn(true);
            if (this.treeColumnProperty.isSortingColumn()) {
                this.getSortedNodeTreeModel().setSortedByName(true, !this.treeColumnProperty.isSortOrderDescending());
            } else {
                int index = this.tableModel.getSortingColumn();
                if (index != -1) {
                    this.getSortedNodeTreeModel().setSortedByProperty(this.tableModel.propertyForColumnEx(index), !this.tableModel.isSortOrderDescending());
                }
            }
        }
    }

    public final void setTableAutoResizeMode(int mode) {
        this.treeTable.setAutoResizeMode(mode);
    }

    public final int getTableAutoResizeMode() {
        return this.treeTable.getAutoResizeMode();
    }

    public final void setTableColumnPreferredWidth(int index, int width) {
        if (index == -1) {
            return;
        }
        this.tableModel.setArrayColumnWidth(index, width);
        int j = this.tableModel.getVisibleIndex(index);
        if (j != -1) {
            this.treeTable.getColumnModel().getColumn(j + 1).setPreferredWidth(width);
        }
    }

    public final int getTableColumnPreferredWidth(int index) {
        int j = this.tableModel.getVisibleIndex(index);
        if (j != -1) {
            return this.treeTable.getColumnModel().getColumn(j + 1).getPreferredWidth();
        }
        return this.tableModel.getArrayColumnWidth(index);
    }

    public final void setTreePreferredWidth(int width) {
        this.treeTable.getColumnModel().getColumn(((TreeTable)this.treeTable).getTreeColumnIndex()).setPreferredWidth(width);
    }

    public final int getTreePreferredWidth() {
        return this.treeTable.getColumnModel().getColumn(((TreeTable)this.treeTable).getTreeColumnIndex()).getPreferredWidth();
    }

    public void addNotify() {
        if (this.treeTable.getParent() != null) {
            this.treeTableParent = this.treeTable.getParent();
            this.treeTableParent.addMouseListener(this.tableMouseListener);
        }
        super.addNotify();
        this.listener.revalidateScrollBar();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.treeTableParent != null) {
            this.treeTableParent.removeMouseListener(this.tableMouseListener);
        }
        this.treeTableParent = null;
        this.tableModel.setNodes(new Node[0]);
    }

    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.treeTable.getTableHeader().addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.treeTable.getTableHeader().removeMouseListener(l);
    }

    public void setDragSource(boolean state) {
    }

    public void setDropTarget(boolean state) {
    }

    Point getPositionForPopup() {
        int row = this.treeTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        int col = this.treeTable.getSelectedColumn();
        if (col < 0) {
            col = 0;
        }
        Rectangle r = null;
        r = col == 0 ? this.tree.getRowBounds(row) : this.treeTable.getCellRect(row, col, true);
        Point p = SwingUtilities.convertPoint(this.treeTable, r.x, r.y, this);
        return p;
    }

    private void createPopup(MouseEvent e) {
        Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), this);
        this.createPopup(p.x, p.y);
        e.consume();
    }

    void createPopup(int xpos, int ypos) {
        int treeXpos = xpos - ((TreeTable)this.treeTable).getPositionX();
        if (this.allowHideColumns || this.allowSortingByColumn) {
            int col = this.treeTable.getColumnModel().getColumnIndexAtX(treeXpos);
            super.createExtendedPopup(xpos, ypos, this.getListMenu(col));
        } else {
            super.createPopup(xpos, ypos);
        }
    }

    private JMenu getListMenu(final int col) {
        JMenu listItem = new JMenu(NbBundle.getBundle(NodeTableModel.class).getString("LBL_ListOptions"));
        if (this.allowHideColumns && col > 0) {
            JMenu colsItem = new JMenu(NbBundle.getBundle(NodeTableModel.class).getString("LBL_ColsMenu"));
            boolean addColsItem = false;
            if (col > 1) {
                JMenuItem moveLItem = new JMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_MoveLeft"));
                moveLItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(col, col - 1);
                    }
                });
                colsItem.add(moveLItem);
                addColsItem = true;
            }
            if (col < this.tableModel.getColumnCount()) {
                JMenuItem moveRItem = new JMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_MoveRight"));
                moveRItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(col, col + 1);
                    }
                });
                colsItem.add(moveRItem);
                addColsItem = true;
            }
            if (addColsItem) {
                listItem.add(colsItem);
            }
        }
        if (this.allowSortingByColumn) {
            int index;
            int i;
            JRadioButtonMenuItem colItem;
            JMenu sortItem = new JMenu(NbBundle.getBundle(NodeTableModel.class).getString("LBL_SortMenu"));
            JRadioButtonMenuItem noSortItem = new JRadioButtonMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_NoSort"), !this.getSortedNodeTreeModel().isSortingActive());
            noSortItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableView.this.noSorting();
                }
            });
            sortItem.add(noSortItem);
            int visibleComparable = 0;
            if (this.treeColumnProperty.isComparable()) {
                ++visibleComparable;
                colItem = new JRadioButtonMenuItem(this.treeTable.getColumnName(0), this.treeColumnProperty.isSortingColumn());
                colItem.setHorizontalTextPosition(2);
                colItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingColumn(-1);
                    }
                });
                sortItem.add(colItem);
            }
            for (i = 0; i < this.tableModel.getColumnCount(); ++i) {
                if (!this.tableModel.isComparableColumn(i)) continue;
                ++visibleComparable;
                colItem = new JRadioButtonMenuItem(this.tableModel.getColumnName(i), this.tableModel.isSortingColumnEx(this.tableModel.translateVisibleColumnIndex(i)));
                colItem.setHorizontalTextPosition(2);
                index = this.tableModel.translateVisibleColumnIndex(i);
                colItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingColumn(index);
                    }
                });
                sortItem.add(colItem);
            }
            for (i = 0; i < this.tableModel.getColumnCountEx(); ++i) {
                if (!this.tableModel.isComparableColumnEx(i) || this.tableModel.isVisibleColumnEx(i)) continue;
                ++visibleComparable;
                colItem = new JRadioButtonMenuItem(this.tableModel.getColumnNameEx(i), this.tableModel.isSortingColumnEx(i));
                colItem.setHorizontalTextPosition(2);
                index = i;
                colItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingColumn(index);
                    }
                });
                sortItem.add(colItem);
            }
            if (visibleComparable > 0) {
                sortItem.addSeparator();
                boolean current_sort = this.treeColumnProperty.isSortingColumn() ? this.treeColumnProperty.isSortOrderDescending() : this.tableModel.isSortOrderDescending();
                JRadioButtonMenuItem ascItem = new JRadioButtonMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_Ascending"), !current_sort);
                ascItem.setHorizontalTextPosition(2);
                ascItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingOrder(true);
                    }
                });
                sortItem.add(ascItem);
                JRadioButtonMenuItem descItem = new JRadioButtonMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_Descending"), current_sort);
                descItem.setHorizontalTextPosition(2);
                descItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableView.this.setSortingOrder(false);
                    }
                });
                sortItem.add(descItem);
                if (!this.getSortedNodeTreeModel().isSortingActive()) {
                    ascItem.setEnabled(false);
                    descItem.setEnabled(false);
                }
                listItem.add(sortItem);
            }
        }
        if (this.allowHideColumns) {
            JMenuItem visItem = new JMenuItem(NbBundle.getBundle(NodeTableModel.class).getString("LBL_ChangeColumns"));
            visItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTableView.this.selectVisibleColumns();
                }
            });
            listItem.add(visItem);
        }
        return listItem;
    }

    private void setSortingColumn(int index) {
        this.tableModel.setSortingColumnEx(index);
        if (index != -1) {
            this.getSortedNodeTreeModel().setSortedByProperty(this.tableModel.propertyForColumnEx(index), !this.tableModel.isSortOrderDescending());
            this.treeColumnProperty.setSortingColumn(false);
        } else {
            this.getSortedNodeTreeModel().setSortedByName(true, !this.treeColumnProperty.isSortOrderDescending());
            this.treeColumnProperty.setSortingColumn(true);
        }
        this.treeTable.getTableHeader().repaint();
    }

    private void noSorting() {
        this.tableModel.setSortingColumnEx(-1);
        this.getSortedNodeTreeModel().setNoSorting();
        this.treeColumnProperty.setSortingColumn(false);
        this.treeTable.getTableHeader().repaint();
    }

    private void setSortingOrder(boolean ascending) {
        if (this.treeColumnProperty.isSortingColumn()) {
            this.treeColumnProperty.setSortOrderDescending(!ascending);
        } else {
            this.tableModel.setSortOrderDescending(!ascending);
        }
        this.getSortedNodeTreeModel().setSortOrder(ascending);
        this.treeTable.getTableHeader().repaint();
    }

    private synchronized SortedNodeTreeModel getSortedNodeTreeModel() {
        if (this.sortedNodeTreeModel == null) {
            this.sortedNodeTreeModel = new SortedNodeTreeModel();
        }
        return this.sortedNodeTreeModel;
    }

    private static class TreeColumnProperty {
        private Node.Property p = null;

        TreeColumnProperty() {
        }

        void setProperty(Node.Property p) {
            this.p = p;
        }

        boolean isComparable() {
            if (this.p == null) {
                return false;
            }
            Object o = this.p.getValue("ComparableColumnTTV");
            if (o != null && o instanceof Boolean) {
                return (Boolean)o;
            }
            return false;
        }

        boolean isSortingColumn() {
            if (this.p == null) {
                return false;
            }
            Object o = this.p.getValue("SortingColumnTTV");
            if (o != null && o instanceof Boolean) {
                return (Boolean)o;
            }
            return false;
        }

        void setSortingColumn(boolean sorting) {
            if (this.p == null) {
                return;
            }
            this.p.setValue("SortingColumnTTV", sorting ? Boolean.TRUE : Boolean.FALSE);
        }

        boolean isSortOrderDescending() {
            if (this.p == null) {
                return false;
            }
            Object o = this.p.getValue("DescendingOrderTTV");
            if (o != null && o instanceof Boolean) {
                return (Boolean)o;
            }
            return false;
        }

        void setSortOrderDescending(boolean descending) {
            if (this.p == null) {
                return;
            }
            this.p.setValue("DescendingOrderTTV", descending ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private class SortingHeaderRenderer
    extends DefaultTableCellRenderer {
        SortingHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = TreeTableView.this.defaultHeaderRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                if (column == 0 && TreeTableView.this.treeColumnProperty.isSortingColumn()) {
                    ((JLabel)comp).setIcon(this.getProperIcon(TreeTableView.this.treeColumnProperty.isSortOrderDescending()));
                    ((JLabel)comp).setHorizontalTextPosition(2);
                    comp.setFont(new Font(comp.getFont().getName(), 1, comp.getFont().getSize()));
                } else if (column != 0 && TreeTableView.this.tableModel.getVisibleSortingColumn() + 1 == column) {
                    ((JLabel)comp).setIcon(this.getProperIcon(TreeTableView.this.tableModel.isSortOrderDescending()));
                    ((JLabel)comp).setHorizontalTextPosition(2);
                    comp.setFont(new Font(comp.getFont().getName(), 1, comp.getFont().getSize()));
                } else {
                    ((JLabel)comp).setIcon(null);
                }
            }
            return comp;
        }

        private ImageIcon getProperIcon(boolean descending) {
            if (descending) {
                return new ImageIcon(Utilities.loadImage(TreeTableView.SORT_DESC_ICON));
            }
            return new ImageIcon(Utilities.loadImage(TreeTableView.SORT_ASC_ICON));
        }
    }

    private class SortedNodeTreeModel
    extends NodeTreeModel {
        private Node.Property sortedByProperty;
        private boolean sortAscending = true;
        private Comparator rowComparator;
        private boolean sortedByName = false;
        private SortingTask sortingTask = null;

        SortedNodeTreeModel() {
        }

        void setNoSorting() {
            this.setSortedByProperty(null);
            this.setSortedByName(false);
            this.sortingChanged();
        }

        boolean isSortingActive() {
            return this.sortedByProperty != null || this.sortedByName;
        }

        void setSortedByProperty(Node.Property prop) {
            if (this.sortedByProperty == prop) {
                return;
            }
            this.sortedByProperty = prop;
            if (prop == null) {
                this.rowComparator = null;
            } else {
                this.sortedByName = false;
            }
            this.sortingChanged();
        }

        void setSortedByProperty(Node.Property prop, boolean ascending) {
            if (this.sortedByProperty == prop && ascending == this.sortAscending) {
                return;
            }
            this.sortedByProperty = prop;
            this.sortAscending = ascending;
            if (prop == null) {
                this.rowComparator = null;
            } else {
                this.sortedByName = false;
            }
            this.sortingChanged();
        }

        void setSortedByName(boolean sorted, boolean ascending) {
            if (this.sortedByName == sorted && ascending == this.sortAscending) {
                return;
            }
            this.sortedByName = sorted;
            this.sortAscending = ascending;
            if (this.sortedByName) {
                this.sortedByProperty = null;
            }
            this.sortingChanged();
        }

        void setSortedByName(boolean sorted) {
            this.sortedByName = sorted;
            if (this.sortedByName) {
                this.sortedByProperty = null;
            }
            this.sortingChanged();
        }

        void setSortOrder(boolean ascending) {
            if (ascending == this.sortAscending) {
                return;
            }
            this.sortAscending = ascending;
            this.sortingChanged();
        }

        private Node.Property getNodeProperty(Node node, Node.Property prop) {
            Node.PropertySet[] propsets = node.getPropertySets();
            int n = propsets.length;
            for (int i = 0; i < n; ++i) {
                Node.Property[] props = propsets[i].getProperties();
                int m = props.length;
                for (int j = 0; j < m; ++j) {
                    if (!props[j].equals(prop)) continue;
                    return props[j];
                }
            }
            return null;
        }

        synchronized Comparator getRowComparator() {
            if (this.rowComparator == null) {
                this.rowComparator = new Comparator(this){
                    private final /* synthetic */ SortedNodeTreeModel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int compare(Object o1, Object o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        Node n1 = ((VisualizerNode)o1).node;
                        Node n2 = ((VisualizerNode)o2).node;
                        if (n1 == null && n2 == null) {
                            return 0;
                        }
                        if (n1 == null) {
                            return 1;
                        }
                        if (n2 == null) {
                            return -1;
                        }
                        if (n1.getParentNode() == null || n2.getParentNode() == null) {
                            ErrorManager.getDefault().log("Warning: TTV.compare: Node " + n1 + " or " + n2 + " has no parent!");
                            return 0;
                        }
                        if (!n1.getParentNode().equals(n2.getParentNode())) {
                            ErrorManager.getDefault().log("Warning: TTV.compare: Nodes " + n1 + " and " + n2 + " has different parent!");
                            return 0;
                        }
                        int res = 0;
                        if (SortedNodeTreeModel.access$1300(this.this$1)) {
                            res = n1.getDisplayName().compareTo(n2.getDisplayName());
                            return SortedNodeTreeModel.access$1400(this.this$1) ? res : -res;
                        }
                        Node.Property p1 = SortedNodeTreeModel.access$1600(this.this$1, n1, SortedNodeTreeModel.access$1500(this.this$1));
                        Node.Property p2 = SortedNodeTreeModel.access$1600(this.this$1, n2, SortedNodeTreeModel.access$1500(this.this$1));
                        if (p1 == null && p2 == null) {
                            return 0;
                        }
                        try {
                            if (p1 == null) {
                                res = -1;
                            } else if (p2 == null) {
                                res = 1;
                            } else {
                                Object v1 = p1.getValue();
                                Object v2 = p2.getValue();
                                if (v1 == null && v2 == null) {
                                    return 0;
                                }
                                if (v1 == null) {
                                    res = -1;
                                } else if (v2 == null) {
                                    res = 1;
                                } else {
                                    if (v1.getClass() != v2.getClass() || !(v1 instanceof Comparable)) {
                                        v1 = v1.toString();
                                        v2 = v2.toString();
                                    }
                                    res = ((Comparable)v1).compareTo(v2);
                                }
                            }
                            return SortedNodeTreeModel.access$1400(this.this$1) ? res : -res;
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, ex);
                            return 0;
                        }
                    }
                };
            }
            return this.rowComparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sortChildren(VisualizerNode parent, boolean synchronous) {
            if (synchronous) {
                SortedNodeTreeModel sortedNodeTreeModel = this;
                synchronized (sortedNodeTreeModel) {
                    if (this.sortingTask != null) {
                        this.sortingTask.remove(parent);
                        if (this.sortingTask.isEmpty()) {
                            this.sortingTask = null;
                        }
                    }
                }
                this.doSortChildren(parent);
            } else {
                SortedNodeTreeModel sortedNodeTreeModel = this;
                synchronized (sortedNodeTreeModel) {
                    if (this.sortingTask == null) {
                        this.sortingTask = new SortingTask();
                        SwingUtilities.invokeLater(this.sortingTask);
                    }
                }
                this.sortingTask.add(parent);
            }
        }

        void doSortChildren(VisualizerNode parent) {
            if (this.isSortingActive()) {
                Comparator comparator = this.getRowComparator();
                if (comparator != null || parent != null) {
                    parent.reorderChildren(comparator);
                }
            } else {
                parent.naturalOrder();
            }
        }

        void sortingChanged() {
            TreeNode tn = (TreeNode)this.getRoot();
            ArrayList<TreePath> list = new ArrayList<TreePath>();
            Enumeration<TreePath> en = TreeTableView.this.tree.getExpandedDescendants(new TreePath(tn));
            while (en != null && en.hasMoreElements()) {
                TreePath path = en.nextElement();
                this.sortChildren((VisualizerNode)path.getLastPathComponent(), true);
                list.add(path);
            }
            for (int i = 0; i < list.size(); ++i) {
                TreeTableView.this.tree.expandPath((TreePath)list.get(i));
            }
        }

        String getRootDescription() {
            if (this.getRoot() instanceof VisualizerNode) {
                return ((VisualizerNode)this.getRoot()).getShortDescription();
            }
            return "";
        }

        public void nodesWereInserted(TreeNode node, int[] childIndices) {
            super.nodesWereInserted(node, childIndices);
            if (node instanceof VisualizerNode && this.isSortingActive()) {
                this.sortChildren((VisualizerNode)node, false);
            }
        }

        public void nodesChanged(TreeNode node, int[] childIndices) {
            super.nodesChanged(node, childIndices);
            if (node != null && childIndices != null && this.isSortingActive()) {
                this.sortChildren((VisualizerNode)node, false);
            }
        }

        public void setRoot(TreeNode root) {
            super.setRoot(root);
            if (root instanceof VisualizerNode && this.isSortingActive()) {
                this.sortChildren((VisualizerNode)root, false);
            }
        }

        static /* synthetic */ boolean access$1300(SortedNodeTreeModel x0) {
            return x0.sortedByName;
        }

        static /* synthetic */ boolean access$1400(SortedNodeTreeModel x0) {
            return x0.sortAscending;
        }

        static /* synthetic */ Node.Property access$1500(SortedNodeTreeModel x0) {
            return x0.sortedByProperty;
        }

        static /* synthetic */ Node.Property access$1600(SortedNodeTreeModel x0, Node x1, Node.Property x2) {
            return x0.getNodeProperty(x1, x2);
        }

        private class SortingTask
        implements Runnable {
            private HashSet toSort = new HashSet();

            private SortingTask() {
            }

            public synchronized void add(VisualizerNode parent) {
                this.toSort.add(parent);
            }

            public synchronized void remove(VisualizerNode parent) {
                this.toSort.remove(parent);
            }

            public synchronized boolean isEmpty() {
                return this.toSort.isEmpty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SortedNodeTreeModel sortedNodeTreeModel = SortedNodeTreeModel.this;
                synchronized (sortedNodeTreeModel) {
                    SortedNodeTreeModel.this.sortingTask = null;
                }
                Iterator i = this.toSort.iterator();
                while (i.hasNext()) {
                    VisualizerNode curr = (VisualizerNode)i.next();
                    SortedNodeTreeModel.this.doSortChildren(curr);
                }
            }
        }
    }

    private class DefaultTreeAction
    implements ActionListener {
        DefaultTreeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Action a;
            if (TreeTableView.this.treeTable.getSelectedColumn() != ((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()) {
                return;
            }
            Node[] nodes = TreeTableView.this.manager.getSelectedNodes();
            if (nodes.length == 1 && (a = nodes[0].getPreferredAction()) != null) {
                if (a.isEnabled()) {
                    a.actionPerformed(new ActionEvent(nodes[0], 1001, ""));
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private static final class CompoundScrollPane
    extends JPanel
    implements Scrollable {
        CompoundScrollPane() {
        }

        public void setBorder(Border b) {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }
    }

    private final class ScrollListener
    extends ComponentAdapter
    implements PropertyChangeListener,
    ChangeListener {
        boolean movecorrection = false;

        ScrollListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex() == -1) {
                return;
            }
            if ("width".equals(evt.getPropertyName())) {
                if (!TreeTableView.this.treeTable.equals(evt.getSource())) {
                    Dimension dim = TreeTableView.this.hScrollBar.getPreferredSize();
                    dim.width = TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).getWidth();
                    TreeTableView.this.hScrollBar.setPreferredSize(dim);
                    TreeTableView.this.hScrollBar.revalidate();
                    TreeTableView.this.hScrollBar.repaint();
                }
                this.revalidateScrollBar();
            } else if ("positionX".equals(evt.getPropertyName())) {
                this.revalidateScrollBar();
            } else if ("treeColumnIndex".equals(evt.getPropertyName())) {
                TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).addPropertyChangeListener(TreeTableView.this.listener);
            } else if ("column_moved".equals(evt.getPropertyName())) {
                int from = (Integer)evt.getOldValue();
                int to = (Integer)evt.getNewValue();
                if (from == 0 || to == 0) {
                    if (this.movecorrection) {
                        this.movecorrection = false;
                    } else {
                        this.movecorrection = true;
                        TreeTableView.this.treeTable.getColumnModel().moveColumn(to, from);
                    }
                    return;
                }
                TreeTableView.this.treeTable.getTableHeader().getColumnModel().getColumn(from).setModelIndex(from);
                TreeTableView.this.treeTable.getTableHeader().getColumnModel().getColumn(to).setModelIndex(to);
                TreeTableView.this.tableModel.moveColumn(from - 1, to - 1);
            }
        }

        public void componentResized(ComponentEvent e) {
            this.revalidateScrollBar();
        }

        public void stateChanged(ChangeEvent evt) {
            int value = TreeTableView.this.hScrollBar.getModel().getValue();
            ((TreeTable)TreeTableView.this.treeTable).setPositionX(value);
        }

        private void revalidateScrollBar() {
            if (!TreeTableView.this.isDisplayable()) {
                return;
            }
            if (TreeTableView.this.treeTable.getColumnModel().getColumnCount() > 0 && ((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex() >= 0) {
                int extentWidth = TreeTableView.this.treeTable.getColumnModel().getColumn(((TreeTable)TreeTableView.this.treeTable).getTreeColumnIndex()).getWidth();
                int maxWidth = TreeTableView.this.tree.getPreferredSize().width;
                int extentHeight = ((TreeTableView)TreeTableView.this).scrollPane.getViewport().getSize().height;
                int maxHeight = TreeTableView.this.tree.getPreferredSize().height;
                int positionX = ((TreeTable)TreeTableView.this.treeTable).getPositionX();
                int value = Math.max(0, Math.min(positionX, maxWidth - extentWidth));
                boolean hsbvisible = TreeTableView.this.hScrollBar.isVisible();
                boolean vsbvisible = TreeTableView.this.scrollPane.getVerticalScrollBar().isVisible();
                int hsbheight = hsbvisible ? TreeTableView.this.hScrollBar.getHeight() : 0;
                int vsbwidth = TreeTableView.this.scrollPane.getVerticalScrollBar().getWidth();
                TreeTableView.this.hScrollBar.setValues(value, extentWidth, 0, maxWidth);
                if (TreeTableView.this.hideHScrollBar || maxWidth <= extentWidth || vsbvisible && maxHeight <= extentHeight + hsbheight && maxWidth <= extentWidth + vsbwidth) {
                    TreeTableView.this.hScrollBar.setVisible(false);
                } else {
                    TreeTableView.this.hScrollBar.setVisible(true);
                }
            }
        }
    }

    private class AccessibleTreeTableView
    extends JScrollPane.AccessibleJScrollPane {
        AccessibleTreeTableView() {
            super(TreeTableView.this);
        }

        public void setAccessibleName(String accessibleName) {
            super.setAccessibleName(accessibleName);
            if (TreeTableView.this.treeTable != null) {
                TreeTableView.this.treeTable.getAccessibleContext().setAccessibleName(accessibleName);
            }
        }

        public void setAccessibleDescription(String accessibleDescription) {
            super.setAccessibleDescription(accessibleDescription);
            if (TreeTableView.this.treeTable != null) {
                TreeTableView.this.treeTable.getAccessibleContext().setAccessibleDescription(accessibleDescription);
            }
        }
    }
}

