/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.io.NbMarshalledObject;

public class Repository
implements Serializable {
    private ArrayList fileSystems;
    private transient ArrayList fileSystemsClone;
    private FileSystem system;
    private Hashtable names;
    private transient FCLSupport fclSupport;
    private Hashtable listeners = new Hashtable();
    private VetoableChangeListener vetoListener = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
            if (ev.getPropertyName().equals("systemName")) {
                String ov = (String)ev.getOldValue();
                String nv = (String)ev.getNewValue();
                if (Repository.this.names.get(nv) != null) {
                    throw new PropertyVetoException("system name already exists: " + ov + " -> " + nv, ev);
                }
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("systemName")) {
                String ov = (String)ev.getOldValue();
                String nv = (String)ev.getNewValue();
                FileSystem fs = (FileSystem)ev.getSource();
                if (fs.isValid()) {
                    Repository.this.names.remove(ov);
                }
                Repository.this.names.put(nv, fs);
                fs.setValid(true);
            }
        }
    };
    static final long serialVersionUID = -6344768369160069704L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Repository(FileSystem def) {
        this.system = def;
        this.init();
    }

    public static Repository getDefault() {
        return ExternalUtil.getRepository();
    }

    private void init() {
        this.fileSystems = new ArrayList();
        this.names = new Hashtable();
        this.addFileSystem(this.system);
    }

    public final FileSystem getDefaultFileSystem() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileSystem(FileSystem fs) {
        boolean fireIt = false;
        Repository repository = this;
        synchronized (repository) {
            if (!fs.assigned && !this.fileSystems.contains(fs)) {
                boolean isReg;
                fs.setRepository(this);
                this.fileSystems.add(fs);
                this.fileSystemsClone = (ArrayList)this.fileSystems.clone();
                String systemName = fs.getSystemName();
                boolean bl = isReg = this.names.get(systemName) == null;
                if (isReg && !systemName.equals("")) {
                    this.names.put(systemName, fs);
                    fs.setValid(true);
                } else {
                    fs.setValid(false);
                }
                fs.assigned = true;
                fs.addPropertyChangeListener(this.propListener);
                fs.addVetoableChangeListener(this.vetoListener);
                fs.addNotify();
                fireIt = true;
            }
        }
        if (fireIt) {
            this.fireFileSystem(fs, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFileSystem(FileSystem fs) {
        boolean fireIt = false;
        Repository repository = this;
        synchronized (repository) {
            if (fs.isDefault()) {
                return;
            }
            fireIt = this.fileSystems.remove(fs);
            if (fireIt) {
                fs.setRepository(null);
                this.fileSystemsClone = (ArrayList)this.fileSystems.clone();
                if (fs.isValid()) {
                    this.names.remove(fs.getSystemName());
                    fs.setValid(false);
                }
                fs.removePropertyChangeListener(this.propListener);
                fs.removeVetoableChangeListener(this.vetoListener);
                fs.removeNotify();
            }
            fs.assigned = false;
        }
        if (fireIt) {
            this.fireFileSystem(fs, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reorder(int[] perm) {
        Repository repository = this;
        synchronized (repository) {
            if (perm == null) {
                throw new IllegalArgumentException("null permutation");
            }
            if (perm.length != this.fileSystems.size()) {
                throw new IllegalArgumentException("permutation is wrong size: " + perm.length + " elements but should be " + this.fileSystems.size());
            }
            if (!Repository.isPermutation(perm)) {
                StringBuffer message = new StringBuffer("permutation is not really a permutation:");
                for (int i = 0; i < perm.length; ++i) {
                    message.append(' ');
                    message.append(perm[i]);
                }
                throw new IllegalArgumentException(message.toString());
            }
            ArrayList newList = new ArrayList(this.fileSystems.size());
            int len = perm.length;
            for (int i = 0; i < len; ++i) {
                newList.add(this.fileSystems.get(perm[i]));
            }
            this.fileSystems = newList;
            this.fileSystemsClone = (ArrayList)this.fileSystems.clone();
        }
        this.fireFileSystemReordered(perm);
    }

    private static boolean isPermutation(int[] perm) {
        int len = perm.length;
        boolean[] bool = new boolean[len];
        try {
            for (int i = 0; i < len; ++i) {
                if (bool[perm[i]]) {
                    return false;
                }
                bool[perm[i]] = true;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public final Enumeration getFileSystems() {
        ArrayList tempFileSystems = this.fileSystemsClone;
        return Collections.enumeration(tempFileSystems);
    }

    public final Enumeration fileSystems() {
        return this.getFileSystems();
    }

    public final FileSystem[] toArray() {
        ArrayList tempFileSystems = this.fileSystemsClone;
        FileSystem[] fss = new FileSystem[tempFileSystems.size()];
        tempFileSystems.toArray(fss);
        return fss;
    }

    public final FileSystem findFileSystem(String systemName) {
        FileSystem fs = (FileSystem)this.names.get(systemName);
        return fs;
    }

    public final synchronized void writeExternal(ObjectOutput oos) throws IOException {
        Iterator iter = this.fileSystems.iterator();
        while (iter.hasNext()) {
            FileSystem fs = (FileSystem)iter.next();
            if (fs.isDefault() || fs.isPersistent()) continue;
            oos.writeObject(new NbMarshalledObject(fs));
        }
        oos.writeObject(null);
    }

    public final synchronized void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        FileSystem fs;
        Object obj;
        ArrayList<FileSystem> temp = new ArrayList<FileSystem>(10);
        while ((obj = ois.readObject()) != null) {
            if (obj instanceof FileSystem) {
                fs = (FileSystem)obj;
            } else {
                try {
                    NbMarshalledObject mar = (NbMarshalledObject)obj;
                    fs = (FileSystem)mar.get();
                }
                catch (IOException ex) {
                    ExternalUtil.exception(ex);
                    fs = null;
                }
                catch (ClassNotFoundException ex) {
                    ExternalUtil.exception(ex);
                    fs = null;
                }
            }
            if (fs == null) continue;
            temp.add(fs);
        }
        Enumeration ee = this.getFileSystems();
        while (ee.hasMoreElements()) {
            fs = (FileSystem)ee.nextElement();
            if (fs.isPersistent()) continue;
            this.removeFileSystem(fs);
        }
        this.system.assigned = false;
        this.init();
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            this.addFileSystem((FileSystem)iter.next());
        }
    }

    public final FileObject find(String aPackage, String name, String ext) {
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
        Enumeration en = this.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.find(aPackage, name, ext);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    public final FileObject findResource(String name) {
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
        Enumeration en = this.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.findResource(name);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    public final Enumeration findAllResources(String name) {
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
        Vector<FileObject> v = new Vector<FileObject>(8);
        Enumeration en = this.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.findResource(name);
            if (fo == null) continue;
            v.addElement(fo);
        }
        return v.elements();
    }

    public final Enumeration findAll(String aPackage, String name, String ext) {
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
        Enumeration en = this.getFileSystems();
        Vector<FileObject> ret = new Vector<FileObject>();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            FileObject fo = fs.find(aPackage, name, ext);
            if (fo == null) continue;
            ret.addElement(fo);
        }
        return ret.elements();
    }

    private void fireFileSystem(FileSystem fs, boolean add) {
        Enumeration en = ((Hashtable)this.listeners.clone()).elements();
        RepositoryEvent ev = new RepositoryEvent(this, fs, add);
        while (en.hasMoreElements()) {
            RepositoryListener list = (RepositoryListener)en.nextElement();
            if (add) {
                list.fileSystemAdded(ev);
                continue;
            }
            list.fileSystemRemoved(ev);
        }
    }

    private void fireFileSystemReordered(int[] perm) {
        Enumeration en = ((Hashtable)this.listeners.clone()).elements();
        RepositoryReorderedEvent ev = new RepositoryReorderedEvent(this, perm);
        while (en.hasMoreElements()) {
            RepositoryListener list = (RepositoryListener)en.nextElement();
            list.fileSystemPoolReordered(ev);
        }
    }

    public final void addRepositoryListener(RepositoryListener list) {
        this.listeners.put(list, list);
    }

    public final void removeRepositoryListener(RepositoryListener list) {
        this.listeners.remove(list);
    }

    private Object writeReplace() {
        return new Replacer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class clazz = FCLSupport.class;
        synchronized (clazz) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
        }
        return this.fclSupport;
    }

    public final void addFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().addFileChangeListener(fcl);
    }

    public final void removeFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().removeFileChangeListener(fcl);
    }

    static {
        $assertionsDisabled = !Repository.class.desiredAssertionStatus();
    }

    private static class Replacer
    implements Serializable {
        static final long serialVersionUID = -3814531276726840241L;

        Replacer() {
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            ExternalUtil.getRepository().writeExternal(oos);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ExternalUtil.getRepository().readExternal(ois);
        }

        public Object readResolve() {
            return ExternalUtil.getRepository();
        }
    }
}

