/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;

final class NodeLookup
extends AbstractLookup {
    private Collection queriedCookieClasses = new ArrayList();
    private Node node;
    static final ThreadLocal NO_COOKIE_CHANGE = new ThreadLocal();

    public NodeLookup(Node n) {
        this.node = n;
        this.addPair(new LookupItem(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCookie(Node node, Class c, Collection collection, Map fromPairToClass) {
        AbstractLookup.Pair pair;
        Node.Cookie res;
        Object prev = CookieSet.entryQueryMode(c);
        try {
            res = node.getCookie(c);
        }
        finally {
            pair = CookieSet.exitQueryMode(prev);
        }
        if (pair == null) {
            if (res == null) {
                return;
            }
            pair = new LookupItem(res);
        }
        collection.add(pair);
        fromPairToClass.put(pair, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void beforeLookup(Lookup.Template template) {
        Class type = template.getType();
        if (type == Object.class) {
            Set all;
            Object prev = null;
            try {
                prev = CookieSet.entryAllClassesMode();
                Node.Cookie ignoreResult = this.node.getCookie(Node.Cookie.class);
            }
            finally {
                all = CookieSet.exitAllClassesMode(prev);
            }
            Iterator it = all.iterator();
            while (it.hasNext()) {
                Class c = (Class)it.next();
                this.updateLookupAsCookiesAreChanged(c);
            }
            type = Node.Cookie.class;
        }
        if (Node.Cookie.class.isAssignableFrom(type) && !this.queriedCookieClasses.contains(type)) {
            this.updateLookupAsCookiesAreChanged(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookupAsCookiesAreChanged(Class toAdd) {
        HashMap<LookupItem, Class> fromPairToQueryClass;
        LinkedHashSet<LookupItem> instances;
        NodeLookup nodeLookup = this;
        synchronized (nodeLookup) {
            if (toAdd != null) {
                if (this.queriedCookieClasses.contains(toAdd)) {
                    return;
                }
                this.queriedCookieClasses.add(toAdd);
            }
            instances = new LinkedHashSet<LookupItem>(this.queriedCookieClasses.size());
            fromPairToQueryClass = new HashMap<LookupItem, Class>();
            Iterator it = this.queriedCookieClasses.iterator();
            LookupItem nodePair = new LookupItem(this.node);
            instances.add(nodePair);
            fromPairToQueryClass.put(nodePair, Node.class);
            while (it.hasNext()) {
                Class c = (Class)it.next();
                NodeLookup.addCookie(this.node, c, instances, fromPairToQueryClass);
            }
        }
        HashMap<LookupItem, Class> m = fromPairToQueryClass;
        ArrayList list = new ArrayList(instances);
        class Cmp
        implements Comparator {
            private final /* synthetic */ Map val$m;

            Cmp(Map val$m) {
                this.val$m = val$m;
            }

            public int compare(Object o1, Object o2) {
                Class c2;
                AbstractLookup.Pair p1 = (AbstractLookup.Pair)o1;
                AbstractLookup.Pair p2 = (AbstractLookup.Pair)o2;
                Class c1 = (Class)this.val$m.get(p1);
                if (c1.isAssignableFrom(c2 = (Class)this.val$m.get(p2))) {
                    return -1;
                }
                if (c2.isAssignableFrom(c1)) {
                    return 1;
                }
                if (c1.isAssignableFrom(p2.getType())) {
                    return -1;
                }
                if (c2.isAssignableFrom(p1.getType())) {
                    return 1;
                }
                return 0;
            }
        }
        Collections.sort(list, new Cmp(m));
        if (toAdd == null) {
            this.setPairs(list);
        } else {
            Object prev = NO_COOKIE_CHANGE.get();
            try {
                NO_COOKIE_CHANGE.set(this.node);
                this.setPairs(list);
            }
            finally {
                NO_COOKIE_CHANGE.set(prev);
            }
        }
    }

    private static class LookupItem
    extends AbstractLookup.Pair {
        private Object instance;

        public LookupItem(Object instance) {
            this.instance = instance;
        }

        public String getDisplayName() {
            return this.getId();
        }

        public String getId() {
            return this.instance.toString();
        }

        public Object getInstance() {
            return this.instance;
        }

        public Class getType() {
            return this.instance.getClass();
        }

        public boolean equals(Object object) {
            if (object instanceof LookupItem) {
                return this.instance == ((LookupItem)object).getInstance();
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        protected boolean creatorOf(Object obj) {
            return this.instance == obj;
        }

        protected boolean instanceOf(Class c) {
            return c.isInstance(this.instance);
        }
    }
}

