/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

final class DummyWindowManager
extends WindowManager {
    private static final long serialVersionUID = 1L;
    private final Map workspaces = new TreeMap();
    private transient Frame mw;
    private transient PropertyChangeSupport pcs;
    private transient R r;
    private static Action[] DEFAULT_ACTIONS_CLONEABLE;
    private static Action[] DEFAULT_ACTIONS_NOT_CLONEABLE;

    public DummyWindowManager() {
        this.createWorkspace("default", null);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    protected TopComponent.Registry componentRegistry() {
        TopComponent.Registry reg = super.componentRegistry();
        if (reg != null) {
            return reg;
        }
        return this.registry();
    }

    synchronized R registry() {
        if (this.r == null) {
            this.r = new R();
        }
        return this.r;
    }

    protected WindowManager.Component createTopComponentManager(TopComponent c) {
        return null;
    }

    public synchronized Workspace createWorkspace(String name, String displayName) {
        W w = new W(name);
        this.workspaces.put(name, w);
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
        return w;
    }

    synchronized void delete(Workspace w) {
        this.workspaces.remove(w.getName());
        if (this.workspaces.isEmpty()) {
            this.createWorkspace("default", null);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Workspace findWorkspace(String name) {
        return (Workspace)this.workspaces.get(name);
    }

    public synchronized Workspace getCurrentWorkspace() {
        return (Workspace)this.workspaces.values().iterator().next();
    }

    public synchronized Workspace[] getWorkspaces() {
        return this.workspaces.values().toArray(new Workspace[0]);
    }

    public synchronized void setWorkspaces(Workspace[] ws) {
        if (ws.length == 0) {
            throw new IllegalArgumentException();
        }
        this.workspaces.clear();
        for (int i = 0; i < ws.length; ++i) {
            this.workspaces.put(ws[i].getName(), ws[i]);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Frame getMainWindow() {
        if (this.mw == null) {
            this.mw = new JFrame("dummy");
        }
        return this.mw;
    }

    public void updateUI() {
    }

    public Set getModes() {
        HashSet s = new HashSet();
        Iterator it = new HashSet(this.workspaces.values()).iterator();
        while (it.hasNext()) {
            Workspace w = (Workspace)it.next();
            s.addAll(w.getModes());
        }
        return s;
    }

    public Mode findMode(TopComponent tc) {
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            Mode m = (Mode)it.next();
            if (!Arrays.asList(m.getTopComponents()).contains(tc)) continue;
            return m;
        }
        return null;
    }

    public Mode findMode(String name) {
        if (name == null) {
            return null;
        }
        Iterator it = this.getModes().iterator();
        while (it.hasNext()) {
            Mode m = (Mode)it.next();
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public TopComponentGroup findTopComponentGroup(String name) {
        return null;
    }

    public TopComponent findTopComponent(String tcID) {
        return null;
    }

    protected String topComponentID(TopComponent tc, String preferredID) {
        return preferredID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Action[] topComponentDefaultActions(TopComponent tc) {
        Class clazz = DummyWindowManager.class;
        synchronized (clazz) {
            if (tc instanceof TopComponent.Cloneable) {
                if (DEFAULT_ACTIONS_CLONEABLE == null) {
                    DEFAULT_ACTIONS_CLONEABLE = DummyWindowManager.loadActions(new String[]{"Save", "CloneView", null, "CloseView"});
                }
                return DEFAULT_ACTIONS_CLONEABLE;
            }
            if (DEFAULT_ACTIONS_NOT_CLONEABLE == null) {
                DEFAULT_ACTIONS_NOT_CLONEABLE = DummyWindowManager.loadActions(new String[]{"Save", null, "CloseView"});
            }
            return DEFAULT_ACTIONS_NOT_CLONEABLE;
        }
    }

    private static Action[] loadActions(String[] names) {
        ArrayList<SystemAction> arr = new ArrayList<SystemAction>();
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = DummyWindowManager.class.getClassLoader();
        }
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) {
                arr.add(null);
                continue;
            }
            try {
                arr.add(SystemAction.get(Class.forName("org.openide.actions." + names[i] + "Action")));
                continue;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
        return arr.toArray(new Action[0]);
    }

    protected boolean topComponentIsOpened(TopComponent tc) {
        return tc.isShowing();
    }

    protected void topComponentActivatedNodesChanged(TopComponent tc, Node[] nodes) {
        this.registry().setActivatedNodes(tc, nodes);
    }

    protected void topComponentIconChanged(TopComponent tc, Image icon) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tc);
        if (f != null) {
            f.setIconImage(icon);
        }
    }

    protected void topComponentToolTipChanged(TopComponent tc, String tooltip) {
    }

    protected void topComponentDisplayNameChanged(TopComponent tc, String displayName) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tc);
        if (f != null) {
            f.setTitle(displayName);
        }
    }

    protected void topComponentOpen(TopComponent tc) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tc);
        if (f == null) {
            f = new JFrame(tc.getName());
            Image icon = tc.getIcon();
            if (icon != null) {
                f.setIconImage(icon);
            }
            f.getContentPane().add(tc);
            f.pack();
            final WeakReference<TopComponent> ref = new WeakReference<TopComponent>(tc);
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent ev) {
                    TopComponent tc = (TopComponent)ref.get();
                    if (tc == null) {
                        return;
                    }
                    tc.close();
                }

                public void windowActivated(WindowEvent e) {
                    TopComponent tc = (TopComponent)ref.get();
                    if (tc == null) {
                        return;
                    }
                    tc.requestActive();
                }
            });
        }
        if (!tc.isShowing()) {
            this.componentOpenNotify(tc);
            this.componentShowing(tc);
            f.setVisible(true);
            this.registry().open(tc);
        }
    }

    protected void topComponentClose(TopComponent tc) {
        this.componentHidden(tc);
        this.componentCloseNotify(tc);
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tc);
        if (f != null) {
            f.setVisible(false);
            tc.getParent().remove(tc);
        }
        this.registry().close(tc);
        Iterator it = this.workspaces.values().iterator();
        while (it.hasNext()) {
            W w = (W)it.next();
            w.close(tc);
        }
    }

    protected void topComponentRequestVisible(TopComponent tc) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tc);
        if (f != null) {
            f.setVisible(true);
        }
    }

    protected void topComponentRequestActive(TopComponent tc) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, tc);
        if (f != null) {
            f.toFront();
        }
        this.registry().setActive(tc);
        this.activateComponent(tc);
    }

    protected void topComponentRequestAttention(TopComponent tc) {
    }

    protected void topComponentCancelRequestAttention(TopComponent tc) {
    }

    private static final class R
    implements TopComponent.Registry {
        private TopComponent active;
        private final Set opened = new HashSet();
        private Node[] nodes = new Node[0];
        private PropertyChangeSupport pcs;

        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(l);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(l);
            }
        }

        synchronized void open(TopComponent tc) {
            this.opened.add(tc);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
        }

        synchronized void close(TopComponent tc) {
            this.opened.remove(tc);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
            if (this.active == tc) {
                this.setActive(null);
            }
        }

        public synchronized Set getOpened() {
            return new HashSet(this.opened);
        }

        synchronized void setActive(TopComponent tc) {
            Node[] _nodes;
            this.active = tc;
            Node[] nodeArray = _nodes = tc == null ? new Node[]{} : tc.getActivatedNodes();
            if (_nodes != null) {
                this.nodes = _nodes;
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("activatedNodes", null, null);
                }
            }
            if (this.pcs != null) {
                this.pcs.firePropertyChange("activated", null, null);
                this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        synchronized void setActivatedNodes(TopComponent tc, Node[] _nodes) {
            if (tc == this.active) {
                if (_nodes != null) {
                    this.nodes = _nodes;
                    if (this.pcs != null) {
                        this.pcs.firePropertyChange("activatedNodes", null, null);
                    }
                }
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("currentNodes", null, null);
                }
            }
        }

        public TopComponent getActivated() {
            return this.active;
        }

        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        public synchronized Node[] getCurrentNodes() {
            if (this.active != null) {
                return this.active.getActivatedNodes();
            }
            return null;
        }
    }

    private final class W
    implements Workspace {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Map modes = new HashMap();
        private final Map modesByComponent = new WeakHashMap();
        private transient PropertyChangeSupport pcs;

        public W(String name) {
            this.name = name;
        }

        public void activate() {
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener list) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(list);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener list) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(list);
            }
        }

        public void remove() {
            DummyWindowManager.this.delete(this);
        }

        public synchronized Mode createMode(String name, String displayName, URL icon) {
            M m = new M(name);
            this.modes.put(name, m);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("modes", null, null);
            }
            return m;
        }

        public synchronized Set getModes() {
            return new HashSet(this.modes.values());
        }

        public synchronized Mode findMode(String name) {
            return (Mode)this.modes.get(name);
        }

        public synchronized Mode findMode(TopComponent c) {
            return (Mode)this.modesByComponent.get(c);
        }

        synchronized void dock(Mode m, TopComponent c) {
            this.modesByComponent.put(c, m);
        }

        public Rectangle getBounds() {
            return Utilities.getUsableScreenBounds();
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void close(TopComponent tc) {
            Iterator it = this.modes.values().iterator();
            while (it.hasNext()) {
                M m = (M)it.next();
                m.close(tc);
            }
        }

        private final class M
        implements Mode {
            private static final long serialVersionUID = 1L;
            private final String name;
            private final Set components = new HashSet();

            public M(String name) {
                this.name = name;
            }

            public void close(TopComponent tc) {
                this.components.remove(tc);
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
            }

            public boolean canDock(TopComponent tc) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized boolean dockInto(TopComponent c) {
                if (this.components.add(c)) {
                    Mode old = W.this.findMode(c);
                    if (old != null && old != this && old instanceof M) {
                        Mode mode = old;
                        synchronized (mode) {
                            ((M)old).components.remove(c);
                        }
                    }
                    W.this.dock(this, c);
                }
                return true;
            }

            public String getName() {
                return this.name;
            }

            public String getDisplayName() {
                return this.getName();
            }

            public Image getIcon() {
                return null;
            }

            public synchronized TopComponent[] getTopComponents() {
                return this.components.toArray(new TopComponent[0]);
            }

            public Workspace getWorkspace() {
                return W.this;
            }

            public synchronized Rectangle getBounds() {
                return W.this.getBounds();
            }

            public void setBounds(Rectangle s) {
            }

            public TopComponent getSelectedTopComponent() {
                TopComponent[] tcs = this.components.toArray(new TopComponent[0]);
                return tcs.length > 0 ? tcs[0] : null;
            }
        }
    }
}

