/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.ProfileWrapper;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTResultSetWrapper;
import sqlj.runtime.profile.ref.RTStatementWrapper;
import sqlj.runtime.profile.util.Auditor;

public class AuditedProfile
extends ProfileWrapper {
    Auditor m_auditor;
    private static final Object[] _aG_EMPTY_ARGS = new Object[0];

    public static ConnectedProfile newProfile(ConnectedProfile connectedProfile, Auditor auditor) {
        if (connectedProfile instanceof DynamicProfile) {
            return new Dynamic((DynamicProfile)connectedProfile, auditor);
        }
        return new AuditedProfile(connectedProfile, auditor);
    }

    public static DynamicProfile newProfile(DynamicProfile dynamicProfile, Auditor auditor) {
        return new Dynamic(dynamicProfile, auditor);
    }

    public AuditedProfile(ConnectedProfile connectedProfile, Auditor auditor) {
        super(connectedProfile);
        this.m_auditor = auditor;
    }

    public ProfileData getProfileData() {
        Object[] objectArray = _aG_EMPTY_ARGS;
        this.m_auditor.registerCall(this.baseProfile, "getProfileData", objectArray);
        ProfileData profileData = this.baseProfile.getProfileData();
        this.m_auditor.registerReturn(this.baseProfile, "getProfileData", profileData);
        return profileData;
    }

    public Connection getConnection() {
        Object[] objectArray = _aG_EMPTY_ARGS;
        this.m_auditor.registerCall(this.baseProfile, "getConnection", objectArray);
        Connection connection = this.baseProfile.getConnection();
        this.m_auditor.registerReturn(this.baseProfile, "getConnection", connection);
        return connection;
    }

    public RTStatement getStatement(int n2, BatchContext batchContext, Map map) throws SQLException {
        try {
            Object[] objectArray = new Object[]{new Integer(n2)};
            this.m_auditor.registerCall(this.baseProfile, "getStatement", objectArray);
            RTStatement rTStatement = this.baseProfile.getStatement(n2, batchContext, map);
            this.m_auditor.registerReturn(this.baseProfile, "getStatement", rTStatement);
            return new AuditedRTStatement(rTStatement, this.m_auditor);
        }
        catch (SQLException sQLException) {
            this.m_auditor.registerException(this.baseProfile, "getStatement", sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        try {
            Object[] objectArray = _aG_EMPTY_ARGS;
            this.m_auditor.registerCall(this.baseProfile, "close", objectArray);
            this.baseProfile.close();
            this.m_auditor.registerReturn(this.baseProfile, "close", Auditor.VOID_RETURN);
        }
        catch (SQLException sQLException) {
            this.m_auditor.registerException(this.baseProfile, "close", sQLException);
            throw sQLException;
        }
    }

    public static class AuditedRTCallableStatement
    extends AuditedRTStatement
    implements RTCallableStatement {
        private RTCallableStatement m_cstmt;
        private static final Object[] _aG_EMPTY_ARGS = new Object[0];

        public AuditedRTCallableStatement(RTCallableStatement rTCallableStatement, Auditor auditor) {
            super(rTCallableStatement, auditor);
            this.m_cstmt = rTCallableStatement;
        }

        public void registerOutParameter(int n2, int n3) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3)};
                this.m_auditor.registerCall(this.m_cstmt, "registerOutParameter", objectArray);
                this.m_cstmt.registerOutParameter(n2, n3);
                this.m_auditor.registerReturn(this.m_cstmt, "registerOutParameter", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.m_cstmt, "registerOutParameter", sQLException);
                throw sQLException;
            }
        }
    }

    public static class AuditedRTResultSet
    extends RTResultSetWrapper {
        private Auditor m_auditor;
        private static final Object[] _aG_EMPTY_ARGS = new Object[0];

        public AuditedRTResultSet(RTResultSet rTResultSet, Auditor auditor) {
            super(rTResultSet);
            this.m_auditor = auditor;
        }

        public ResultSet getJDBCResultSet() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "getJDBCResultSet", objectArray);
                ResultSet resultSet = this.rs.getJDBCResultSet();
                this.m_auditor.registerReturn(this.rs, "getJDBCResultSet", resultSet);
                return resultSet;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getJDBCResultSet", sQLException);
                throw sQLException;
            }
        }

        public boolean next() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "next", objectArray);
                boolean bl = this.rs.next();
                this.m_auditor.registerReturn(this.rs, "next", new Boolean(bl));
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "next", sQLException);
                throw sQLException;
            }
        }

        public String getCursorName() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "getCursorName", objectArray);
                String string = this.rs.getCursorName();
                this.m_auditor.registerReturn(this.rs, "getCursorName", string);
                return string;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getCursorName", sQLException);
                throw sQLException;
            }
        }

        public int findColumn(String string) throws SQLException {
            try {
                Object[] objectArray = new Object[]{string};
                this.m_auditor.registerCall(this.rs, "findColumn", objectArray);
                int n2 = this.rs.findColumn(string);
                this.m_auditor.registerReturn(this.rs, "findColumn", new Integer(n2));
                return n2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "findColumn", sQLException);
                throw sQLException;
            }
        }

        public String getString(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getString", objectArray);
                String string = this.rs.getString(n2);
                this.m_auditor.registerReturn(this.rs, "getString", string);
                return string;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getString", sQLException);
                throw sQLException;
            }
        }

        public byte[] getBytes(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getBytes", objectArray);
                byte[] byArray = this.rs.getBytes(n2);
                this.m_auditor.registerReturn(this.rs, "getBytes", byArray);
                return byArray;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getBytes", sQLException);
                throw sQLException;
            }
        }

        public Date getDate(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getDate", objectArray);
                Date date = this.rs.getDate(n2);
                this.m_auditor.registerReturn(this.rs, "getDate", date);
                return date;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getDate", sQLException);
                throw sQLException;
            }
        }

        public Time getTime(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getTime", objectArray);
                Time time = this.rs.getTime(n2);
                this.m_auditor.registerReturn(this.rs, "getTime", time);
                return time;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getTime", sQLException);
                throw sQLException;
            }
        }

        public Timestamp getTimestamp(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getTimestamp", objectArray);
                Timestamp timestamp = this.rs.getTimestamp(n2);
                this.m_auditor.registerReturn(this.rs, "getTimestamp", timestamp);
                return timestamp;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getTimestamp", sQLException);
                throw sQLException;
            }
        }

        public Boolean getBooleanWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getBooleanWrapper", objectArray);
                Boolean bl = this.rs.getBooleanWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getBooleanWrapper", bl);
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getBooleanWrapper", sQLException);
                throw sQLException;
            }
        }

        public Byte getByteWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getByteWrapper", objectArray);
                Byte by = this.rs.getByteWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getByteWrapper", by);
                return by;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getByteWrapper", sQLException);
                throw sQLException;
            }
        }

        public Short getShortWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getShortWrapper", objectArray);
                Short s2 = this.rs.getShortWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getShortWrapper", s2);
                return s2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getShortWrapper", sQLException);
                throw sQLException;
            }
        }

        public Integer getIntWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getIntWrapper", objectArray);
                Integer n3 = this.rs.getIntWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getIntWrapper", n3);
                return n3;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getIntWrapper", sQLException);
                throw sQLException;
            }
        }

        public Long getLongWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getLongWrapper", objectArray);
                Long l2 = this.rs.getLongWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getLongWrapper", l2);
                return l2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getLongWrapper", sQLException);
                throw sQLException;
            }
        }

        public Float getFloatWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getFloatWrapper", objectArray);
                Float f2 = this.rs.getFloatWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getFloatWrapper", f2);
                return f2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getFloatWrapper", sQLException);
                throw sQLException;
            }
        }

        public Double getDoubleWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getDoubleWrapper", objectArray);
                Double d2 = this.rs.getDoubleWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getDoubleWrapper", d2);
                return d2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getDoubleWrapper", sQLException);
                throw sQLException;
            }
        }

        public boolean getBooleanNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getBooleanNoNull", objectArray);
                boolean bl = this.rs.getBooleanNoNull(n2);
                this.m_auditor.registerReturn(this.rs, "getBooleanNoNull", new Boolean(bl));
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getBooleanNoNull", sQLException);
                throw sQLException;
            }
        }

        public byte getByteNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getByteNoNull", objectArray);
                byte by = this.rs.getByteNoNull(n2);
                this.m_auditor.registerReturn(this.rs, "getByteNoNull", new Byte(by));
                return by;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getByteNoNull", sQLException);
                throw sQLException;
            }
        }

        public short getShortNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getShortNoNull", objectArray);
                short s2 = this.rs.getShortNoNull(n2);
                this.m_auditor.registerReturn(this.rs, "getShortNoNull", new Short(s2));
                return s2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getShortNoNull", sQLException);
                throw sQLException;
            }
        }

        public int getIntNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getIntNoNull", objectArray);
                int n3 = this.rs.getIntNoNull(n2);
                this.m_auditor.registerReturn(this.rs, "getIntNoNull", new Integer(n3));
                return n3;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getIntNoNull", sQLException);
                throw sQLException;
            }
        }

        public long getLongNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getLongNoNull", objectArray);
                long l2 = this.rs.getLongNoNull(n2);
                this.m_auditor.registerReturn(this.rs, "getLongNoNull", new Long(l2));
                return l2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getLongNoNull", sQLException);
                throw sQLException;
            }
        }

        public float getFloatNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getFloatNoNull", objectArray);
                float f2 = this.rs.getFloatNoNull(n2);
                this.m_auditor.registerReturn(this.rs, "getFloatNoNull", new Float(f2));
                return f2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getFloatNoNull", sQLException);
                throw sQLException;
            }
        }

        public double getDoubleNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getDoubleNoNull", objectArray);
                double d2 = this.rs.getDoubleNoNull(n2);
                this.m_auditor.registerReturn(this.rs, "getDoubleNoNull", new Double(d2));
                return d2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getDoubleNoNull", sQLException);
                throw sQLException;
            }
        }

        public AsciiStream getAsciiStreamWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getAsciiStreamWrapper", objectArray);
                AsciiStream asciiStream = this.rs.getAsciiStreamWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getAsciiStreamWrapper", asciiStream);
                return asciiStream;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getAsciiStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public CharacterStream getCharacterStreamWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getCharacterStreamWrapper", objectArray);
                CharacterStream characterStream = this.rs.getCharacterStreamWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getCharacterStreamWrapper", characterStream);
                return characterStream;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getCharacterStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public UnicodeStream getUnicodeStreamWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getUnicodeStreamWrapper", objectArray);
                UnicodeStream unicodeStream = this.rs.getUnicodeStreamWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getUnicodeStreamWrapper", unicodeStream);
                return unicodeStream;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getUnicodeStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public BinaryStream getBinaryStreamWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getBinaryStreamWrapper", objectArray);
                BinaryStream binaryStream = this.rs.getBinaryStreamWrapper(n2);
                this.m_auditor.registerReturn(this.rs, "getBinaryStreamWrapper", binaryStream);
                return binaryStream;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getBinaryStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public Object getObject(int n2, Class clazz) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), clazz};
                this.m_auditor.registerCall(this.rs, "getObject", objectArray);
                Object object = this.rs.getObject(n2, clazz);
                this.m_auditor.registerReturn(this.rs, "getObject", object);
                return object;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getObject", sQLException);
                throw sQLException;
            }
        }

        public BigDecimal getBigDecimal(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getBigDecimal", objectArray);
                BigDecimal bigDecimal = this.rs.getBigDecimal(n2);
                this.m_auditor.registerReturn(this.rs, "getBigDecimal", bigDecimal);
                return bigDecimal;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getBigDecimal", sQLException);
                throw sQLException;
            }
        }

        public Blob getBlob(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getBlob", objectArray);
                Blob blob = this.rs.getBlob(n2);
                this.m_auditor.registerReturn(this.rs, "getBlob", blob);
                return blob;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getBlob", sQLException);
                throw sQLException;
            }
        }

        public Clob getClob(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getClob", objectArray);
                Clob clob = this.rs.getClob(n2);
                this.m_auditor.registerReturn(this.rs, "getClob", clob);
                return clob;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getClob", sQLException);
                throw sQLException;
            }
        }

        public Ref getRef(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.rs, "getRef", objectArray);
                Ref ref = this.rs.getRef(n2);
                this.m_auditor.registerReturn(this.rs, "getRef", ref);
                return ref;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getRef", sQLException);
                throw sQLException;
            }
        }

        public int getColumnCount() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "getColumnCount", objectArray);
                int n2 = this.rs.getColumnCount();
                this.m_auditor.registerReturn(this.rs, "getColumnCount", new Integer(n2));
                return n2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getColumnCount", sQLException);
                throw sQLException;
            }
        }

        public boolean isValidRow() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "isValidRow", objectArray);
                boolean bl = this.rs.isValidRow();
                this.m_auditor.registerReturn(this.rs, "isValidRow", new Boolean(bl));
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "isValidRow", sQLException);
                throw sQLException;
            }
        }

        public boolean isClosed() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "isClosed", objectArray);
                boolean bl = this.rs.isClosed();
                this.m_auditor.registerReturn(this.rs, "isClosed", new Boolean(bl));
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "isClosed", sQLException);
                throw sQLException;
            }
        }

        public SQLWarning getWarnings() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "getWarnings", objectArray);
                SQLWarning sQLWarning = this.rs.getWarnings();
                this.m_auditor.registerReturn(this.rs, "getWarnings", sQLWarning);
                return sQLWarning;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "getWarnings", sQLException);
                throw sQLException;
            }
        }

        public void clearWarnings() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "clearWarnings", objectArray);
                this.rs.clearWarnings();
                this.m_auditor.registerReturn(this.rs, "clearWarnings", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "clearWarnings", sQLException);
                throw sQLException;
            }
        }

        public void close() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.rs, "close", objectArray);
                this.rs.close();
                this.m_auditor.registerReturn(this.rs, "close", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.rs, "close", sQLException);
                throw sQLException;
            }
        }
    }

    public static class AuditedRTStatement
    extends RTStatementWrapper {
        protected Auditor m_auditor;
        private static final Object[] _aG_EMPTY_ARGS = new Object[0];

        public AuditedRTStatement(RTStatement rTStatement, Auditor auditor) {
            super(rTStatement);
            this.m_auditor = auditor;
        }

        public PreparedStatement getJDBCPreparedStatement() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getJDBCPreparedStatement", objectArray);
                PreparedStatement preparedStatement = this.stmt.getJDBCPreparedStatement();
                this.m_auditor.registerReturn(this.stmt, "getJDBCPreparedStatement", preparedStatement);
                return preparedStatement;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getJDBCPreparedStatement", sQLException);
                throw sQLException;
            }
        }

        public CallableStatement getJDBCCallableStatement() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getJDBCCallableStatement", objectArray);
                CallableStatement callableStatement = this.stmt.getJDBCCallableStatement();
                this.m_auditor.registerReturn(this.stmt, "getJDBCCallableStatement", callableStatement);
                return callableStatement;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getJDBCCallableStatement", sQLException);
                throw sQLException;
            }
        }

        public int getMaxFieldSize() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getMaxFieldSize", objectArray);
                int n2 = this.stmt.getMaxFieldSize();
                this.m_auditor.registerReturn(this.stmt, "getMaxFieldSize", new Integer(n2));
                return n2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getMaxFieldSize", sQLException);
                throw sQLException;
            }
        }

        public void setMaxFieldSize(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "setMaxFieldSize", objectArray);
                this.stmt.setMaxFieldSize(n2);
                this.m_auditor.registerReturn(this.stmt, "setMaxFieldSize", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setMaxFieldSize", sQLException);
                throw sQLException;
            }
        }

        public int getMaxRows() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getMaxRows", objectArray);
                int n2 = this.stmt.getMaxRows();
                this.m_auditor.registerReturn(this.stmt, "getMaxRows", new Integer(n2));
                return n2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getMaxRows", sQLException);
                throw sQLException;
            }
        }

        public void setMaxRows(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "setMaxRows", objectArray);
                this.stmt.setMaxRows(n2);
                this.m_auditor.registerReturn(this.stmt, "setMaxRows", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setMaxRows", sQLException);
                throw sQLException;
            }
        }

        public int getQueryTimeout() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getQueryTimeout", objectArray);
                int n2 = this.stmt.getQueryTimeout();
                this.m_auditor.registerReturn(this.stmt, "getQueryTimeout", new Integer(n2));
                return n2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getQueryTimeout", sQLException);
                throw sQLException;
            }
        }

        public void setQueryTimeout(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "setQueryTimeout", objectArray);
                this.stmt.setQueryTimeout(n2);
                this.m_auditor.registerReturn(this.stmt, "setQueryTimeout", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setQueryTimeout", sQLException);
                throw sQLException;
            }
        }

        public void setFetchSize(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "setFetchSize", objectArray);
                this.stmt.setFetchSize(n2);
                this.m_auditor.registerReturn(this.stmt, "setFetchSize", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setFetchSize", sQLException);
                throw sQLException;
            }
        }

        public void cancel() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "cancel", objectArray);
                this.stmt.cancel();
                this.m_auditor.registerReturn(this.stmt, "cancel", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "cancel", sQLException);
                throw sQLException;
            }
        }

        public SQLWarning getWarnings() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getWarnings", objectArray);
                SQLWarning sQLWarning = this.stmt.getWarnings();
                this.m_auditor.registerReturn(this.stmt, "getWarnings", sQLWarning);
                return sQLWarning;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getWarnings", sQLException);
                throw sQLException;
            }
        }

        public void clearWarnings() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "clearWarnings", objectArray);
                this.stmt.clearWarnings();
                this.m_auditor.registerReturn(this.stmt, "clearWarnings", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "clearWarnings", sQLException);
                throw sQLException;
            }
        }

        public ResultSet getResultSet() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getResultSet", objectArray);
                ResultSet resultSet = this.stmt.getResultSet();
                this.m_auditor.registerReturn(this.stmt, "getResultSet", resultSet);
                return resultSet;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getResultSet", sQLException);
                throw sQLException;
            }
        }

        public int getUpdateCount() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getUpdateCount", objectArray);
                int n2 = this.stmt.getUpdateCount();
                this.m_auditor.registerReturn(this.stmt, "getUpdateCount", new Integer(n2));
                return n2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getUpdateCount", sQLException);
                throw sQLException;
            }
        }

        public boolean getMoreResults() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "getMoreResults", objectArray);
                boolean bl = this.stmt.getMoreResults();
                this.m_auditor.registerReturn(this.stmt, "getMoreResults", new Boolean(bl));
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getMoreResults", sQLException);
                throw sQLException;
            }
        }

        public RTResultSet executeRTQuery() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "executeRTQuery", objectArray);
                RTResultSet rTResultSet = this.stmt.executeRTQuery();
                this.m_auditor.registerReturn(this.stmt, "executeRTQuery", rTResultSet);
                return new AuditedRTResultSet(rTResultSet, this.m_auditor);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "executeRTQuery", sQLException);
                throw sQLException;
            }
        }

        public int executeUpdate() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "executeUpdate", objectArray);
                int n2 = this.stmt.executeUpdate();
                this.m_auditor.registerReturn(this.stmt, "executeUpdate", new Integer(n2));
                return n2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "executeUpdate", sQLException);
                throw sQLException;
            }
        }

        public void setBoolean(int n2, boolean bl) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Boolean(bl)};
                this.m_auditor.registerCall(this.stmt, "setBoolean", objectArray);
                this.stmt.setBoolean(n2, bl);
                this.m_auditor.registerReturn(this.stmt, "setBoolean", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setBoolean", sQLException);
                throw sQLException;
            }
        }

        public void setByte(int n2, byte by) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Byte(by)};
                this.m_auditor.registerCall(this.stmt, "setByte", objectArray);
                this.stmt.setByte(n2, by);
                this.m_auditor.registerReturn(this.stmt, "setByte", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setByte", sQLException);
                throw sQLException;
            }
        }

        public void setShort(int n2, short s2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Short(s2)};
                this.m_auditor.registerCall(this.stmt, "setShort", objectArray);
                this.stmt.setShort(n2, s2);
                this.m_auditor.registerReturn(this.stmt, "setShort", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setShort", sQLException);
                throw sQLException;
            }
        }

        public void setInt(int n2, int n3) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Integer(n3)};
                this.m_auditor.registerCall(this.stmt, "setInt", objectArray);
                this.stmt.setInt(n2, n3);
                this.m_auditor.registerReturn(this.stmt, "setInt", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setInt", sQLException);
                throw sQLException;
            }
        }

        public void setLong(int n2, long l2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Long(l2)};
                this.m_auditor.registerCall(this.stmt, "setLong", objectArray);
                this.stmt.setLong(n2, l2);
                this.m_auditor.registerReturn(this.stmt, "setLong", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setLong", sQLException);
                throw sQLException;
            }
        }

        public void setFloat(int n2, float f2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Float(f2)};
                this.m_auditor.registerCall(this.stmt, "setFloat", objectArray);
                this.stmt.setFloat(n2, f2);
                this.m_auditor.registerReturn(this.stmt, "setFloat", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setFloat", sQLException);
                throw sQLException;
            }
        }

        public void setDouble(int n2, double d2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), new Double(d2)};
                this.m_auditor.registerCall(this.stmt, "setDouble", objectArray);
                this.stmt.setDouble(n2, d2);
                this.m_auditor.registerReturn(this.stmt, "setDouble", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setDouble", sQLException);
                throw sQLException;
            }
        }

        public void setBooleanWrapper(int n2, Boolean bl) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), bl};
                this.m_auditor.registerCall(this.stmt, "setBooleanWrapper", objectArray);
                this.stmt.setBooleanWrapper(n2, bl);
                this.m_auditor.registerReturn(this.stmt, "setBooleanWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setBooleanWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setByteWrapper(int n2, Byte by) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), by};
                this.m_auditor.registerCall(this.stmt, "setByteWrapper", objectArray);
                this.stmt.setByteWrapper(n2, by);
                this.m_auditor.registerReturn(this.stmt, "setByteWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setByteWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setShortWrapper(int n2, Short s2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), s2};
                this.m_auditor.registerCall(this.stmt, "setShortWrapper", objectArray);
                this.stmt.setShortWrapper(n2, s2);
                this.m_auditor.registerReturn(this.stmt, "setShortWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setShortWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setIntWrapper(int n2, Integer n3) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), n3};
                this.m_auditor.registerCall(this.stmt, "setIntWrapper", objectArray);
                this.stmt.setIntWrapper(n2, n3);
                this.m_auditor.registerReturn(this.stmt, "setIntWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setIntWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setLongWrapper(int n2, Long l2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), l2};
                this.m_auditor.registerCall(this.stmt, "setLongWrapper", objectArray);
                this.stmt.setLongWrapper(n2, l2);
                this.m_auditor.registerReturn(this.stmt, "setLongWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setLongWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setFloatWrapper(int n2, Float f2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), f2};
                this.m_auditor.registerCall(this.stmt, "setFloatWrapper", objectArray);
                this.stmt.setFloatWrapper(n2, f2);
                this.m_auditor.registerReturn(this.stmt, "setFloatWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setFloatWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setDoubleWrapper(int n2, Double d2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), d2};
                this.m_auditor.registerCall(this.stmt, "setDoubleWrapper", objectArray);
                this.stmt.setDoubleWrapper(n2, d2);
                this.m_auditor.registerReturn(this.stmt, "setDoubleWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setDoubleWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), bigDecimal};
                this.m_auditor.registerCall(this.stmt, "setBigDecimal", objectArray);
                this.stmt.setBigDecimal(n2, bigDecimal);
                this.m_auditor.registerReturn(this.stmt, "setBigDecimal", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setBigDecimal", sQLException);
                throw sQLException;
            }
        }

        public void setBlob(int n2, Blob blob) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), blob};
                this.m_auditor.registerCall(this.stmt, "setBlob", objectArray);
                this.stmt.setBlob(n2, blob);
                this.m_auditor.registerReturn(this.stmt, "setBlob", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setBlob", sQLException);
                throw sQLException;
            }
        }

        public void setClob(int n2, Clob clob) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), clob};
                this.m_auditor.registerCall(this.stmt, "setClob", objectArray);
                this.stmt.setClob(n2, clob);
                this.m_auditor.registerReturn(this.stmt, "setClob", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setClob", sQLException);
                throw sQLException;
            }
        }

        public void setRef(int n2, Ref ref) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), ref};
                this.m_auditor.registerCall(this.stmt, "setRef", objectArray);
                this.stmt.setRef(n2, ref);
                this.m_auditor.registerReturn(this.stmt, "setRef", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setRef", sQLException);
                throw sQLException;
            }
        }

        public void setString(int n2, String string) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), string};
                this.m_auditor.registerCall(this.stmt, "setString", objectArray);
                this.stmt.setString(n2, string);
                this.m_auditor.registerReturn(this.stmt, "setString", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setString", sQLException);
                throw sQLException;
            }
        }

        public void setBytes(int n2, byte[] byArray) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), byArray};
                this.m_auditor.registerCall(this.stmt, "setBytes", objectArray);
                this.stmt.setBytes(n2, byArray);
                this.m_auditor.registerReturn(this.stmt, "setBytes", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setBytes", sQLException);
                throw sQLException;
            }
        }

        public void setDate(int n2, Date date) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), date};
                this.m_auditor.registerCall(this.stmt, "setDate", objectArray);
                this.stmt.setDate(n2, date);
                this.m_auditor.registerReturn(this.stmt, "setDate", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setDate", sQLException);
                throw sQLException;
            }
        }

        public void setTime(int n2, Time time) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), time};
                this.m_auditor.registerCall(this.stmt, "setTime", objectArray);
                this.stmt.setTime(n2, time);
                this.m_auditor.registerReturn(this.stmt, "setTime", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setTime", sQLException);
                throw sQLException;
            }
        }

        public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), timestamp};
                this.m_auditor.registerCall(this.stmt, "setTimestamp", objectArray);
                this.stmt.setTimestamp(n2, timestamp);
                this.m_auditor.registerReturn(this.stmt, "setTimestamp", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setTimestamp", sQLException);
                throw sQLException;
            }
        }

        public void setAsciiStreamWrapper(int n2, AsciiStream asciiStream) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), asciiStream};
                this.m_auditor.registerCall(this.stmt, "setAsciiStreamWrapper", objectArray);
                this.stmt.setAsciiStreamWrapper(n2, asciiStream);
                this.m_auditor.registerReturn(this.stmt, "setAsciiStreamWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setAsciiStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setCharacterStreamWrapper(int n2, CharacterStream characterStream) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), characterStream};
                this.m_auditor.registerCall(this.stmt, "setCharacterStreamWrapper", objectArray);
                this.stmt.setCharacterStreamWrapper(n2, characterStream);
                this.m_auditor.registerReturn(this.stmt, "setCharacterStreamWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setCharacterStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setBinaryStreamWrapper(int n2, BinaryStream binaryStream) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), binaryStream};
                this.m_auditor.registerCall(this.stmt, "setBinaryStreamWrapper", objectArray);
                this.stmt.setBinaryStreamWrapper(n2, binaryStream);
                this.m_auditor.registerReturn(this.stmt, "setBinaryStreamWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setBinaryStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setUnicodeStreamWrapper(int n2, UnicodeStream unicodeStream) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), unicodeStream};
                this.m_auditor.registerCall(this.stmt, "setUnicodeStreamWrapper", objectArray);
                this.stmt.setUnicodeStreamWrapper(n2, unicodeStream);
                this.m_auditor.registerReturn(this.stmt, "setUnicodeStreamWrapper", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setUnicodeStreamWrapper", sQLException);
                throw sQLException;
            }
        }

        public void setObject(int n2, Object object) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), object};
                this.m_auditor.registerCall(this.stmt, "setObject", objectArray);
                this.stmt.setObject(n2, object);
                this.m_auditor.registerReturn(this.stmt, "setObject", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "setObject", sQLException);
                throw sQLException;
            }
        }

        public boolean execute() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "execute", objectArray);
                boolean bl = this.stmt.execute();
                this.m_auditor.registerReturn(this.stmt, "execute", new Boolean(bl));
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "execute", sQLException);
                throw sQLException;
            }
        }

        public String getString(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getString", objectArray);
                String string = this.stmt.getString(n2);
                this.m_auditor.registerReturn(this.stmt, "getString", string);
                return string;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getString", sQLException);
                throw sQLException;
            }
        }

        public byte[] getBytes(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getBytes", objectArray);
                byte[] byArray = this.stmt.getBytes(n2);
                this.m_auditor.registerReturn(this.stmt, "getBytes", byArray);
                return byArray;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getBytes", sQLException);
                throw sQLException;
            }
        }

        public Date getDate(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getDate", objectArray);
                Date date = this.stmt.getDate(n2);
                this.m_auditor.registerReturn(this.stmt, "getDate", date);
                return date;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getDate", sQLException);
                throw sQLException;
            }
        }

        public Time getTime(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getTime", objectArray);
                Time time = this.stmt.getTime(n2);
                this.m_auditor.registerReturn(this.stmt, "getTime", time);
                return time;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getTime", sQLException);
                throw sQLException;
            }
        }

        public Timestamp getTimestamp(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getTimestamp", objectArray);
                Timestamp timestamp = this.stmt.getTimestamp(n2);
                this.m_auditor.registerReturn(this.stmt, "getTimestamp", timestamp);
                return timestamp;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getTimestamp", sQLException);
                throw sQLException;
            }
        }

        public boolean getBooleanNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getBooleanNoNull", objectArray);
                boolean bl = this.stmt.getBooleanNoNull(n2);
                this.m_auditor.registerReturn(this.stmt, "getBooleanNoNull", new Boolean(bl));
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getBooleanNoNull", sQLException);
                throw sQLException;
            }
        }

        public byte getByteNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getByteNoNull", objectArray);
                byte by = this.stmt.getByteNoNull(n2);
                this.m_auditor.registerReturn(this.stmt, "getByteNoNull", new Byte(by));
                return by;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getByteNoNull", sQLException);
                throw sQLException;
            }
        }

        public short getShortNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getShortNoNull", objectArray);
                short s2 = this.stmt.getShortNoNull(n2);
                this.m_auditor.registerReturn(this.stmt, "getShortNoNull", new Short(s2));
                return s2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getShortNoNull", sQLException);
                throw sQLException;
            }
        }

        public int getIntNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getIntNoNull", objectArray);
                int n3 = this.stmt.getIntNoNull(n2);
                this.m_auditor.registerReturn(this.stmt, "getIntNoNull", new Integer(n3));
                return n3;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getIntNoNull", sQLException);
                throw sQLException;
            }
        }

        public long getLongNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getLongNoNull", objectArray);
                long l2 = this.stmt.getLongNoNull(n2);
                this.m_auditor.registerReturn(this.stmt, "getLongNoNull", new Long(l2));
                return l2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getLongNoNull", sQLException);
                throw sQLException;
            }
        }

        public float getFloatNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getFloatNoNull", objectArray);
                float f2 = this.stmt.getFloatNoNull(n2);
                this.m_auditor.registerReturn(this.stmt, "getFloatNoNull", new Float(f2));
                return f2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getFloatNoNull", sQLException);
                throw sQLException;
            }
        }

        public double getDoubleNoNull(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getDoubleNoNull", objectArray);
                double d2 = this.stmt.getDoubleNoNull(n2);
                this.m_auditor.registerReturn(this.stmt, "getDoubleNoNull", new Double(d2));
                return d2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getDoubleNoNull", sQLException);
                throw sQLException;
            }
        }

        public Boolean getBooleanWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getBooleanWrapper", objectArray);
                Boolean bl = this.stmt.getBooleanWrapper(n2);
                this.m_auditor.registerReturn(this.stmt, "getBooleanWrapper", bl);
                return bl;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getBooleanWrapper", sQLException);
                throw sQLException;
            }
        }

        public Byte getByteWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getByteWrapper", objectArray);
                Byte by = this.stmt.getByteWrapper(n2);
                this.m_auditor.registerReturn(this.stmt, "getByteWrapper", by);
                return by;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getByteWrapper", sQLException);
                throw sQLException;
            }
        }

        public Short getShortWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getShortWrapper", objectArray);
                Short s2 = this.stmt.getShortWrapper(n2);
                this.m_auditor.registerReturn(this.stmt, "getShortWrapper", s2);
                return s2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getShortWrapper", sQLException);
                throw sQLException;
            }
        }

        public Integer getIntWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getIntWrapper", objectArray);
                Integer n3 = this.stmt.getIntWrapper(n2);
                this.m_auditor.registerReturn(this.stmt, "getIntWrapper", n3);
                return n3;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getIntWrapper", sQLException);
                throw sQLException;
            }
        }

        public Long getLongWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getLongWrapper", objectArray);
                Long l2 = this.stmt.getLongWrapper(n2);
                this.m_auditor.registerReturn(this.stmt, "getLongWrapper", l2);
                return l2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getLongWrapper", sQLException);
                throw sQLException;
            }
        }

        public Float getFloatWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getFloatWrapper", objectArray);
                Float f2 = this.stmt.getFloatWrapper(n2);
                this.m_auditor.registerReturn(this.stmt, "getFloatWrapper", f2);
                return f2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getFloatWrapper", sQLException);
                throw sQLException;
            }
        }

        public Double getDoubleWrapper(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getDoubleWrapper", objectArray);
                Double d2 = this.stmt.getDoubleWrapper(n2);
                this.m_auditor.registerReturn(this.stmt, "getDoubleWrapper", d2);
                return d2;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getDoubleWrapper", sQLException);
                throw sQLException;
            }
        }

        public Object getObject(int n2, Class clazz) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2), clazz};
                this.m_auditor.registerCall(this.stmt, "getObject", objectArray);
                Object object = this.stmt.getObject(n2, clazz);
                this.m_auditor.registerReturn(this.stmt, "getObject", object);
                return object;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getObject", sQLException);
                throw sQLException;
            }
        }

        public BigDecimal getBigDecimal(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getBigDecimal", objectArray);
                BigDecimal bigDecimal = this.stmt.getBigDecimal(n2);
                this.m_auditor.registerReturn(this.stmt, "getBigDecimal", bigDecimal);
                return bigDecimal;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getBigDecimal", sQLException);
                throw sQLException;
            }
        }

        public Blob getBlob(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getBlob", objectArray);
                Blob blob = this.stmt.getBlob(n2);
                this.m_auditor.registerReturn(this.stmt, "getBlob", blob);
                return blob;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getBlob", sQLException);
                throw sQLException;
            }
        }

        public Clob getClob(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getClob", objectArray);
                Clob clob = this.stmt.getClob(n2);
                this.m_auditor.registerReturn(this.stmt, "getClob", clob);
                return clob;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getClob", sQLException);
                throw sQLException;
            }
        }

        public Ref getRef(int n2) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.stmt, "getRef", objectArray);
                Ref ref = this.stmt.getRef(n2);
                this.m_auditor.registerReturn(this.stmt, "getRef", ref);
                return ref;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "getRef", sQLException);
                throw sQLException;
            }
        }

        public void executeComplete() throws SQLException {
            try {
                Object[] objectArray = _aG_EMPTY_ARGS;
                this.m_auditor.registerCall(this.stmt, "executeComplete", objectArray);
                this.stmt.executeComplete();
                this.m_auditor.registerReturn(this.stmt, "executeComplete", Auditor.VOID_RETURN);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.stmt, "executeComplete", sQLException);
                throw sQLException;
            }
        }
    }

    public static class Dynamic
    extends AuditedProfile
    implements DynamicProfile {
        private DynamicProfile m_dProfile;
        private static final Object[] _aG_EMPTY_ARGS = new Object[0];

        public Dynamic(DynamicProfile dynamicProfile, Auditor auditor) {
            super(dynamicProfile, auditor);
            this.m_dProfile = dynamicProfile;
        }

        public boolean setWrappedProfile(ConnectedProfile connectedProfile) {
            if (connectedProfile instanceof DynamicProfile && super.setWrappedProfile(connectedProfile)) {
                this.m_dProfile = (DynamicProfile)connectedProfile;
                return true;
            }
            return false;
        }

        public RTStatement getStatement(int n2, BatchContext batchContext, Map map) throws SQLException {
            try {
                Object[] objectArray = new Object[]{new Integer(n2)};
                this.m_auditor.registerCall(this.baseProfile, "getStatement", objectArray);
                RTStatement rTStatement = this.baseProfile.getStatement(n2, batchContext, map);
                this.m_auditor.registerReturn(this.baseProfile, "getStatement", rTStatement);
                rTStatement = rTStatement instanceof RTCallableStatement ? new AuditedRTCallableStatement((RTCallableStatement)rTStatement, this.m_auditor) : new AuditedRTStatement(rTStatement, this.m_auditor);
                return rTStatement;
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.baseProfile, "getStatement", sQLException);
                throw sQLException;
            }
        }

        public RTStatement prepareStatement(String string) throws SQLException {
            try {
                Object[] objectArray = new Object[]{string};
                this.m_auditor.registerCall(this.m_dProfile, "prepareStatement", objectArray);
                RTStatement rTStatement = this.m_dProfile.prepareStatement(string);
                this.m_auditor.registerReturn(this.m_dProfile, "prepareStatement", rTStatement);
                return new AuditedRTStatement(rTStatement, this.m_auditor);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.m_dProfile, "prepareStatement", sQLException);
                throw sQLException;
            }
        }

        public RTCallableStatement prepareCall(String string) throws SQLException {
            try {
                Object[] objectArray = new Object[]{string};
                this.m_auditor.registerCall(this.m_dProfile, "prepareCall", objectArray);
                RTCallableStatement rTCallableStatement = this.m_dProfile.prepareCall(string);
                this.m_auditor.registerReturn(this.m_dProfile, "prepareCall", rTCallableStatement);
                return new AuditedRTCallableStatement(rTCallableStatement, this.m_auditor);
            }
            catch (SQLException sQLException) {
                this.m_auditor.registerException(this.m_dProfile, "prepareCall", sQLException);
                throw sQLException;
            }
        }
    }
}

