/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import com.sysuptime.common.graph.GraphConstants2;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.mainframe.graph.NetworkGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutSettings;

public abstract class JGraphLayoutAlgorithm {
    protected static Set LAYOUT_ATTRIBUTES = new HashSet();
    boolean isAllowedToRun = true;
    int progress = 0;
    int maximumProgress = 0;

    public JGraphLayoutSettings createSettings() {
        return null;
    }

    public String getHint() {
        return "";
    }

    public void run(JGraph graph, Object[] cells) {
        this.run(graph, cells, null);
    }

    public abstract void run(JGraph var1, Object[] var2, Object[] var3);

    public boolean isAllowedToRun() {
        return this.isAllowedToRun;
    }

    public void setAllowedToRun(boolean isAllowedToRun) {
        this.isAllowedToRun = isAllowedToRun;
    }

    public int getMaximumProgress() {
        return this.maximumProgress;
    }

    public void setMaximumProgress(int maximumProgress) {
        this.maximumProgress = maximumProgress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public static JDialog createDialog(JGraphLayoutSettings settings, JFrame parent, String title, String close, String apply) {
        if (settings instanceof Component) {
            return JGraphLayoutAlgorithm.populateDialog(settings, new JDialog(parent, title, true), close, apply);
        }
        return null;
    }

    public static JDialog createDialog(JGraphLayoutSettings settings, JDialog parent, String title, String close, String apply) {
        if (settings instanceof Component) {
            return JGraphLayoutAlgorithm.populateDialog(settings, new JDialog(parent, title, true), close, apply);
        }
        return null;
    }

    public static JDialog populateDialog(final JGraphLayoutSettings settings, final JDialog dialog, String close, String apply) {
        if (dialog != null && settings instanceof Component) {
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)settings, "Center");
            JButton cancelButton = new JButton(close);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            });
            JButton applyButton = new JButton(apply);
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    settings.apply();
                    dialog.dispose();
                }
            });
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            buttonPanel.add(applyButton);
            buttonPanel.add(cancelButton);
            dialog.getContentPane().add((Component)buttonPanel, "South");
            dialog.getRootPane().setDefaultButton(applyButton);
            return dialog;
        }
        return dialog;
    }

    public static void applyLayout(JGraph sourceGraph, JGraphLayoutAlgorithm layout, Object[] cells) {
        JGraphLayoutAlgorithm.applyLayout(sourceGraph, layout, cells, null);
    }

    public static void applyLayout(JGraph sourceGraph, JGraphLayoutAlgorithm layout, Object[] dynamic_cells, Object[] static_cells) {
        JGraph localGraph = new JGraph(sourceGraph.getModel());
        localGraph.setBounds(sourceGraph.getBounds());
        GraphLayoutCache cache = localGraph.getGraphLayoutCache();
        cache.setLocalAttributes(LAYOUT_ATTRIBUTES);
        layout.run(localGraph, dynamic_cells, static_cells);
        if (layout.isAllowedToRun()) {
            Hashtable<Object, AttributeMap> nested = new Hashtable<Object, AttributeMap>();
            CellView[] cellViews = cache.getAllDescendants(cache.getRoots());
            for (int i = 0; i < cellViews.length; ++i) {
                AttributeMap attrs = cellViews[i].getAttributes();
                Rectangle2D bounds = GraphConstants.getBounds((Map)attrs);
                if (cellViews[i] instanceof VertexView && bounds == null) {
                    GraphConstants.setBounds((Map)attrs, (Rectangle2D)cellViews[i].getBounds());
                }
                if (attrs.isEmpty()) continue;
                nested.put(cellViews[i].getCell(), attrs);
            }
            if (!nested.isEmpty()) {
                GraphLayoutCache sourceCache = sourceGraph.getGraphLayoutCache();
                sourceCache.edit(nested, null, null, null);
                if (sourceGraph instanceof NetworkGraph) {
                    NetworkGraph netGraph = (NetworkGraph)sourceGraph;
                    JGraphLayoutAlgorithm.setInvisible(nested, sourceCache);
                }
            }
        }
    }

    private static void setInvisible(Map nested, GraphLayoutCache cache) {
        if (nested != null && !nested.isEmpty()) {
            Vector<NetworkNode> invisibleNodes = new Vector<NetworkNode>();
            for (Map.Entry entry : nested.entrySet()) {
                Object value = entry.getValue();
                Object key = entry.getKey();
                if (!(value instanceof Map) || !(key instanceof NetworkNode)) continue;
                Map editAttribute = (Map)entry.getValue();
                NetworkNode node = (NetworkNode)entry.getKey();
                if (editAttribute != null && !GraphConstants2.isVisible((Map)editAttribute)) {
                    invisibleNodes.add(node);
                    continue;
                }
                AttributeMap nodeAttribute = node.getAttributes();
                if (nodeAttribute == null || GraphConstants2.isVisible((Map)nodeAttribute)) continue;
                invisibleNodes.add(node);
            }
            if (!invisibleNodes.isEmpty()) {
                cache.setVisible(invisibleNodes.toArray(), false);
            }
        }
    }

    static {
        LAYOUT_ATTRIBUTES.add("bounds");
        LAYOUT_ATTRIBUTES.add("points");
        LAYOUT_ATTRIBUTES.add("labelposition");
        LAYOUT_ATTRIBUTES.add("routing");
    }
}

