/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifiedElement;
import javax.wbem.cim.CIMValue;

public abstract class CIMObject
extends CIMQualifiedElement {
    protected Vector properties;
    protected Vector allproperties;
    private CIMObjectPath cop;

    protected CIMObject(String objectName) {
        super(objectName);
        this.cop = new CIMObjectPath(objectName, "");
        this.properties = new Vector();
        this.allproperties = new Vector();
        this.cop.setObjectName(objectName);
    }

    public CIMObjectPath getObjectPath() {
        this.cop.setObjectName(this.getName());
        return this.cop;
    }

    public void setObjectPath(CIMObjectPath op) {
        this.cop = (CIMObjectPath)op.clone();
    }

    public Vector getKeys() {
        Vector<Object> v = this.cop.getKeys();
        if (!v.isEmpty()) {
            return v;
        }
        v = new Vector<Object>();
        Enumeration eProps = this.properties.elements();
        while (eProps.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)eProps.nextElement();
            if (!pe.isKey() || pe.getOverridingProperty() != null) continue;
            v.add(pe.clone(false, true));
        }
        return v;
    }

    public Vector getProperties() {
        return this.properties;
    }

    public void setProperties(Vector properties) {
        this.properties = new Vector();
        this.allproperties = new Vector();
        if (properties != null) {
            Enumeration eProps = properties.elements();
            while (eProps.hasMoreElements()) {
                this.addProperty((CIMProperty)eProps.nextElement());
            }
        }
    }

    protected void addProperty(CIMProperty property) {
        if (property.getOverridingProperty() == null) {
            this.properties.addElement(property);
        }
        this.allproperties.addElement(property);
    }

    public void setProperty(String name, CIMValue value) throws CIMException {
        CIMProperty property = this.getProperty(name);
        if (property == null) {
            throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", name);
        }
        property.setValue(value);
    }

    public void updatePropertyValues(Vector properties) throws CIMException {
        Enumeration eProps = properties.elements();
        while (eProps.hasMoreElements()) {
            CIMProperty property = (CIMProperty)eProps.nextElement();
            this.updatePropertyValue(property);
        }
    }

    public void updatePropertyValue(CIMProperty property) throws CIMException {
        CIMProperty ipe = this.getProperty(property.getName(), property.getOriginClass());
        if (ipe == null) {
            throw new CIMException("CIM_ERR_NO_SUCH_PROPERTY", property.getOriginClass() + "." + property.getName());
        }
        ipe.setValue(property.getValue());
    }

    public CIMProperty getProperty(String name) {
        if (this.allproperties == null || name == null) {
            return null;
        }
        int i = name.indexOf(46);
        if (i != -1) {
            return this.getProperty(name.substring(i + 1, name.length()), name.substring(0, i));
        }
        int tempIndex = this.allproperties.indexOf(new CIMProperty(name));
        if (tempIndex == -1) {
            return null;
        }
        CIMProperty pe = (CIMProperty)this.allproperties.elementAt(tempIndex);
        String override = pe.getOverridingProperty();
        if (override != null) {
            pe = this.getProperty(override);
        }
        return pe;
    }

    public CIMProperty getProperty(String name, String originClass) {
        if (this.allproperties == null || name == null) {
            return null;
        }
        if (originClass == null || originClass.length() == 0) {
            return this.getProperty(name);
        }
        int size = this.allproperties.size();
        for (int i = 0; i < size; ++i) {
            CIMProperty pe = (CIMProperty)this.allproperties.elementAt(i);
            if (!pe.getName().equalsIgnoreCase(name) || !pe.getOriginClass().equalsIgnoreCase(originClass)) continue;
            if (pe.getOverridingProperty() != null) {
                return this.getProperty(pe.getOverridingProperty());
            }
            return pe;
        }
        return null;
    }

    protected Vector getFilteredProperties(String[] propertyList, boolean includeQualifier, boolean includeClassOrigin) {
        Vector<Object> propList;
        block3: {
            block2: {
                propList = null;
                if (propertyList != null) break block2;
                if (this.allproperties == null || this.allproperties.size() <= 0) break block3;
                propList = new Vector();
                Enumeration eProps = this.allproperties.elements();
                while (eProps.hasMoreElements()) {
                    CIMProperty pe = (CIMProperty)eProps.nextElement();
                    propList.add(pe.clone(includeQualifier, includeClassOrigin));
                }
                break block3;
            }
            HashSet<String> hm = new HashSet<String>();
            propList = new Vector<Object>();
            for (int i = 0; i < propertyList.length; ++i) {
                String propName;
                CIMProperty cp = this.getProperty(propertyList[i]);
                if (cp == null || hm.contains(propName = cp.getOriginClass() + "." + cp.getName())) continue;
                hm.add(propName);
                propList.add(cp.clone(includeQualifier, includeClassOrigin));
            }
        }
        return propList;
    }
}

