/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.security.AccessController;
import java.util.LinkedList;
import javax.wbem.client.adapter.http.transport.Executor;
import javax.wbem.client.adapter.http.transport.NewThreadAction;

final class ThreadPool
implements Executor {
    private static final long idleTimeout = 300000L;
    private ThreadGroup threadGroup;
    private final Object lock = new Object();
    private int totalThreads = 0;
    private int idleThreads = 0;
    private final LinkedList queue = new LinkedList();

    ThreadPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, String name) {
        Task task = new Task(runnable, name);
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() < this.idleThreads) {
                this.queue.addLast(task);
                this.lock.notify();
            } else {
                Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(task), name));
                t.start();
                ++this.totalThreads;
            }
        }
    }

    private class Worker
    implements Runnable {
        private Task first;

        Worker(Task first) {
            this.first = first;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Task task = this.first;
                this.first = null;
                while (true) {
                    task.runnable.run();
                    Object object = ThreadPool.this.lock;
                    synchronized (object) {
                        if (ThreadPool.this.queue.isEmpty()) {
                            Thread.currentThread().setName("HTTP Idle");
                            ThreadPool.this.idleThreads++;
                            try {
                                ThreadPool.this.lock.wait(300000L);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                ThreadPool.this.idleThreads--;
                            }
                            if (ThreadPool.this.queue.isEmpty()) {
                                break;
                            }
                        }
                        task = (Task)ThreadPool.this.queue.removeFirst();
                        Thread.currentThread().setName("HTTP " + task.name);
                    }
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Object object = ThreadPool.this.lock;
                synchronized (object) {
                    ThreadPool.this.totalThreads--;
                }
                throw throwable;
            }
            Object object = ThreadPool.this.lock;
            synchronized (object) {
                ThreadPool.this.totalThreads--;
            }
        }
    }

    private static class Task {
        final Runnable runnable;
        final String name;

        Task(Runnable runnable, String name) {
            this.runnable = runnable;
            this.name = name;
        }
    }
}

