/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ConfigureDB
implements ActionListener {
    static JFrame _frame;
    String _title = "Configure SysUpTime backend database";
    public static final String JAR_PATH;
    JLabel _dbNameLabel = new JLabel("Database Name:");
    LabelLink _description;
    JTextField _host = new JTextField();
    JTextField _port = new JTextField();
    JTextField _dbName = new JTextField();
    JTextField _user = new JTextField();
    JPasswordField _password = new JPasswordField();
    JButton _ok = new JButton("Ok");
    JButton _cancel = new JButton("Cancel");
    JRadioButton _sql = new JRadioButton("MS SQL Server");
    JRadioButton _oracle = new JRadioButton("Oracle");

    public static void main(String[] stringArray) throws IOException {
        ConfigureDB configureDB = new ConfigureDB();
        configureDB.init();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Cursor cursor = _frame.getCursor();
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            _frame.setTitle("Configuring database is in progress...");
            if (!this.verify()) {
                return;
            }
            this._ok.setEnabled(false);
            this._cancel.setEnabled(false);
            if (this.doIt(this._host.getText(), Integer.parseInt(this._port.getText()), this._dbName.getText(), this._user.getText(), this._password.getText(), this._sql.isSelected())) {
                if (ConfigureDB.isWindows()) {
                    try {
                        _frame.setTitle("Restarting SysUpTime Server...");
                        Process process = Runtime.getRuntime().exec("net stop sysuptime");
                        process.waitFor();
                        process = Runtime.getRuntime().exec("net start sysuptime");
                        process.waitFor();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    _frame.toFront();
                    JOptionPane.showMessageDialog(_frame, "Backend database has been changed successfully. SysUpTime server is being restarted...\nPlease wait about 1 minute for server to fully start.\nDouble click \"SysUpTime Web Client\" icon on your desktop to start the client.", "Success", 1);
                } else {
                    _frame.toFront();
                    JOptionPane.showMessageDialog(_frame, "Backend database has been changed successfully. You need to restart SysUpTime server.", "Success", 1);
                }
                System.exit(0);
            } else {
                JOptionPane.showMessageDialog(_frame, "Failed to update database.", "Error", 0);
            }
            _frame.setTitle(this._title);
            this._ok.setEnabled(true);
            this._cancel.setEnabled(true);
        } else if (object == this._cancel) {
            System.exit(0);
        } else if (object == this._sql) {
            this.selectSqlServer();
        } else if (object == this._oracle) {
            this.selectOracle();
        }
    }

    private boolean error(String string) {
        _frame.toFront();
        JOptionPane.showMessageDialog(_frame, string + " cannot be empty.", "Error", 0);
        return false;
    }

    private boolean verify() {
        if (this._host.getText().trim().length() == 0) {
            return this.error("Host");
        }
        if (this._port.getText().trim().length() == 0) {
            return this.error("Port");
        }
        if (this._dbName.getText().trim().length() == 0) {
            if (this._sql.isSelected()) {
                return this.error("Database name");
            }
            return this.error("SID");
        }
        if (this._user.getText().trim().length() == 0) {
            return this.error("User name");
        }
        boolean bl = false;
        try {
            int n = Integer.parseInt(this._port.getText());
            if (n <= 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            JOptionPane.showMessageDialog(_frame, "Port is not a positive number.", "Error", 0);
            return false;
        }
        return true;
    }

    private void selectSqlServer() {
        this._dbName.setText("sysuptimedb");
        this._port.setText("1433");
        this._dbNameLabel.setText("Database Name");
        if (this._description != null) {
            this._description.setVisible(true);
        }
    }

    private void selectOracle() {
        this._dbName.setText("XE");
        this._dbName.setToolTipText("Oracle System Identifier. XE is for Oracle Express");
        this._port.setText("1521");
        this._dbNameLabel.setText("SID");
        if (this._description != null) {
            this._description.setVisible(false);
        }
    }

    public static ImageIcon getImage(String string) {
        return new ImageIcon(ConfigureDB.class.getResource("/images/" + string));
    }

    private void init() {
        JFrame jFrame;
        _frame = jFrame = new JFrame();
        jFrame.setIconImage(ConfigureDB.getImage("app.gif").getImage());
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle(this._title);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add(this._host);
        jPanel2.add(this._port);
        jPanel2.add(this._user);
        jPanel2.add(this._password);
        jPanel2.add(this._dbName);
        jPanel2.setLayout(null);
        JLabel jLabel = null;
        int n = 16;
        int n2 = n + 5;
        int n3 = 120;
        int n4 = 200;
        int n5 = 10;
        int n6 = n3 + 20;
        int n7 = n + 10;
        this._sql.setSelected(true);
        this.selectSqlServer();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._sql);
        buttonGroup.add(this._oracle);
        jPanel2.add(this._sql);
        jPanel2.add(this._oracle);
        jLabel = new JLabel("Switch to:");
        jPanel2.add(jLabel);
        jLabel.setBounds(10, n5, n3, n);
        this._sql.setBounds(n6 - 3, n5, 130, n);
        this._oracle.setBounds(n6 + 140, n5, n3, n);
        this._sql.addActionListener(this);
        this._oracle.addActionListener(this);
        jLabel = new JLabel("Hostname or IP:");
        jPanel2.add(jLabel);
        jLabel.setBounds(10, n5 += n7 + 20, n3, n);
        this._host.setBounds(n6, n5, n4, n2);
        jLabel = new JLabel("Port:");
        jPanel2.add(jLabel);
        jLabel.setBounds(10, n5 += n7, n3, n);
        this._port.setBounds(n6, n5, n3, n);
        this._port.setBounds(n6, n5, n4, n2);
        jLabel = this._dbNameLabel;
        jPanel2.add(jLabel);
        jLabel.setBounds(10, n5 += n7, n3, n);
        this._dbName.setBounds(n6, n5, n3, n);
        this._dbName.setBounds(n6, n5, n4, n2);
        jLabel = new JLabel("User Name:");
        jPanel2.add(jLabel);
        jLabel.setBounds(10, n5 += n7, n3, n);
        this._user.setBounds(n6, n5, n3, n);
        this._user.setBounds(n6, n5, n4, n2);
        jLabel = new JLabel("Password:");
        jPanel2.add(jLabel);
        jLabel.setBounds(10, n5 += n7, n3, n);
        this._password.setBounds(n6, n5, n3, n);
        this._password.setBounds(n6, n5, n4, n2);
        this._description = new LabelLink("<html><u><i><font color=blue>TCP/IP must be enabled for SQL server. Click here for more info.</font></i></u>");
        this._description.addMouseListener(this._description);
        jPanel2.add(this._description);
        this._description.setBounds(10, n5 += n7 + n7, 450, n * 3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel2 = new JPanel();
        Dimension dimension = this._ok.getPreferredSize();
        dimension.setSize(90.0, dimension.getHeight());
        this._ok.setPreferredSize(dimension);
        jPanel2.add(this._ok);
        this._cancel.setPreferredSize(dimension);
        jPanel2.add(this._cancel);
        jPanel3.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        jFrame.setContentPane(jPanel);
        jFrame.setSize(480, 350);
        ConfigureDB.centerOnScreen(jFrame);
        jFrame.show();
        jFrame.toFront();
        this._host.requestFocus();
        jFrame.getRootPane().setDefaultButton(this._ok);
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
    }

    public static void centerOnScreen(Component component) {
        boolean bl = component.isVisible();
        component.setVisible(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        component.setLocation(n2, n);
        component.setVisible(bl);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(_frame, string, "Error", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doIt(String string, int n, String string2, String string3, String string4, boolean bl) {
        boolean bl2;
        Connection connection = null;
        if (bl) {
            int n2;
            if (!ConfigureDB.initDriver("net.sourceforge.jtds.jdbc.Driver")) {
                return false;
            }
            try {
                String string5 = "jdbc:jtds:sqlserver://" + string + ":" + n + "/" + string2;
                connection = ConfigureDB.getConnection("jdbc:jtds:sqlserver://" + string + ":" + n, string3, string4);
                n2 = this.createSqlServerDatabase(connection, string2);
                if (n2 == 0) {
                    boolean bl3 = false;
                    return bl3;
                }
                connection.close();
                if (n2 == 1 && !ConfigureDB.createTables(connection = ConfigureDB.getConnection(string5, string3, string4), true)) {
                    boolean bl4 = false;
                    return bl4;
                }
                this.writeXmlFile(string5, string3, string4, true);
                return true;
            }
            catch (Exception exception) {
                this.showError("Cannot connect to the database. Please check parameters.");
                exception.printStackTrace();
                n2 = 0;
                return n2 != 0;
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!ConfigureDB.initDriver("oracle.jdbc.driver.OracleDriver")) {
            return false;
        }
        try {
            String string6 = "jdbc:oracle:thin:@" + string + ":" + n + ":" + string2;
            connection = ConfigureDB.getConnection(string6, string3, string4);
            bl2 = this.checkOracleDatabase(connection);
            if (!bl2) {
                boolean bl5 = false;
                return bl5;
            }
            if (bl2 && !ConfigureDB.createTables(connection, false)) {
                boolean bl6 = false;
                return bl6;
            }
            this.writeXmlFile(string6, string3, string4, false);
            return true;
        }
        catch (Exception exception) {
            this.showError("Cannot connect to the database. Please check parameters.");
            exception.printStackTrace();
            bl2 = false;
            return bl2;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean writeXmlFile(String string, String string2, String string3, boolean bl) {
        try {
            String string4 = bl ? ConfigureDB.readFile("/resources/sqlserver-ds.xml") : ConfigureDB.readFile("/resources/oracle-ds.xml");
            string4 = ConfigureDB.replaceString(string4, "CONN_URL", string);
            string4 = ConfigureDB.replaceString(string4, "USER_NAME", string2);
            string4 = ConfigureDB.replaceString(string4, "PASSWORD", string3);
            this.deleteXmlFiles();
            String string5 = bl ? JAR_PATH + "/../deploy/sqlserver-ds.xml" : JAR_PATH + "/../deploy/oracle-ds.xml";
            ConfigureDB.writeFile(string5, string4);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            this.showError("Cannot update database configure files.");
            return false;
        }
        return true;
    }

    private void deleteXmlFiles() {
        String string = JAR_PATH + "/../deploy/derby-ds.xml";
        File file = new File(string);
        file.delete();
        string = JAR_PATH + "/../deploy/sqlserver-ds.xml";
        file = new File(string);
        file.delete();
        string = JAR_PATH + "/../deploy/oracle-ds.xml";
        file = new File(string);
        file.delete();
    }

    public int checkOracleDatabase(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, "%", "%", stringArray);
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_NAME").toUpperCase();
                if (string.indexOf("_") < 0 || !string.equalsIgnoreCase("FM_CATEGORY")) continue;
                int n = JOptionPane.showConfirmDialog(_frame, "SysUpTime's tables already exist.\nDo you want to delete all SysUpTime's tables and then recreate them?", "Warning", 0);
                if (0 == n) {
                    this.deleteOracleTables(connection);
                    return 1;
                }
                n = JOptionPane.showConfirmDialog(_frame, "So you want to keep existing data.\nDo you want to update SysUpTime's database configure file\nso that SysUpTime will use this backend database?", "Warning", 0);
                if (0 == n) {
                    return 2;
                }
                return 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOracleTables(Connection connection) {
        Statement statement = null;
        try {
            String string;
            InputStream inputStream = null;
            inputStream = ConfigureDB.class.getResourceAsStream("/resources/deleteall.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            statement = connection.createStatement();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.startsWith("--") || string.equals("/") || string.startsWith("exit;")) continue;
                if (string.endsWith(";") && string.indexOf("from dual") < 0) {
                    string = string.substring(0, string.length() - 1);
                    stringBuffer.append(string);
                    String string2 = stringBuffer.toString();
                    stringBuffer.delete(0, stringBuffer.length());
                    try {
                        statement.executeUpdate(string2);
                    }
                    catch (Exception exception) {
                        System.err.println("Failed to execute:" + string2);
                    }
                    continue;
                }
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int createSqlServerDatabase(Connection connection, String string) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getCatalogs();
            Statement statement = null;
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (!string.equals(string2)) continue;
                int n = JOptionPane.showConfirmDialog(_frame, "Database \"" + string + "\" already exists.\nDo you want to delete all data in in and recreate it?", "Warning", 0);
                if (0 == n) {
                    statement = connection.createStatement();
                    int n2 = statement.executeUpdate("DROP DATABASE " + string);
                    statement.close();
                    continue;
                }
                n = JOptionPane.showConfirmDialog(_frame, "So you want to keep existing data. Do you want to update SysUpTime's database configure file?", "Warning", 0);
                if (0 == n) {
                    return 2;
                }
                return 0;
            }
            statement = connection.createStatement();
            int n = statement.executeUpdate("CREATE DATABASE " + string);
            statement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createTables(Connection connection, boolean bl) {
        Statement statement = null;
        Object object = null;
        try {
            String string;
            connection.setAutoCommit(false);
            InputStream inputStream = null;
            inputStream = bl ? ConfigureDB.class.getResourceAsStream("/resources/sqlserver.txt") : ConfigureDB.class.getResourceAsStream("/resources/oracle.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            statement = connection.createStatement();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.startsWith("--") || string.equals("/") || string.startsWith("exit;")) continue;
                if (string.endsWith(";") && string.indexOf("from dual") < 0) {
                    string = string.substring(0, string.length() - 1);
                    stringBuffer.append(string);
                    object = stringBuffer.toString();
                    stringBuffer.delete(0, stringBuffer.length());
                    if (((String)object).indexOf("CREATE OR REPLACE TRIGGER") >= 0) {
                        object = (String)object + ";";
                    }
                    statement.executeUpdate((String)object);
                    continue;
                }
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
            connection.commit();
        }
        catch (Exception exception) {
            System.out.println("SQL:" + object);
            exception.printStackTrace();
            boolean bl2 = false;
            return bl2;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static boolean initDriver(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(_frame, "Internal error. Class not found.", "Error", 0);
            return false;
        }
    }

    public static Connection getConnection(String string, String string2, String string3) throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    static String getJarPath() {
        try {
            String string = ConfigureDB.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            string = URLDecoder.decode(string, "UTF-8");
            File file = new File(string);
            File file2 = ConfigureDB.getParentFile(file);
            return file2.getCanonicalPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String readFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            InputStream inputStream = ConfigureDB.class.getResourceAsStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[16384];
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) >= 0) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
            }
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static void writeFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        bufferedOutputStream.write(ConfigureDB.toBytes(string2));
        bufferedOutputStream.close();
    }

    public static String replaceString(String string, String string2, String string3) {
        int n;
        int n2 = 0;
        if ("".equals(string2) || string2 == null || string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        do {
            if ((n = string.indexOf(string2, n2)) == -1) {
                stringBuffer.append(string.substring(n2));
                break;
            }
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
        } while ((n2 = n + string2.length()) != string.length());
        return stringBuffer.toString();
    }

    public static byte[] toBytes(String string) {
        try {
            return string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static File getParentFile(File file) {
        if (file == null) {
            return null;
        }
        File file2 = new File(file.getAbsolutePath());
        if (file2 == null) {
            return null;
        }
        return file.getParentFile();
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toUpperCase();
        return string.indexOf("WINDOWS") >= 0;
    }

    static {
        JAR_PATH = ConfigureDB.getJarPath();
    }
}

