/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup;

import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.KeyValuePair;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.AbstractPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuGroupModel;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceColorSelectorPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorPopupMenuMultiRowSelector;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorPopupMenuSingleRowSelector;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorPanel;

public class JColorSelectorPopupMenu
extends AbstractPopupMenu {
    public static final String uiClassID = "ColorSelectorPopupMenuUI";
    private Projection<JColorSelectorPopupMenu, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> projection;
    private ColorSelectorPopupMenuContentModel contentModel;
    private ColorSelectorPopupMenuPresentationModel presentationModel;
    private int colorColumns;
    private JColorSelectorPanel lastColorSelectorPanel;
    private static LinkedList<Color> recentlySelected = new LinkedList();

    public JColorSelectorPopupMenu(Projection<JColorSelectorPopupMenu, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> projection) {
        this.projection = projection;
        this.contentModel = (ColorSelectorPopupMenuContentModel)projection.getContentModel();
        this.presentationModel = (ColorSelectorPopupMenuPresentationModel)projection.getPresentationModel();
        this.colorColumns = this.presentationModel.getColorColumns();
        this.populateContent();
        this.contentModel.addChangeListener(event -> this.populateContent());
        this.updateUI();
    }

    public Projection<JColorSelectorPopupMenu, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> getProjection() {
        return this.projection;
    }

    private void populateContent() {
        CommandButtonPresentationModel presentation = CommandButtonPresentationModel.builder().setPresentationState(this.presentationModel.getMenuPresentationState()).setMenu(true).build();
        List<ColorSelectorPopupMenuGroupModel> menuGroups = this.contentModel.getMenuGroups();
        for (int i = 0; i < menuGroups.size(); ++i) {
            ColorSelectorPopupMenuGroupModel menuGroup = menuGroups.get(i);
            for (KeyValuePair<ColorSelectorPopupMenuGroupModel.GroupEntryKind, Object> groupEntry : menuGroup.getGroupContent()) {
                switch (groupEntry.getKey()) {
                    case COMMAND: {
                        Command command = (Command)groupEntry.getValue();
                        AbstractCommandButton commandButton = (AbstractCommandButton)command.project(presentation).buildComponent();
                        if (!(commandButton instanceof JCommandButton)) break;
                        this.addMenuButton((JCommandButton)commandButton);
                        break;
                    }
                    case COLOR_SECTION: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel colorSectionModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addColorSection(colorSectionModel.getTitle(), colorSectionModel.getColors());
                        break;
                    }
                    case COLOR_SECTION_WITH_DERIVED: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel colorSectionWithDerivedModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addColorSectionWithDerived(colorSectionWithDerivedModel.getTitle(), colorSectionWithDerivedModel.getColors());
                        break;
                    }
                    case RECENTS_SECTION: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel recentsSectionModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addRecentSection(recentsSectionModel.getTitle());
                    }
                }
            }
            if (i >= menuGroups.size() - 1) continue;
            this.addMenuSeparator();
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceColorSelectorPopupMenuUI.createUI(this));
    }

    private void addColorSectionWithDerived(String label, Color[] primaryColors) {
        if (primaryColors == null || primaryColors.length != this.colorColumns) {
            throw new IllegalArgumentException("Must pass exactly " + this.colorColumns + " colors");
        }
        ColorSelectorPopupMenuMultiRowSelector selectorContainer = new ColorSelectorPopupMenuMultiRowSelector(this, primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    private void addColorSection(String label, Color[] primaryColors) {
        if (primaryColors == null || primaryColors.length != this.colorColumns) {
            throw new IllegalArgumentException("Must pass exactly " + this.colorColumns + " colors");
        }
        ColorSelectorPopupMenuSingleRowSelector selectorContainer = new ColorSelectorPopupMenuSingleRowSelector(this, primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    private void addRecentSection(String label) {
        ColorSelectorPopupMenuSingleRowSelector recent = new ColorSelectorPopupMenuSingleRowSelector(this, recentlySelected.toArray(new Color[0]));
        JColorSelectorPanel recentPanel = new JColorSelectorPanel(label, recent);
        recentPanel.setLastPanel(true);
        this.addMenuPanel(recentPanel);
        this.lastColorSelectorPanel = recentPanel;
    }

    @Override
    void addMenuButton(JCommandButton menuButton) {
        super.addMenuButton(menuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    void addMenuSeparator() {
        super.addMenuSeparator();
        this.updateLastColorSelectorPanel();
    }

    private void updateLastColorSelectorPanel() {
        if (this.lastColorSelectorPanel != null) {
            this.lastColorSelectorPanel.setLastPanel(true);
            this.lastColorSelectorPanel = null;
        }
    }

    public static synchronized List<Color> getRecentlyUsedColors() {
        return Collections.unmodifiableList(recentlySelected);
    }

    public static synchronized void addColorToRecentlyUsed(Color color) {
        if (recentlySelected.contains(color)) {
            recentlySelected.remove(color);
            recentlySelected.addLast(color);
            return;
        }
        if (recentlySelected.size() == 100) {
            recentlySelected.removeFirst();
        }
        recentlySelected.addLast(color);
    }
}

