/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;

public class PopupPanelManager {
    protected EventListenerList listenerList = new EventListenerList();
    private static final PopupPanelManager instance = new PopupPanelManager();
    protected LinkedList<PopupInfo> shownPath = new LinkedList();
    protected Map<JPopupPanel, Popup> popupPanels = new HashMap<JPopupPanel, Popup>();

    public static PopupPanelManager defaultManager() {
        return instance;
    }

    public void addPopup(JComponent popupOriginator, Popup popup, JPopupPanel popupInitiator) {
        popupInitiator.setInvoker(popupOriginator);
        this.popupPanels.put(popupInitiator, popup);
        this.shownPath.addLast(new PopupInfo(popupOriginator, popupInitiator));
        popup.show();
        if (popupOriginator instanceof JCommandButton) {
            ((JCommandButton)popupOriginator).getPopupModel().setPopupShowing(true);
        }
        this.firePopupShown(popupInitiator, popupOriginator);
    }

    public void hideLastPopup() {
        if (this.shownPath.size() == 0) {
            return;
        }
        PopupInfo last = this.shownPath.removeLast();
        Popup popup = this.popupPanels.get(last.popupPanel);
        popup.hide();
        this.popupPanels.remove(last.popupPanel);
        if (last.popupOriginator instanceof JCommandButton) {
            ((JCommandButton)last.popupOriginator).getPopupModel().setPopupShowing(false);
        }
        last.popupPanel.setInvoker(null);
        this.firePopupHidden(last.popupPanel, last.popupOriginator);
    }

    public void hidePopups(Component comp) {
        Popup popup;
        PopupInfo last;
        boolean foundAndDismissed = false;
        if (comp != null) {
            for (Component c = comp; c != null; c = c.getParent()) {
                if (!(c instanceof JPopupPanel)) continue;
                foundAndDismissed = true;
                while (this.shownPath.size() > 0) {
                    if (this.shownPath.getLast().popupPanel == c) {
                        return;
                    }
                    last = this.shownPath.removeLast();
                    popup = this.popupPanels.get(last.popupPanel);
                    popup.hide();
                    if (last.popupOriginator instanceof JCommandButton) {
                        ((JCommandButton)last.popupOriginator).getPopupModel().setPopupShowing(false);
                    }
                    last.popupPanel.setInvoker(null);
                    this.firePopupHidden(last.popupPanel, last.popupOriginator);
                    this.popupPanels.remove(last.popupPanel);
                }
            }
        }
        if (!foundAndDismissed || comp == null) {
            Component lastOriginator = null;
            while (this.shownPath.size() > 0) {
                last = this.shownPath.removeLast();
                lastOriginator = last.popupOriginator;
                popup = this.popupPanels.get(last.popupPanel);
                popup.hide();
                if (last.popupOriginator instanceof JCommandButton) {
                    ((JCommandButton)last.popupOriginator).getPopupModel().setPopupShowing(false);
                }
                last.popupPanel.setInvoker(null);
                this.firePopupHidden(last.popupPanel, last.popupOriginator);
                this.popupPanels.remove(last.popupPanel);
            }
            if (lastOriginator != null && lastOriginator.isFocusable()) {
                lastOriginator.requestFocus();
            }
        }
    }

    public List<PopupInfo> getShownPath() {
        return Collections.unmodifiableList(this.shownPath);
    }

    public void addPopupListener(PopupListener l) {
        this.listenerList.add(PopupListener.class, l);
    }

    public void removePopupListener(PopupListener l) {
        this.listenerList.remove(PopupListener.class, l);
    }

    protected void firePopupShown(JPopupPanel panel, JComponent popupOriginator) {
        Object[] listeners = this.listenerList.getListenerList();
        PopupEvent popupEvent = new PopupEvent(panel, 100, popupOriginator);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupListener.class) continue;
            ((PopupListener)listeners[i + 1]).popupShown(popupEvent);
        }
    }

    protected void firePopupHidden(JPopupPanel panel, JComponent popupOriginator) {
        Object[] listeners = this.listenerList.getListenerList();
        PopupEvent popupEvent = new PopupEvent(panel, 101, popupOriginator);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupListener.class) continue;
            ((PopupListener)listeners[i + 1]).popupHidden(popupEvent);
        }
    }

    public static class PopupInfo {
        private JPopupPanel popupPanel;
        private JComponent popupOriginator;

        public PopupInfo(JComponent popupOriginator, JPopupPanel popupPanel) {
            this.popupOriginator = popupOriginator;
            this.popupPanel = popupPanel;
        }

        public JPopupPanel getPopupPanel() {
            return this.popupPanel;
        }

        public JComponent getPopupOriginator() {
            return this.popupOriginator;
        }
    }

    public static class PopupEvent
    extends ComponentEvent {
        public static final int POPUP_SHOWN = 100;
        public static final int POPUP_HIDDEN = 101;
        private JComponent popupOriginator;

        public PopupEvent(JPopupPanel source, int id, JComponent popupOriginator) {
            super(source, id);
            this.popupOriginator = popupOriginator;
        }

        public JComponent getPopupOriginator() {
            return this.popupOriginator;
        }
    }

    public static interface PopupListener
    extends EventListener {
        public void popupShown(PopupEvent var1);

        public void popupHidden(PopupEvent var1);
    }
}

