/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.internal.ui.common.CircularProgressUI;
import org.pushingpixels.flamingo.internal.ui.common.JCircularProgress;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.callback.TimelineCallback;
import org.pushingpixels.trident.api.ease.Spline;
import org.pushingpixels.trident.api.ease.TimelineEase;
import org.pushingpixels.trident.api.swing.EventDispatchThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.api.swing.SwingComponentTimeline;
import org.pushingpixels.trident.api.swing.SwingRepaintCallback;

public abstract class BasicCircularProgressUI
extends CircularProgressUI {
    protected JCircularProgress circularProgress;
    protected double arcStart;
    protected double arcEnd;
    protected double arcSpan;
    protected Timeline arcTimeline;
    protected Timeline alphaTimeline;
    protected boolean goFromStart = true;
    protected float alpha = 0.0f;
    private PropertyChangeListener propertyChangeListener;

    @Override
    public void installUI(JComponent c) {
        this.circularProgress = (JCircularProgress)c;
        super.installUI(c);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(c);
        this.circularProgress = null;
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
        this.arcTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)this.circularProgress).addPropertyToInterpolate(Timeline.property((String)"arcSpan").getWith((obj, fieldName) -> this.arcSpan).setWith((obj, fieldName, value) -> {
            this.arcSpan = value;
        }).from((Object)30.0).to((Object)300.0))).setEase((TimelineEase)new Spline(0.5f))).setDuration(600L)).addCallback((TimelineCallback)new EventDispatchThreadTimelineCallbackAdapter(){

            private void update() {
                if (BasicCircularProgressUI.this.goFromStart) {
                    BasicCircularProgressUI.this.arcStart -= 8.0;
                    BasicCircularProgressUI.this.arcEnd = BasicCircularProgressUI.this.arcStart - BasicCircularProgressUI.this.arcSpan;
                } else {
                    BasicCircularProgressUI.this.arcEnd -= 8.0;
                    BasicCircularProgressUI.this.arcStart = BasicCircularProgressUI.this.arcEnd + BasicCircularProgressUI.this.arcSpan;
                }
                BasicCircularProgressUI.this.arcStart %= 360.0;
                BasicCircularProgressUI.this.arcEnd %= 360.0;
                BasicCircularProgressUI.this.circularProgress.repaint();
            }

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.PLAYING_REVERSE) {
                    BasicCircularProgressUI.this.goFromStart = false;
                }
                if (oldState == Timeline.TimelineState.PLAYING_REVERSE && newState == Timeline.TimelineState.PLAYING_FORWARD) {
                    BasicCircularProgressUI.this.goFromStart = true;
                }
                this.update();
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                this.update();
            }
        })).build();
        this.propertyChangeListener = evt -> {
            if (evt.getPropertyName().equals("visible") && ((Boolean)evt.getNewValue()).booleanValue()) {
                if (this.alphaTimeline != null && !this.alphaTimeline.isDone()) {
                    return;
                }
                this.alphaTimeline = ((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)this.circularProgress).addPropertyToInterpolate(Timeline.property((String)"alpha").getWith((obj, fieldName) -> Float.valueOf(this.alpha)).setWith((obj, fieldName, value) -> {
                    this.alpha = value.floatValue();
                }).fromCurrent().to((Object)Float.valueOf(1.0f)))).setEase((TimelineEase)new Spline(0.5f))).setDuration(100L)).addCallback((TimelineCallback)new SwingRepaintCallback((Component)this.circularProgress, null))).build();
                SwingUtilities.invokeLater(() -> {
                    this.arcTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
                    this.alphaTimeline.play();
                });
            }
        };
        this.circularProgress.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.circularProgress.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.alphaTimeline.abort();
        this.arcTimeline.abort();
    }

    protected void uninstallComponents() {
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Insets insets = this.circularProgress.getInsets();
        int width = this.circularProgress.getWidth() - insets.left - insets.right;
        int height = this.circularProgress.getHeight() - insets.top - insets.bottom;
        int diameter = Math.min(width, height) - 2;
        int dx = (width - diameter) / 2 + insets.left;
        int dy = (height - diameter) / 2 + insets.top;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setStroke(new BasicStroke(1.2f, 0, 1));
        Color baseColor = this.getColor();
        Color alphaColor = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), (int)((float)baseColor.getAlpha() * this.alpha));
        graphics.setColor(alphaColor);
        graphics.drawArc(dx, dy, diameter, diameter, (int)this.arcStart, -((int)this.arcSpan));
        graphics.dispose();
    }

    protected abstract Color getColor();
}

