/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.pushingpixels.flamingo.api.common.popup.JColorSelectorPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicColorSelectorPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorComponent;

public class ColorSelectorPopupMenuMultiRowSelector
extends JPanel {
    private static final int SECONDARY_ROWS = 5;
    private final int columnCount;

    public ColorSelectorPopupMenuMultiRowSelector(final JColorSelectorPopupMenu colorSelectorPopupMenu, final Color ... colors) {
        this.columnCount = colors.length;
        ColorSelectorPopupMenuContentModel contentModel = (ColorSelectorPopupMenuContentModel)colorSelectorPopupMenu.getProjection().getContentModel();
        final JColorSelectorComponent[][] comps = new JColorSelectorComponent[colors.length][6];
        for (int i = 0; i < colors.length; ++i) {
            Color primary = colors[i];
            comps[i][0] = new JColorSelectorComponent(primary, contentModel.getColorPreviewListener(), contentModel.getColorActivationListener());
            comps[i][0].addColorActivationListener(JColorSelectorPopupMenu::addColorToRecentlyUsed);
            this.add(comps[i][0]);
            float[] primaryHsb = new float[3];
            Color.RGBtoHSB(primary.getRed(), primary.getGreen(), primary.getBlue(), primaryHsb);
            for (int row = 1; row <= 5; ++row) {
                float bFactor = (float)(row - 1) / 5.0f;
                bFactor = (float)Math.pow(bFactor, 1.4f);
                float brightness = 1.0f - bFactor;
                if (primaryHsb[1] == 0.0f) {
                    float max = 0.5f + 0.5f * primaryHsb[2];
                    brightness = max * (float)(5 - row + 1) / 5.0f;
                }
                Color secondary = new Color(Color.HSBtoRGB(primaryHsb[0], primaryHsb[1] * (float)(row + 1) / 6.0f, brightness));
                comps[i][row] = new JColorSelectorComponent(secondary, contentModel.getColorPreviewListener(), contentModel.getColorActivationListener());
                comps[i][row].setTopOpen(row > 1);
                comps[i][row].setBottomOpen(row < 5);
                comps[i][row].addColorActivationListener(JColorSelectorPopupMenu::addColorToRecentlyUsed);
                this.add(comps[i][row]);
            }
        }
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(10, 10);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                int gap = ui.getColorSelectorCellGap();
                int size = ui.getColorSelectorCellSize();
                return new Dimension(colors.length * size + (colors.length + 1) * gap, gap + size + gap + 5 * size + gap);
            }

            @Override
            public void layoutContainer(Container parent) {
                BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                int gap = ui.getColorSelectorCellGap();
                int size = ui.getColorSelectorCellSize();
                if (parent.getComponentOrientation().isLeftToRight()) {
                    int y = gap;
                    for (int row = 0; row <= 5; ++row) {
                        int x = gap;
                        for (int i = 0; i < colors.length; ++i) {
                            comps[i][row].setBounds(x, y, size, size);
                            x += size + gap;
                        }
                        y += size;
                        if (row != 0) continue;
                        y += gap;
                    }
                } else {
                    int y = gap;
                    for (int row = 0; row <= 5; ++row) {
                        int x = ColorSelectorPopupMenuMultiRowSelector.this.getWidth() - gap;
                        for (int i = 0; i < colors.length; ++i) {
                            comps[i][row].setBounds(x - size, y, size, size);
                            x -= size + gap;
                        }
                        y += size;
                        if (row != 0) continue;
                        y += gap;
                    }
                }
            }
        });
    }

    public void focusOn(int row, int column) {
        this.getComponent(column * 6 + row).requestFocus();
    }

    private boolean focusMove(FocusMoveDirection focusMoveDirection) {
        for (int row = 0; row <= 5; ++row) {
            for (int column = 0; column < this.columnCount; ++column) {
                if (!this.getComponent(column * 6 + row).hasFocus()) continue;
                switch (focusMoveDirection) {
                    case UP: {
                        if (row > 0) {
                            this.focusOn(row - 1, column);
                            return true;
                        }
                        return false;
                    }
                    case DOWN: {
                        if (row < 5) {
                            this.focusOn(row + 1, column);
                            return true;
                        }
                        return false;
                    }
                    case LEFT: {
                        if (column > 0) {
                            this.focusOn(row, column - 1);
                            return true;
                        }
                        return false;
                    }
                    case RIGHT: {
                        if (column < this.columnCount - 1) {
                            this.focusOn(row, column + 1);
                            return true;
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public boolean focusUp() {
        return this.focusMove(FocusMoveDirection.UP);
    }

    public boolean focusDown() {
        return this.focusMove(FocusMoveDirection.DOWN);
    }

    public boolean focusRight() {
        return this.focusMove(FocusMoveDirection.RIGHT);
    }

    public boolean focusLeft() {
        return this.focusMove(FocusMoveDirection.LEFT);
    }

    public int getRowCount() {
        return 6;
    }

    private static enum FocusMoveDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

