/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRHtmlSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_HTM = ".htm";
    private static final String EXTENSION_HTML = ".html";
    public static final JRHtmlSaveContributor INSTANCE = new JRHtmlSaveContributor();

    public static JRHtmlSaveContributor getInstance() {
        return INSTANCE;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(EXTENSION_HTM) || name.endsWith(EXTENSION_HTML);
    }

    public String getDescription() {
        return "HTML (*.htm, *.html)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_HTM) && !file.getName().endsWith(EXTENSION_HTML)) {
            file = new File(file.getAbsolutePath() + EXTENSION_HTML);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName()), ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"), 2)) {
            JRHtmlExporter exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.exportReport();
        }
    }
}

