/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.pushingpixels.demo.flamingo.ExplorerFileViewPanel;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class FileExplorerStates
extends JFrame {
    private ExplorerFileViewPanel<File> filePanel;
    private BreadcrumbFileSelector bar = new BreadcrumbFileSelector();

    public FileExplorerStates() {
        super("File explorer");
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.filePanel = new ExplorerFileViewPanel(this.bar, CommandButtonPresentationState.BIG);
        JScrollPane fileListScrollPane = new JScrollPane((Component)((Object)this.filePanel));
        this.bar.getModel().addPathListener(event -> SwingUtilities.invokeLater(() -> {
            final List newPath = event.getSource().getItems();
            if (newPath.size() > 0) {
                SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                    @Override
                    protected List<StringValuePair<File>> doInBackground() throws Exception {
                        return FileExplorerStates.this.bar.getCallback().getLeafs(newPath);
                    }

                    @Override
                    protected void done() {
                        try {
                            FileExplorerStates.this.filePanel.setFolder((List)this.get());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                worker.execute();
            }
        }));
        JComboBox<CommandButtonPresentationState> states = new JComboBox<CommandButtonPresentationState>(new DefaultComboBoxModel<CommandButtonPresentationState>(new CommandButtonPresentationState[]{CommandButtonPresentationState.BIG, CommandButtonPresentationState.TILE, CommandButtonPresentationState.MEDIUM, CommandButtonPresentationState.SMALL}));
        states.addItemListener(e -> {
            CommandButtonPresentationState selected = (CommandButtonPresentationState)states.getSelectedItem();
            this.filePanel.cancelMainWorker();
            ((CommandPanelPresentationModel)this.filePanel.getProjection().getPresentationModel()).setCommandPresentationState(selected);
        });
        JPanel controls = new JPanel(new FlowLayout(2));
        controls.add(states);
        this.add((Component)controls, "South");
        this.add((Component)fileListScrollPane, "Center");
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            FileExplorerStates test = new FileExplorerStates();
            test.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
            test.setSize(500, 400);
            test.setLocationRelativeTo(null);
            test.setVisible(true);
            test.setDefaultCloseOperation(3);
        });
    }
}

