/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import java.awt.Color;
import java.awt.Graphics2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Font_x_generic;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.icon.DecoratedResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandPanelContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class QuickStylesPanel {
    public static CommandPanelContentModel getQuickStylesContentModel(ResourceBundle resourceBundle, Locale locale) {
        ArrayList<CommandGroup> commandGroups = new ArrayList<CommandGroup>();
        MessageFormat mf = new MessageFormat(resourceBundle.getString("PanelStyles.text"));
        mf.setLocale(locale);
        for (int groupIndex = 0; groupIndex < 4; ++groupIndex) {
            String commandGroupName = mf.format(new Object[]{groupIndex});
            ArrayList<Command> commands = new ArrayList<Command>();
            for (int i = 0; i < 15; ++i) {
                String deco = groupIndex + "/" + i;
                ResizableIcon.Factory iconFactory = DecoratedResizableIcon.factory((ResizableIcon.Factory)Font_x_generic.factory(), (DecoratedResizableIcon.IconDecorator[])new DecoratedResizableIcon.IconDecorator[]{(c, g, x, y, width, height) -> {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setColor(Color.black);
                    if (c.getComponentOrientation().isLeftToRight()) {
                        g2d.drawString(deco, x + 2, y + height - 2);
                    } else {
                        g2d.drawString(deco, x + width - g2d.getFontMetrics().stringWidth(deco) - 2, y + height - 2);
                    }
                    g2d.dispose();
                }});
                Command command = ((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(iconFactory)).setToggle()).setAction(e -> System.out.println("Invoked action on " + deco))).build();
                commands.add(command);
            }
            commandGroups.add(new CommandGroup(commandGroupName, commands));
        }
        CommandPanelContentModel commandPanelContentModel = new CommandPanelContentModel(commandGroups);
        commandPanelContentModel.setSingleSelectionMode(true);
        return commandPanelContentModel;
    }

    public static void updatePanelContentModel(CommandPanelContentModel model, ResourceBundle resourceBundle, Locale locale) {
        MessageFormat mf = new MessageFormat(resourceBundle.getString("PanelStyles.text"));
        mf.setLocale(locale);
        List commandGroups = model.getCommandGroups();
        for (int groupIndex = 0; groupIndex < commandGroups.size(); ++groupIndex) {
            CommandGroup commandGroup = (CommandGroup)commandGroups.get(groupIndex);
            String commandGroupName = mf.format(new Object[]{groupIndex});
            commandGroup.setTitle(commandGroupName);
        }
    }

    public static CommandPanelPresentationModel getQuickStylesPresentationModel() {
        return CommandPanelPresentationModel.builder().setToShowGroupLabels(false).setCommandPresentationState(CommandButtonPresentationState.FIT_TO_ICON).setCommandIconDimension(Integer.valueOf(48)).build();
    }
}

