/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Window;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.demo.flamingo.LocaleSwitcher;
import org.pushingpixels.demo.flamingo.SkinSwitcher;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Address_book_new;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Edit_copy;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Edit_cut;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Edit_paste;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Text_x_generic;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class TestCommandButtons
extends JFrame {
    ResourceBundle resourceBundle;
    Locale currLocale;
    protected Command pasteActionCommand;
    protected Command cutCommand;
    protected Command copyCommand;
    protected Command pastePopupCommand;
    private JPanel buttonPanel;

    TestCommandButtons() {
        super("Command button test");
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.setLayout(new BorderLayout());
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        this.configureControlPanel(controlPanel);
        this.add((Component)controlPanel, "South");
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
        this.pastePopupCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("SelectAll.text"))).setIconFactory(Edit_paste.factory())).setExtraText(this.resourceBundle.getString("SelectAll.textExtra"))).setSecondaryContentModel(this.getPopupMenuContentModel())).build();
        this.copyCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("Copy.text"))).setIconFactory(Edit_copy.factory())).setExtraText(this.resourceBundle.getString("Copy.textExtra"))).setAction(e -> System.out.println(TestCommandButtons.stamp() + ": Copy"))).setSecondaryContentModel(this.getPopupMenuContentModel())).build();
        this.cutCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("Cut.text"))).setIconFactory(Edit_cut.factory())).setExtraText(this.resourceBundle.getString("Cut.textExtra"))).setAction(e -> System.out.println(TestCommandButtons.stamp() + ": Cut"))).setSecondaryContentModel(this.getPopupMenuContentModel())).build();
        this.pasteActionCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("Paste.text"))).setIconFactory(Edit_paste.factory())).setDisabledIconFactory(() -> SubstanceCortex.GlobalScope.colorizeIconAsUiResource((ResizableIcon.Factory)Edit_paste.factory(), (SubstanceColorScheme)SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(null, ComponentState.DISABLED_UNSELECTED)))).setExtraText(this.resourceBundle.getString("Paste.textExtra"))).setAction(e -> System.out.println(TestCommandButtons.stamp() + ": Main paste"))).build();
        this.buttonPanel = this.getButtonPanel();
        this.add((Component)this.buttonPanel, "Center");
    }

    private CommandMenuContentModel getPopupMenuContentModel() {
        MessageFormat mf = new MessageFormat(this.resourceBundle.getString("TestMenuItem.text"));
        mf.setLocale(this.currLocale);
        ArrayList<Command> simpleEntries1 = new ArrayList<Command>();
        ArrayList<Command> simpleEntries2 = new ArrayList<Command>();
        simpleEntries1.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"1"}))).setIconFactory(Address_book_new.factory())).setAction(e -> System.out.println("Popup action 1"))).build());
        simpleEntries1.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"2"}))).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> System.out.println("Popup action 2"))).build());
        simpleEntries1.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"3"}))).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> System.out.println("Popup action 3"))).build());
        simpleEntries2.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"4"}))).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> System.out.println("Popup action 4"))).build());
        simpleEntries2.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"5"}))).setIconFactory(Text_x_generic.factory())).setAction(e -> System.out.println("Popup action 5"))).build());
        return new CommandMenuContentModel(Arrays.asList(new CommandGroup(simpleEntries1), new CommandGroup(simpleEntries2)));
    }

    private JPanel getButtonPanel() {
        FormBuilder builder = FormBuilder.create().columns("right:pref, 10dlu, center:pref, 4dlu,center:pref, 4dlu, center:pref, 4dlu, center:pref", new Object[0]).rows("p, $lg, p, $lg, p, $lg, p, $lg, p", new Object[0]).padding((EmptyBorder)Paddings.DIALOG);
        builder.add("Action only", new Object[0]).xy(3, 1);
        builder.add("Action (main) + popup", new Object[0]).xy(5, 1);
        builder.add("Action + popup (main)", new Object[0]).xy(7, 1);
        builder.add("Popup only", new Object[0]).xy(9, 1);
        this.addButtons(builder, CommandButtonPresentationState.BIG, 3);
        this.addButtons(builder, CommandButtonPresentationState.TILE, 5);
        this.addButtons(builder, CommandButtonPresentationState.MEDIUM, 7);
        this.addButtons(builder, CommandButtonPresentationState.SMALL, 9);
        return builder.build();
    }

    private static String stamp() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    private void addButtons(FormBuilder builder, CommandButtonPresentationState state, int row) {
        builder.add(state.getDisplayName() + " state", new Object[0]).xy(1, row);
        AbstractCommandButton actionButton = this.createActionButton(state);
        builder.add((Component)actionButton).xy(3, row);
        AbstractCommandButton actionAndPopupMainActionButton = this.createActionAndPopupMainActionButton(state);
        builder.add((Component)actionAndPopupMainActionButton).xy(5, row);
        AbstractCommandButton actionAndPopupMainPopupButton = this.createActionAndPopupMainPopupButton(state);
        builder.add((Component)actionAndPopupMainPopupButton).xy(7, row);
        AbstractCommandButton popupButton = this.createPopupButton(state);
        builder.add((Component)popupButton).xy(9, row);
    }

    protected void configurePresentationBuilder(CommandButtonPresentationModel.Builder builder) {
    }

    private AbstractCommandButton createPopupButton(CommandButtonPresentationState state) {
        CommandButtonPresentationModel.Builder presentationBuilder = CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false);
        this.configurePresentationBuilder(presentationBuilder);
        return (AbstractCommandButton)this.pastePopupCommand.project(presentationBuilder.build()).buildComponent();
    }

    private AbstractCommandButton createActionAndPopupMainPopupButton(CommandButtonPresentationState state) {
        CommandButtonPresentationModel.Builder presentationBuilder = CommandButtonPresentationModel.builder().setPresentationState(state).setTextClickPopup().setFlat(false);
        this.configurePresentationBuilder(presentationBuilder);
        return (AbstractCommandButton)this.copyCommand.project(presentationBuilder.build()).buildComponent();
    }

    private AbstractCommandButton createActionAndPopupMainActionButton(CommandButtonPresentationState state) {
        CommandButtonPresentationModel.Builder presentationBuilder = CommandButtonPresentationModel.builder().setPresentationState(state).setTextClickAction().setFlat(false);
        this.configurePresentationBuilder(presentationBuilder);
        return (AbstractCommandButton)this.cutCommand.project(presentationBuilder.build()).buildComponent();
    }

    private AbstractCommandButton createActionButton(CommandButtonPresentationState state) {
        CommandButtonPresentationModel.Builder presentationBuilder = CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false);
        this.configurePresentationBuilder(presentationBuilder);
        return (AbstractCommandButton)this.pasteActionCommand.project(presentationBuilder.build()).buildComponent();
    }

    protected void configureControlPanel(JPanel controlPanel) {
        controlPanel.add(SkinSwitcher.getSkinSwitcher(this));
        JCheckBox actionEnabled = new JCheckBox("action enabled");
        actionEnabled.setSelected(true);
        actionEnabled.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            this.copyCommand.setActionEnabled(actionEnabled.isSelected());
            this.cutCommand.setActionEnabled(actionEnabled.isSelected());
            this.pasteActionCommand.setActionEnabled(actionEnabled.isSelected());
            this.pastePopupCommand.setActionEnabled(actionEnabled.isSelected());
        }));
        controlPanel.add(actionEnabled);
        JCheckBox popupEnabled = new JCheckBox("popup enabled");
        popupEnabled.setSelected(true);
        popupEnabled.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            this.copyCommand.setSecondaryEnabled(popupEnabled.isSelected());
            this.cutCommand.setSecondaryEnabled(popupEnabled.isSelected());
            this.pasteActionCommand.setSecondaryEnabled(popupEnabled.isSelected());
            this.pastePopupCommand.setSecondaryEnabled(popupEnabled.isSelected());
        }));
        controlPanel.add(popupEnabled);
        JComboBox<LocaleSwitcher.LocaleInfo> localeSwitcher = LocaleSwitcher.getLocaleSwitcher(selected -> {
            this.currLocale = selected;
            this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", this.currLocale);
            this.remove(this.buttonPanel);
            this.buttonPanel = this.getButtonPanel();
            this.add((Component)this.buttonPanel, "Center");
            Window window = SwingUtilities.getWindowAncestor(this.buttonPanel);
            window.applyComponentOrientation(ComponentOrientation.getOrientation(this.currLocale));
            SwingUtilities.updateComponentTreeUI(window);
        });
        controlPanel.add(localeSwitcher);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            TestCommandButtons frame = new TestCommandButtons();
            frame.setSize(800, 400);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(2);
        });
    }
}

