/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.demo.flamingo.LocaleSwitcher;
import org.pushingpixels.demo.flamingo.SkinSwitcher;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Address_book_new;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Edit_paste;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Text_x_generic;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class TestCommandToggleButtons
extends JFrame {
    ResourceBundle resourceBundle;
    private Locale currLocale;
    private JPanel buttonPanel;
    protected Command toggleCommandShort;
    protected Command toggleCommandLong;
    protected Command toggleCommandLongWithSecondary;

    TestCommandToggleButtons() {
        super("Command button test");
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.setLayout(new BorderLayout());
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        this.configureControlPanel(controlPanel);
        this.toggleCommandShort = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("Short.text"))).setExtraText(this.resourceBundle.getString("SelectAll.textExtra"))).setIconFactory(Edit_paste.factory())).setDisabledIconFactory(FilteredResizableIcon.factory((ResizableIcon.Factory)Edit_paste.factory(), (BufferedImageOp)new ColorConvertOp(ColorSpace.getInstance(1003), null)))).setToggle()).setAction(e -> System.out.println(TestCommandToggleButtons.stamp() + ": command activated, selection state is " + e.getCommand().isToggleSelected()))).build();
        this.toggleCommandLong = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("LongerLines.text"))).setExtraText(this.resourceBundle.getString("SelectAll.textExtra"))).setIconFactory(Edit_paste.factory())).setDisabledIconFactory(FilteredResizableIcon.factory((ResizableIcon.Factory)Edit_paste.factory(), (BufferedImageOp)new ColorConvertOp(ColorSpace.getInstance(1003), null)))).setToggle()).setAction(e -> System.out.println(TestCommandToggleButtons.stamp() + ": command activated, selection state is " + e.getCommand().isToggleSelected()))).build();
        this.toggleCommandLongWithSecondary = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("LongerLines.text"))).setExtraText(this.resourceBundle.getString("SelectAll.textExtra"))).setIconFactory(Edit_paste.factory())).setDisabledIconFactory(FilteredResizableIcon.factory((ResizableIcon.Factory)Edit_paste.factory(), (BufferedImageOp)new ColorConvertOp(ColorSpace.getInstance(1003), null)))).setToggle()).setAction(e -> System.out.println(TestCommandToggleButtons.stamp() + ": command activated, selection state is " + e.getCommand().isToggleSelected()))).setSecondaryContentModel(this.getPopupMenuContentModel())).build();
        this.buttonPanel = this.getButtonPanel();
        this.add((Component)this.buttonPanel, "Center");
        this.add((Component)controlPanel, "South");
    }

    private CommandMenuContentModel getPopupMenuContentModel() {
        MessageFormat mf = new MessageFormat(this.resourceBundle.getString("TestMenuItem.text"));
        mf.setLocale(this.currLocale);
        ArrayList<Command> simpleEntries1 = new ArrayList<Command>();
        ArrayList<Command> simpleEntries2 = new ArrayList<Command>();
        simpleEntries1.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"1"}))).setIconFactory(Address_book_new.factory())).setAction(e -> System.out.println("Popup action 1"))).build());
        simpleEntries1.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"2"}))).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> System.out.println("Popup action 2"))).build());
        simpleEntries1.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"3"}))).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> System.out.println("Popup action 3"))).build());
        simpleEntries2.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"4"}))).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> System.out.println("Popup action 4"))).build());
        simpleEntries2.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"5"}))).setIconFactory(Text_x_generic.factory())).setAction(e -> System.out.println("Popup action 5"))).build());
        return new CommandMenuContentModel(Arrays.asList(new CommandGroup(simpleEntries1), new CommandGroup(simpleEntries2)));
    }

    private JPanel getButtonPanel() {
        FormBuilder builder = FormBuilder.create().columns("right:pref, 10dlu, center:pref, 4dlu, center:pref, 4dlu, center:pref", new Object[0]).rows("p, $lg, p, $lg, p, $lg, p, $lg, p", new Object[0]).padding((EmptyBorder)Paddings.DIALOG);
        builder.add("Short text", new Object[0]).xy(3, 1);
        builder.add("Long text", new Object[0]).xy(5, 1);
        this.addButtons(builder, CommandButtonPresentationState.BIG, 3);
        this.addButtons(builder, CommandButtonPresentationState.TILE, 5);
        this.addButtons(builder, CommandButtonPresentationState.MEDIUM, 7);
        this.addButtons(builder, CommandButtonPresentationState.SMALL, 9);
        return builder.getPanel();
    }

    static String stamp() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    private void addButtons(FormBuilder builder, CommandButtonPresentationState state, int row) {
        builder.add(state.getDisplayName() + " state", new Object[0]).xy(1, row);
        AbstractCommandButton buttonWithShortText = (AbstractCommandButton)this.toggleCommandShort.project(CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false).build()).buildComponent();
        builder.add((Component)buttonWithShortText).xy(3, row);
        AbstractCommandButton buttonWithLongText = (AbstractCommandButton)this.toggleCommandLong.project(CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false).build()).buildComponent();
        builder.add((Component)buttonWithLongText).xy(5, row);
        AbstractCommandButton buttonWithLongTextAndSecondary = (AbstractCommandButton)this.toggleCommandLongWithSecondary.project(CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false).build()).buildComponent();
        builder.add((Component)buttonWithLongTextAndSecondary).xy(7, row);
    }

    protected void configureControlPanel(JPanel controlPanel) {
        controlPanel.add(SkinSwitcher.getSkinSwitcher(this));
        JCheckBox actionEnabled = new JCheckBox("action enabled");
        actionEnabled.setSelected(true);
        actionEnabled.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            this.toggleCommandShort.setActionEnabled(actionEnabled.isSelected());
            this.toggleCommandLong.setActionEnabled(actionEnabled.isSelected());
        }));
        controlPanel.add(actionEnabled);
        JComboBox<LocaleSwitcher.LocaleInfo> localeSwitcher = LocaleSwitcher.getLocaleSwitcher(selected -> {
            this.currLocale = selected;
            this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
            this.remove(this.buttonPanel);
            this.buttonPanel = this.getButtonPanel();
            this.add((Component)this.buttonPanel, "Center");
            Window window = SwingUtilities.getWindowAncestor(this.buttonPanel);
            window.applyComponentOrientation(ComponentOrientation.getOrientation(this.currLocale));
            SwingUtilities.updateComponentTreeUI(window);
        });
        controlPanel.add(localeSwitcher);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            TestCommandToggleButtons frame = new TestCommandToggleButtons();
            frame.setSize(800, 400);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(2);
        });
    }
}

