/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CheckBoxListSelectionModel
extends DefaultListSelectionModel
implements ListDataListener {
    private static final long serialVersionUID = -4133723317923726786L;
    private ListModel _model;
    private boolean _allEntryConsidered = true;
    private int _allEntryIndex = -1;

    public CheckBoxListSelectionModel() {
        this.setSelectionMode(2);
    }

    public CheckBoxListSelectionModel(ListModel listModel) {
        this._model = listModel;
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
            this._model.addListDataListener(this);
        }
        this.setSelectionMode(2);
    }

    private int findAllEntryIndex() {
        if (this.getModel() == null) {
            return -1;
        }
        for (int i = this.getModel().getSize() - 1; i >= 0; --i) {
            if (!JideSwingUtilities.equals(this.getModel().getElementAt(i), "(All)")) continue;
            return i;
        }
        return -1;
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel listModel) {
        int n = 0;
        int n2 = 0;
        if (this._model != null) {
            n = this._model.getSize();
            this._model.removeListDataListener(this);
        }
        this._model = listModel;
        if (this._model != null) {
            n2 = this._model.getSize();
            this._model.removeListDataListener(this);
            if (this.isAllEntryConsidered()) {
                this._model.addListDataListener(this);
                this._allEntryIndex = this.findAllEntryIndex();
            } else {
                this._allEntryIndex = -1;
            }
        }
        if (n > n2) {
            this.removeIndexInterval(n2, n);
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
        }
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertIndexInterval(int n, int n2, boolean bl) {
        if (bl) {
            boolean bl2 = this.isSelectedIndex(n);
            super.setValueIsAdjusting(true);
            try {
                if (bl2) {
                    this.removeSelectionInterval(n, n);
                }
                super.insertIndexInterval(n, n2, bl);
                if (!bl2) return;
                this.addSelectionInterval(n + n2, n + n2);
                return;
            }
            finally {
                super.setValueIsAdjusting(false);
            }
        } else {
            super.insertIndexInterval(n, n2, bl);
        }
    }

    public boolean isAllEntryConsidered() {
        return this._allEntryConsidered;
    }

    public void setAllEntryConsidered(boolean bl) {
        this._allEntryConsidered = bl;
        if (this._model != null) {
            this._model.removeListDataListener(this);
        }
        if (this.isAllEntryConsidered()) {
            this._allEntryIndex = this.findAllEntryIndex();
            if (this._model != null) {
                this._model.addListDataListener(this);
            }
        } else {
            this._allEntryIndex = -1;
        }
    }

    public boolean isSelectedIndex(int n) {
        boolean bl = super.isSelectedIndex(n);
        return bl || this._allEntryIndex >= 0 && super.isSelectedIndex(this._allEntryIndex);
    }

    private boolean selectAll(int n, int n2) {
        if (this._allEntryIndex < 0) {
            return false;
        }
        if (n == 0 && n2 == this.getModel().getSize() - 1 || n2 == 0 && n == this.getModel().getSize() - 1) {
            return false;
        }
        if (n >= this._allEntryIndex && n2 <= this._allEntryIndex || n2 >= this._allEntryIndex && n <= this._allEntryIndex) {
            this.setSelectionInterval(0, this.getModel().getSize() - 1);
            return true;
        }
        return false;
    }

    private boolean unselectAll(int n, int n2) {
        if (this._allEntryIndex < 0) {
            return false;
        }
        if (n == this._allEntryIndex || n2 == this._allEntryIndex) {
            this.clearSelection();
            return true;
        }
        return false;
    }

    private void selectAllIf() {
        if (this._allEntryIndex < 0) {
            return;
        }
        for (int i = this.getModel().getSize() - 1; i >= 0; --i) {
            if (i == this._allEntryIndex || this.isSelectedIndex(i)) continue;
            return;
        }
        super.addSelectionInterval(this._allEntryIndex, this._allEntryIndex);
    }

    public void setSelectionInterval(int n, int n2) {
        if (!this.selectAll(n, n2)) {
            super.setSelectionInterval(n, n2);
            this.selectAllIf();
        }
    }

    public int getMinSelectionIndex() {
        int n = super.getMinSelectionIndex();
        if (this._allEntryIndex < 0) {
            return n;
        }
        if (super.isSelectedIndex(this._allEntryIndex) && this._allEntryIndex == 0) {
            return 1;
        }
        return n;
    }

    public void addSelectionInterval(int n, int n2) {
        if (!this.selectAll(n, n2)) {
            super.addSelectionInterval(n, n2);
            this.selectAllIf();
        }
    }

    public void removeSelectionInterval(int n, int n2) {
        if (!this.unselectAll(n, n2)) {
            if (this._allEntryIndex >= 0) {
                super.removeSelectionInterval(this._allEntryIndex, this._allEntryIndex);
            }
            super.removeSelectionInterval(n, n2);
        }
    }
}

